/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the action to take for a policy in an unused permissions finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedPermissionsRecommendedStep implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedPermissionsRecommendedStep.Builder, UnusedPermissionsRecommendedStep> {
    private static final SdkField<Instant> POLICY_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("policyUpdatedAt")
            .getter(getter(UnusedPermissionsRecommendedStep::policyUpdatedAt))
            .setter(setter(Builder::policyUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RECOMMENDED_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedAction").getter(getter(UnusedPermissionsRecommendedStep::recommendedActionAsString))
            .setter(setter(Builder::recommendedAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedAction").build()).build();

    private static final SdkField<String> RECOMMENDED_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendedPolicy").getter(getter(UnusedPermissionsRecommendedStep::recommendedPolicy))
            .setter(setter(Builder::recommendedPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedPolicy").build()).build();

    private static final SdkField<String> EXISTING_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingPolicyId").getter(getter(UnusedPermissionsRecommendedStep::existingPolicyId))
            .setter(setter(Builder::existingPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingPolicyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_UPDATED_AT_FIELD,
            RECOMMENDED_ACTION_FIELD, RECOMMENDED_POLICY_FIELD, EXISTING_POLICY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant policyUpdatedAt;

    private final String recommendedAction;

    private final String recommendedPolicy;

    private final String existingPolicyId;

    private UnusedPermissionsRecommendedStep(BuilderImpl builder) {
        this.policyUpdatedAt = builder.policyUpdatedAt;
        this.recommendedAction = builder.recommendedAction;
        this.recommendedPolicy = builder.recommendedPolicy;
        this.existingPolicyId = builder.existingPolicyId;
    }

    /**
     * <p>
     * The time at which the existing policy for the unused permissions finding was last updated.
     * </p>
     * 
     * @return The time at which the existing policy for the unused permissions finding was last updated.
     */
    public final Instant policyUpdatedAt() {
        return policyUpdatedAt;
    }

    /**
     * <p>
     * A recommendation of whether to create or detach a policy for an unused permissions finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recommendedAction}
     * will return {@link RecommendedRemediationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recommendedActionAsString}.
     * </p>
     * 
     * @return A recommendation of whether to create or detach a policy for an unused permissions finding.
     * @see RecommendedRemediationAction
     */
    public final RecommendedRemediationAction recommendedAction() {
        return RecommendedRemediationAction.fromValue(recommendedAction);
    }

    /**
     * <p>
     * A recommendation of whether to create or detach a policy for an unused permissions finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recommendedAction}
     * will return {@link RecommendedRemediationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #recommendedActionAsString}.
     * </p>
     * 
     * @return A recommendation of whether to create or detach a policy for an unused permissions finding.
     * @see RecommendedRemediationAction
     */
    public final String recommendedActionAsString() {
        return recommendedAction;
    }

    /**
     * <p>
     * If the recommended action for the unused permissions finding is to replace the existing policy, the contents of
     * the recommended policy to replace the policy specified in the <code>existingPolicyId</code> field.
     * </p>
     * 
     * @return If the recommended action for the unused permissions finding is to replace the existing policy, the
     *         contents of the recommended policy to replace the policy specified in the <code>existingPolicyId</code>
     *         field.
     */
    public final String recommendedPolicy() {
        return recommendedPolicy;
    }

    /**
     * <p>
     * If the recommended action for the unused permissions finding is to detach a policy, the ID of an existing policy
     * to be detached.
     * </p>
     * 
     * @return If the recommended action for the unused permissions finding is to detach a policy, the ID of an existing
     *         policy to be detached.
     */
    public final String existingPolicyId() {
        return existingPolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendedPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(existingPolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedPermissionsRecommendedStep)) {
            return false;
        }
        UnusedPermissionsRecommendedStep other = (UnusedPermissionsRecommendedStep) obj;
        return Objects.equals(policyUpdatedAt(), other.policyUpdatedAt())
                && Objects.equals(recommendedActionAsString(), other.recommendedActionAsString())
                && Objects.equals(recommendedPolicy(), other.recommendedPolicy())
                && Objects.equals(existingPolicyId(), other.existingPolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedPermissionsRecommendedStep").add("PolicyUpdatedAt", policyUpdatedAt())
                .add("RecommendedAction", recommendedActionAsString()).add("RecommendedPolicy", recommendedPolicy())
                .add("ExistingPolicyId", existingPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyUpdatedAt":
            return Optional.ofNullable(clazz.cast(policyUpdatedAt()));
        case "recommendedAction":
            return Optional.ofNullable(clazz.cast(recommendedActionAsString()));
        case "recommendedPolicy":
            return Optional.ofNullable(clazz.cast(recommendedPolicy()));
        case "existingPolicyId":
            return Optional.ofNullable(clazz.cast(existingPolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnusedPermissionsRecommendedStep, T> g) {
        return obj -> g.apply((UnusedPermissionsRecommendedStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedPermissionsRecommendedStep> {
        /**
         * <p>
         * The time at which the existing policy for the unused permissions finding was last updated.
         * </p>
         * 
         * @param policyUpdatedAt
         *        The time at which the existing policy for the unused permissions finding was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyUpdatedAt(Instant policyUpdatedAt);

        /**
         * <p>
         * A recommendation of whether to create or detach a policy for an unused permissions finding.
         * </p>
         * 
         * @param recommendedAction
         *        A recommendation of whether to create or detach a policy for an unused permissions finding.
         * @see RecommendedRemediationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendedRemediationAction
         */
        Builder recommendedAction(String recommendedAction);

        /**
         * <p>
         * A recommendation of whether to create or detach a policy for an unused permissions finding.
         * </p>
         * 
         * @param recommendedAction
         *        A recommendation of whether to create or detach a policy for an unused permissions finding.
         * @see RecommendedRemediationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendedRemediationAction
         */
        Builder recommendedAction(RecommendedRemediationAction recommendedAction);

        /**
         * <p>
         * If the recommended action for the unused permissions finding is to replace the existing policy, the contents
         * of the recommended policy to replace the policy specified in the <code>existingPolicyId</code> field.
         * </p>
         * 
         * @param recommendedPolicy
         *        If the recommended action for the unused permissions finding is to replace the existing policy, the
         *        contents of the recommended policy to replace the policy specified in the
         *        <code>existingPolicyId</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedPolicy(String recommendedPolicy);

        /**
         * <p>
         * If the recommended action for the unused permissions finding is to detach a policy, the ID of an existing
         * policy to be detached.
         * </p>
         * 
         * @param existingPolicyId
         *        If the recommended action for the unused permissions finding is to detach a policy, the ID of an
         *        existing policy to be detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingPolicyId(String existingPolicyId);
    }

    static final class BuilderImpl implements Builder {
        private Instant policyUpdatedAt;

        private String recommendedAction;

        private String recommendedPolicy;

        private String existingPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedPermissionsRecommendedStep model) {
            policyUpdatedAt(model.policyUpdatedAt);
            recommendedAction(model.recommendedAction);
            recommendedPolicy(model.recommendedPolicy);
            existingPolicyId(model.existingPolicyId);
        }

        public final Instant getPolicyUpdatedAt() {
            return policyUpdatedAt;
        }

        public final void setPolicyUpdatedAt(Instant policyUpdatedAt) {
            this.policyUpdatedAt = policyUpdatedAt;
        }

        @Override
        public final Builder policyUpdatedAt(Instant policyUpdatedAt) {
            this.policyUpdatedAt = policyUpdatedAt;
            return this;
        }

        public final String getRecommendedAction() {
            return recommendedAction;
        }

        public final void setRecommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
        }

        @Override
        public final Builder recommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
            return this;
        }

        @Override
        public final Builder recommendedAction(RecommendedRemediationAction recommendedAction) {
            this.recommendedAction(recommendedAction == null ? null : recommendedAction.toString());
            return this;
        }

        public final String getRecommendedPolicy() {
            return recommendedPolicy;
        }

        public final void setRecommendedPolicy(String recommendedPolicy) {
            this.recommendedPolicy = recommendedPolicy;
        }

        @Override
        public final Builder recommendedPolicy(String recommendedPolicy) {
            this.recommendedPolicy = recommendedPolicy;
            return this;
        }

        public final String getExistingPolicyId() {
            return existingPolicyId;
        }

        public final void setExistingPolicyId(String existingPolicyId) {
            this.existingPolicyId = existingPolicyId;
        }

        @Override
        public final Builder existingPolicyId(String existingPolicyId) {
            this.existingPolicyId = existingPolicyId;
            return this;
        }

        @Override
        public UnusedPermissionsRecommendedStep build() {
            return new UnusedPermissionsRecommendedStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
