/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access control configuration structures for your resource. You specify the configuration as a type-value pair. You
 * can specify only one type of access control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<EbsSnapshotConfiguration> EBS_SNAPSHOT_FIELD = SdkField
            .<EbsSnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("ebsSnapshot")
            .getter(getter(Configuration::ebsSnapshot)).setter(setter(Builder::ebsSnapshot))
            .constructor(EbsSnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshot").build()).build();

    private static final SdkField<EcrRepositoryConfiguration> ECR_REPOSITORY_FIELD = SdkField
            .<EcrRepositoryConfiguration> builder(MarshallingType.SDK_POJO).memberName("ecrRepository")
            .getter(getter(Configuration::ecrRepository)).setter(setter(Builder::ecrRepository))
            .constructor(EcrRepositoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepository").build()).build();

    private static final SdkField<IamRoleConfiguration> IAM_ROLE_FIELD = SdkField
            .<IamRoleConfiguration> builder(MarshallingType.SDK_POJO).memberName("iamRole")
            .getter(getter(Configuration::iamRole)).setter(setter(Builder::iamRole)).constructor(IamRoleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<EfsFileSystemConfiguration> EFS_FILE_SYSTEM_FIELD = SdkField
            .<EfsFileSystemConfiguration> builder(MarshallingType.SDK_POJO).memberName("efsFileSystem")
            .getter(getter(Configuration::efsFileSystem)).setter(setter(Builder::efsFileSystem))
            .constructor(EfsFileSystemConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efsFileSystem").build()).build();

    private static final SdkField<KmsKeyConfiguration> KMS_KEY_FIELD = SdkField
            .<KmsKeyConfiguration> builder(MarshallingType.SDK_POJO).memberName("kmsKey").getter(getter(Configuration::kmsKey))
            .setter(setter(Builder::kmsKey)).constructor(KmsKeyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()).build();

    private static final SdkField<RdsDbClusterSnapshotConfiguration> RDS_DB_CLUSTER_SNAPSHOT_FIELD = SdkField
            .<RdsDbClusterSnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("rdsDbClusterSnapshot")
            .getter(getter(Configuration::rdsDbClusterSnapshot)).setter(setter(Builder::rdsDbClusterSnapshot))
            .constructor(RdsDbClusterSnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbClusterSnapshot").build())
            .build();

    private static final SdkField<RdsDbSnapshotConfiguration> RDS_DB_SNAPSHOT_FIELD = SdkField
            .<RdsDbSnapshotConfiguration> builder(MarshallingType.SDK_POJO).memberName("rdsDbSnapshot")
            .getter(getter(Configuration::rdsDbSnapshot)).setter(setter(Builder::rdsDbSnapshot))
            .constructor(RdsDbSnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbSnapshot").build()).build();

    private static final SdkField<SecretsManagerSecretConfiguration> SECRETS_MANAGER_SECRET_FIELD = SdkField
            .<SecretsManagerSecretConfiguration> builder(MarshallingType.SDK_POJO).memberName("secretsManagerSecret")
            .getter(getter(Configuration::secretsManagerSecret)).setter(setter(Builder::secretsManagerSecret))
            .constructor(SecretsManagerSecretConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerSecret").build())
            .build();

    private static final SdkField<S3BucketConfiguration> S3_BUCKET_FIELD = SdkField
            .<S3BucketConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Bucket")
            .getter(getter(Configuration::s3Bucket)).setter(setter(Builder::s3Bucket))
            .constructor(S3BucketConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<SnsTopicConfiguration> SNS_TOPIC_FIELD = SdkField
            .<SnsTopicConfiguration> builder(MarshallingType.SDK_POJO).memberName("snsTopic")
            .getter(getter(Configuration::snsTopic)).setter(setter(Builder::snsTopic))
            .constructor(SnsTopicConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()).build();

    private static final SdkField<SqsQueueConfiguration> SQS_QUEUE_FIELD = SdkField
            .<SqsQueueConfiguration> builder(MarshallingType.SDK_POJO).memberName("sqsQueue")
            .getter(getter(Configuration::sqsQueue)).setter(setter(Builder::sqsQueue))
            .constructor(SqsQueueConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsQueue").build()).build();

    private static final SdkField<S3ExpressDirectoryBucketConfiguration> S3_EXPRESS_DIRECTORY_BUCKET_FIELD = SdkField
            .<S3ExpressDirectoryBucketConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3ExpressDirectoryBucket")
            .getter(getter(Configuration::s3ExpressDirectoryBucket)).setter(setter(Builder::s3ExpressDirectoryBucket))
            .constructor(S3ExpressDirectoryBucketConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExpressDirectoryBucket").build())
            .build();

    private static final SdkField<DynamodbStreamConfiguration> DYNAMODB_STREAM_FIELD = SdkField
            .<DynamodbStreamConfiguration> builder(MarshallingType.SDK_POJO).memberName("dynamodbStream")
            .getter(getter(Configuration::dynamodbStream)).setter(setter(Builder::dynamodbStream))
            .constructor(DynamodbStreamConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbStream").build()).build();

    private static final SdkField<DynamodbTableConfiguration> DYNAMODB_TABLE_FIELD = SdkField
            .<DynamodbTableConfiguration> builder(MarshallingType.SDK_POJO).memberName("dynamodbTable")
            .getter(getter(Configuration::dynamodbTable)).setter(setter(Builder::dynamodbTable))
            .constructor(DynamodbTableConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamodbTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_SNAPSHOT_FIELD,
            ECR_REPOSITORY_FIELD, IAM_ROLE_FIELD, EFS_FILE_SYSTEM_FIELD, KMS_KEY_FIELD, RDS_DB_CLUSTER_SNAPSHOT_FIELD,
            RDS_DB_SNAPSHOT_FIELD, SECRETS_MANAGER_SECRET_FIELD, S3_BUCKET_FIELD, SNS_TOPIC_FIELD, SQS_QUEUE_FIELD,
            S3_EXPRESS_DIRECTORY_BUCKET_FIELD, DYNAMODB_STREAM_FIELD, DYNAMODB_TABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EbsSnapshotConfiguration ebsSnapshot;

    private final EcrRepositoryConfiguration ecrRepository;

    private final IamRoleConfiguration iamRole;

    private final EfsFileSystemConfiguration efsFileSystem;

    private final KmsKeyConfiguration kmsKey;

    private final RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot;

    private final RdsDbSnapshotConfiguration rdsDbSnapshot;

    private final SecretsManagerSecretConfiguration secretsManagerSecret;

    private final S3BucketConfiguration s3Bucket;

    private final SnsTopicConfiguration snsTopic;

    private final SqsQueueConfiguration sqsQueue;

    private final S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket;

    private final DynamodbStreamConfiguration dynamodbStream;

    private final DynamodbTableConfiguration dynamodbTable;

    private final Type type;

    private Configuration(BuilderImpl builder) {
        this.ebsSnapshot = builder.ebsSnapshot;
        this.ecrRepository = builder.ecrRepository;
        this.iamRole = builder.iamRole;
        this.efsFileSystem = builder.efsFileSystem;
        this.kmsKey = builder.kmsKey;
        this.rdsDbClusterSnapshot = builder.rdsDbClusterSnapshot;
        this.rdsDbSnapshot = builder.rdsDbSnapshot;
        this.secretsManagerSecret = builder.secretsManagerSecret;
        this.s3Bucket = builder.s3Bucket;
        this.snsTopic = builder.snsTopic;
        this.sqsQueue = builder.sqsQueue;
        this.s3ExpressDirectoryBucket = builder.s3ExpressDirectoryBucket;
        this.dynamodbStream = builder.dynamodbStream;
        this.dynamodbTable = builder.dynamodbTable;
        this.type = builder.type;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon EBS volume snapshot.
     * </p>
     * 
     * @return The access control configuration is for an Amazon EBS volume snapshot.
     */
    public final EbsSnapshotConfiguration ebsSnapshot() {
        return ebsSnapshot;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon ECR repository.
     * </p>
     * 
     * @return The access control configuration is for an Amazon ECR repository.
     */
    public final EcrRepositoryConfiguration ecrRepository() {
        return ecrRepository;
    }

    /**
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @return The access control configuration is for an IAM role.
     */
    public final IamRoleConfiguration iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon EFS file system.
     * </p>
     * 
     * @return The access control configuration is for an Amazon EFS file system.
     */
    public final EfsFileSystemConfiguration efsFileSystem() {
        return efsFileSystem;
    }

    /**
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @return The access control configuration is for a KMS key.
     */
    public final KmsKeyConfiguration kmsKey() {
        return kmsKey;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon RDS DB cluster snapshot.
     * </p>
     * 
     * @return The access control configuration is for an Amazon RDS DB cluster snapshot.
     */
    public final RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot() {
        return rdsDbClusterSnapshot;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon RDS DB snapshot.
     * </p>
     * 
     * @return The access control configuration is for an Amazon RDS DB snapshot.
     */
    public final RdsDbSnapshotConfiguration rdsDbSnapshot() {
        return rdsDbSnapshot;
    }

    /**
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @return The access control configuration is for a Secrets Manager secret.
     */
    public final SecretsManagerSecretConfiguration secretsManagerSecret() {
        return secretsManagerSecret;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon S3 bucket.
     * </p>
     * 
     * @return The access control configuration is for an Amazon S3 bucket.
     */
    public final S3BucketConfiguration s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon SNS topic
     * </p>
     * 
     * @return The access control configuration is for an Amazon SNS topic
     */
    public final SnsTopicConfiguration snsTopic() {
        return snsTopic;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @return The access control configuration is for an Amazon SQS queue.
     */
    public final SqsQueueConfiguration sqsQueue() {
        return sqsQueue;
    }

    /**
     * <p>
     * The access control configuration is for an Amazon S3 directory bucket.
     * </p>
     * 
     * @return The access control configuration is for an Amazon S3 directory bucket.
     */
    public final S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket() {
        return s3ExpressDirectoryBucket;
    }

    /**
     * <p>
     * The access control configuration is for a DynamoDB stream.
     * </p>
     * 
     * @return The access control configuration is for a DynamoDB stream.
     */
    public final DynamodbStreamConfiguration dynamodbStream() {
        return dynamodbStream;
    }

    /**
     * <p>
     * The access control configuration is for a DynamoDB table or index.
     * </p>
     * 
     * @return The access control configuration is for a DynamoDB table or index.
     */
    public final DynamodbTableConfiguration dynamodbTable() {
        return dynamodbTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepository());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(efsFileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecret());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueue());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExpressDirectoryBucket());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbStream());
        hashCode = 31 * hashCode + Objects.hashCode(dynamodbTable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(ebsSnapshot(), other.ebsSnapshot()) && Objects.equals(ecrRepository(), other.ecrRepository())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(efsFileSystem(), other.efsFileSystem())
                && Objects.equals(kmsKey(), other.kmsKey())
                && Objects.equals(rdsDbClusterSnapshot(), other.rdsDbClusterSnapshot())
                && Objects.equals(rdsDbSnapshot(), other.rdsDbSnapshot())
                && Objects.equals(secretsManagerSecret(), other.secretsManagerSecret())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(snsTopic(), other.snsTopic())
                && Objects.equals(sqsQueue(), other.sqsQueue())
                && Objects.equals(s3ExpressDirectoryBucket(), other.s3ExpressDirectoryBucket())
                && Objects.equals(dynamodbStream(), other.dynamodbStream())
                && Objects.equals(dynamodbTable(), other.dynamodbTable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configuration").add("EbsSnapshot", ebsSnapshot()).add("EcrRepository", ecrRepository())
                .add("IamRole", iamRole()).add("EfsFileSystem", efsFileSystem()).add("KmsKey", kmsKey())
                .add("RdsDbClusterSnapshot", rdsDbClusterSnapshot()).add("RdsDbSnapshot", rdsDbSnapshot())
                .add("SecretsManagerSecret", secretsManagerSecret()).add("S3Bucket", s3Bucket()).add("SnsTopic", snsTopic())
                .add("SqsQueue", sqsQueue()).add("S3ExpressDirectoryBucket", s3ExpressDirectoryBucket())
                .add("DynamodbStream", dynamodbStream()).add("DynamodbTable", dynamodbTable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ebsSnapshot":
            return Optional.ofNullable(clazz.cast(ebsSnapshot()));
        case "ecrRepository":
            return Optional.ofNullable(clazz.cast(ecrRepository()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "efsFileSystem":
            return Optional.ofNullable(clazz.cast(efsFileSystem()));
        case "kmsKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "rdsDbClusterSnapshot":
            return Optional.ofNullable(clazz.cast(rdsDbClusterSnapshot()));
        case "rdsDbSnapshot":
            return Optional.ofNullable(clazz.cast(rdsDbSnapshot()));
        case "secretsManagerSecret":
            return Optional.ofNullable(clazz.cast(secretsManagerSecret()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "snsTopic":
            return Optional.ofNullable(clazz.cast(snsTopic()));
        case "sqsQueue":
            return Optional.ofNullable(clazz.cast(sqsQueue()));
        case "s3ExpressDirectoryBucket":
            return Optional.ofNullable(clazz.cast(s3ExpressDirectoryBucket()));
        case "dynamodbStream":
            return Optional.ofNullable(clazz.cast(dynamodbStream()));
        case "dynamodbTable":
            return Optional.ofNullable(clazz.cast(dynamodbTable()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ebsSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon EBS volume snapshot.
     * </p>
     * 
     * @param ebsSnapshot
     *        The access control configuration is for an Amazon EBS volume snapshot.
     */
    public static Configuration fromEbsSnapshot(EbsSnapshotConfiguration ebsSnapshot) {
        return builder().ebsSnapshot(ebsSnapshot).build();
    }

    /**
     * Create an instance of this class with {@link #ebsSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon EBS volume snapshot.
     * </p>
     * 
     * @param ebsSnapshot
     *        The access control configuration is for an Amazon EBS volume snapshot.
     */
    public static Configuration fromEbsSnapshot(Consumer<EbsSnapshotConfiguration.Builder> ebsSnapshot) {
        EbsSnapshotConfiguration.Builder builder = EbsSnapshotConfiguration.builder();
        ebsSnapshot.accept(builder);
        return fromEbsSnapshot(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ecrRepository()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon ECR repository.
     * </p>
     * 
     * @param ecrRepository
     *        The access control configuration is for an Amazon ECR repository.
     */
    public static Configuration fromEcrRepository(EcrRepositoryConfiguration ecrRepository) {
        return builder().ecrRepository(ecrRepository).build();
    }

    /**
     * Create an instance of this class with {@link #ecrRepository()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon ECR repository.
     * </p>
     * 
     * @param ecrRepository
     *        The access control configuration is for an Amazon ECR repository.
     */
    public static Configuration fromEcrRepository(Consumer<EcrRepositoryConfiguration.Builder> ecrRepository) {
        EcrRepositoryConfiguration.Builder builder = EcrRepositoryConfiguration.builder();
        ecrRepository.accept(builder);
        return fromEcrRepository(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamRole()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @param iamRole
     *        The access control configuration is for an IAM role.
     */
    public static Configuration fromIamRole(IamRoleConfiguration iamRole) {
        return builder().iamRole(iamRole).build();
    }

    /**
     * Create an instance of this class with {@link #iamRole()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an IAM role.
     * </p>
     * 
     * @param iamRole
     *        The access control configuration is for an IAM role.
     */
    public static Configuration fromIamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
        IamRoleConfiguration.Builder builder = IamRoleConfiguration.builder();
        iamRole.accept(builder);
        return fromIamRole(builder.build());
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon EFS file system.
     * </p>
     * 
     * @param efsFileSystem
     *        The access control configuration is for an Amazon EFS file system.
     */
    public static Configuration fromEfsFileSystem(EfsFileSystemConfiguration efsFileSystem) {
        return builder().efsFileSystem(efsFileSystem).build();
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon EFS file system.
     * </p>
     * 
     * @param efsFileSystem
     *        The access control configuration is for an Amazon EFS file system.
     */
    public static Configuration fromEfsFileSystem(Consumer<EfsFileSystemConfiguration.Builder> efsFileSystem) {
        EfsFileSystemConfiguration.Builder builder = EfsFileSystemConfiguration.builder();
        efsFileSystem.accept(builder);
        return fromEfsFileSystem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #kmsKey()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @param kmsKey
     *        The access control configuration is for a KMS key.
     */
    public static Configuration fromKmsKey(KmsKeyConfiguration kmsKey) {
        return builder().kmsKey(kmsKey).build();
    }

    /**
     * Create an instance of this class with {@link #kmsKey()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a KMS key.
     * </p>
     * 
     * @param kmsKey
     *        The access control configuration is for a KMS key.
     */
    public static Configuration fromKmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
        KmsKeyConfiguration.Builder builder = KmsKeyConfiguration.builder();
        kmsKey.accept(builder);
        return fromKmsKey(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsDbClusterSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon RDS DB cluster snapshot.
     * </p>
     * 
     * @param rdsDbClusterSnapshot
     *        The access control configuration is for an Amazon RDS DB cluster snapshot.
     */
    public static Configuration fromRdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot) {
        return builder().rdsDbClusterSnapshot(rdsDbClusterSnapshot).build();
    }

    /**
     * Create an instance of this class with {@link #rdsDbClusterSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon RDS DB cluster snapshot.
     * </p>
     * 
     * @param rdsDbClusterSnapshot
     *        The access control configuration is for an Amazon RDS DB cluster snapshot.
     */
    public static Configuration fromRdsDbClusterSnapshot(Consumer<RdsDbClusterSnapshotConfiguration.Builder> rdsDbClusterSnapshot) {
        RdsDbClusterSnapshotConfiguration.Builder builder = RdsDbClusterSnapshotConfiguration.builder();
        rdsDbClusterSnapshot.accept(builder);
        return fromRdsDbClusterSnapshot(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rdsDbSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon RDS DB snapshot.
     * </p>
     * 
     * @param rdsDbSnapshot
     *        The access control configuration is for an Amazon RDS DB snapshot.
     */
    public static Configuration fromRdsDbSnapshot(RdsDbSnapshotConfiguration rdsDbSnapshot) {
        return builder().rdsDbSnapshot(rdsDbSnapshot).build();
    }

    /**
     * Create an instance of this class with {@link #rdsDbSnapshot()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon RDS DB snapshot.
     * </p>
     * 
     * @param rdsDbSnapshot
     *        The access control configuration is for an Amazon RDS DB snapshot.
     */
    public static Configuration fromRdsDbSnapshot(Consumer<RdsDbSnapshotConfiguration.Builder> rdsDbSnapshot) {
        RdsDbSnapshotConfiguration.Builder builder = RdsDbSnapshotConfiguration.builder();
        rdsDbSnapshot.accept(builder);
        return fromRdsDbSnapshot(builder.build());
    }

    /**
     * Create an instance of this class with {@link #secretsManagerSecret()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @param secretsManagerSecret
     *        The access control configuration is for a Secrets Manager secret.
     */
    public static Configuration fromSecretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
        return builder().secretsManagerSecret(secretsManagerSecret).build();
    }

    /**
     * Create an instance of this class with {@link #secretsManagerSecret()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a Secrets Manager secret.
     * </p>
     * 
     * @param secretsManagerSecret
     *        The access control configuration is for a Secrets Manager secret.
     */
    public static Configuration fromSecretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
        SecretsManagerSecretConfiguration.Builder builder = SecretsManagerSecretConfiguration.builder();
        secretsManagerSecret.accept(builder);
        return fromSecretsManagerSecret(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 bucket.
     * </p>
     * 
     * @param s3Bucket
     *        The access control configuration is for an Amazon S3 bucket.
     */
    public static Configuration fromS3Bucket(S3BucketConfiguration s3Bucket) {
        return builder().s3Bucket(s3Bucket).build();
    }

    /**
     * Create an instance of this class with {@link #s3Bucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 bucket.
     * </p>
     * 
     * @param s3Bucket
     *        The access control configuration is for an Amazon S3 bucket.
     */
    public static Configuration fromS3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
        S3BucketConfiguration.Builder builder = S3BucketConfiguration.builder();
        s3Bucket.accept(builder);
        return fromS3Bucket(builder.build());
    }

    /**
     * Create an instance of this class with {@link #snsTopic()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SNS topic
     * </p>
     * 
     * @param snsTopic
     *        The access control configuration is for an Amazon SNS topic
     */
    public static Configuration fromSnsTopic(SnsTopicConfiguration snsTopic) {
        return builder().snsTopic(snsTopic).build();
    }

    /**
     * Create an instance of this class with {@link #snsTopic()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SNS topic
     * </p>
     * 
     * @param snsTopic
     *        The access control configuration is for an Amazon SNS topic
     */
    public static Configuration fromSnsTopic(Consumer<SnsTopicConfiguration.Builder> snsTopic) {
        SnsTopicConfiguration.Builder builder = SnsTopicConfiguration.builder();
        snsTopic.accept(builder);
        return fromSnsTopic(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sqsQueue()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @param sqsQueue
     *        The access control configuration is for an Amazon SQS queue.
     */
    public static Configuration fromSqsQueue(SqsQueueConfiguration sqsQueue) {
        return builder().sqsQueue(sqsQueue).build();
    }

    /**
     * Create an instance of this class with {@link #sqsQueue()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon SQS queue.
     * </p>
     * 
     * @param sqsQueue
     *        The access control configuration is for an Amazon SQS queue.
     */
    public static Configuration fromSqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
        SqsQueueConfiguration.Builder builder = SqsQueueConfiguration.builder();
        sqsQueue.accept(builder);
        return fromSqsQueue(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3ExpressDirectoryBucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 directory bucket.
     * </p>
     * 
     * @param s3ExpressDirectoryBucket
     *        The access control configuration is for an Amazon S3 directory bucket.
     */
    public static Configuration fromS3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket) {
        return builder().s3ExpressDirectoryBucket(s3ExpressDirectoryBucket).build();
    }

    /**
     * Create an instance of this class with {@link #s3ExpressDirectoryBucket()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for an Amazon S3 directory bucket.
     * </p>
     * 
     * @param s3ExpressDirectoryBucket
     *        The access control configuration is for an Amazon S3 directory bucket.
     */
    public static Configuration fromS3ExpressDirectoryBucket(
            Consumer<S3ExpressDirectoryBucketConfiguration.Builder> s3ExpressDirectoryBucket) {
        S3ExpressDirectoryBucketConfiguration.Builder builder = S3ExpressDirectoryBucketConfiguration.builder();
        s3ExpressDirectoryBucket.accept(builder);
        return fromS3ExpressDirectoryBucket(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dynamodbStream()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a DynamoDB stream.
     * </p>
     * 
     * @param dynamodbStream
     *        The access control configuration is for a DynamoDB stream.
     */
    public static Configuration fromDynamodbStream(DynamodbStreamConfiguration dynamodbStream) {
        return builder().dynamodbStream(dynamodbStream).build();
    }

    /**
     * Create an instance of this class with {@link #dynamodbStream()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a DynamoDB stream.
     * </p>
     * 
     * @param dynamodbStream
     *        The access control configuration is for a DynamoDB stream.
     */
    public static Configuration fromDynamodbStream(Consumer<DynamodbStreamConfiguration.Builder> dynamodbStream) {
        DynamodbStreamConfiguration.Builder builder = DynamodbStreamConfiguration.builder();
        dynamodbStream.accept(builder);
        return fromDynamodbStream(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dynamodbTable()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a DynamoDB table or index.
     * </p>
     * 
     * @param dynamodbTable
     *        The access control configuration is for a DynamoDB table or index.
     */
    public static Configuration fromDynamodbTable(DynamodbTableConfiguration dynamodbTable) {
        return builder().dynamodbTable(dynamodbTable).build();
    }

    /**
     * Create an instance of this class with {@link #dynamodbTable()} initialized to the given value.
     *
     * <p>
     * The access control configuration is for a DynamoDB table or index.
     * </p>
     * 
     * @param dynamodbTable
     *        The access control configuration is for a DynamoDB table or index.
     */
    public static Configuration fromDynamodbTable(Consumer<DynamodbTableConfiguration.Builder> dynamodbTable) {
        DynamodbTableConfiguration.Builder builder = DynamodbTableConfiguration.builder();
        dynamodbTable.accept(builder);
        return fromDynamodbTable(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         * <p>
         * The access control configuration is for an Amazon EBS volume snapshot.
         * </p>
         * 
         * @param ebsSnapshot
         *        The access control configuration is for an Amazon EBS volume snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsSnapshot(EbsSnapshotConfiguration ebsSnapshot);

        /**
         * <p>
         * The access control configuration is for an Amazon EBS volume snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsSnapshotConfiguration.Builder}
         * avoiding the need to create one manually via {@link EbsSnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsSnapshotConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ebsSnapshot(EbsSnapshotConfiguration)}.
         * 
         * @param ebsSnapshot
         *        a consumer that will call methods on {@link EbsSnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsSnapshot(EbsSnapshotConfiguration)
         */
        default Builder ebsSnapshot(Consumer<EbsSnapshotConfiguration.Builder> ebsSnapshot) {
            return ebsSnapshot(EbsSnapshotConfiguration.builder().applyMutation(ebsSnapshot).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon ECR repository.
         * </p>
         * 
         * @param ecrRepository
         *        The access control configuration is for an Amazon ECR repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepository(EcrRepositoryConfiguration ecrRepository);

        /**
         * <p>
         * The access control configuration is for an Amazon ECR repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrRepositoryConfiguration.Builder}
         * avoiding the need to create one manually via {@link EcrRepositoryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcrRepositoryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrRepository(EcrRepositoryConfiguration)}.
         * 
         * @param ecrRepository
         *        a consumer that will call methods on {@link EcrRepositoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrRepository(EcrRepositoryConfiguration)
         */
        default Builder ecrRepository(Consumer<EcrRepositoryConfiguration.Builder> ecrRepository) {
            return ecrRepository(EcrRepositoryConfiguration.builder().applyMutation(ecrRepository).build());
        }

        /**
         * <p>
         * The access control configuration is for an IAM role.
         * </p>
         * 
         * @param iamRole
         *        The access control configuration is for an IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(IamRoleConfiguration iamRole);

        /**
         * <p>
         * The access control configuration is for an IAM role.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamRoleConfiguration.Builder} avoiding
         * the need to create one manually via {@link IamRoleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamRoleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #iamRole(IamRoleConfiguration)}.
         * 
         * @param iamRole
         *        a consumer that will call methods on {@link IamRoleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRole(IamRoleConfiguration)
         */
        default Builder iamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
            return iamRole(IamRoleConfiguration.builder().applyMutation(iamRole).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon EFS file system.
         * </p>
         * 
         * @param efsFileSystem
         *        The access control configuration is for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileSystem(EfsFileSystemConfiguration efsFileSystem);

        /**
         * <p>
         * The access control configuration is for an Amazon EFS file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link EfsFileSystemConfiguration.Builder}
         * avoiding the need to create one manually via {@link EfsFileSystemConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EfsFileSystemConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #efsFileSystem(EfsFileSystemConfiguration)}.
         * 
         * @param efsFileSystem
         *        a consumer that will call methods on {@link EfsFileSystemConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileSystem(EfsFileSystemConfiguration)
         */
        default Builder efsFileSystem(Consumer<EfsFileSystemConfiguration.Builder> efsFileSystem) {
            return efsFileSystem(EfsFileSystemConfiguration.builder().applyMutation(efsFileSystem).build());
        }

        /**
         * <p>
         * The access control configuration is for a KMS key.
         * </p>
         * 
         * @param kmsKey
         *        The access control configuration is for a KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(KmsKeyConfiguration kmsKey);

        /**
         * <p>
         * The access control configuration is for a KMS key.
         * </p>
         * This is a convenience method that creates an instance of the {@link KmsKeyConfiguration.Builder} avoiding the
         * need to create one manually via {@link KmsKeyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KmsKeyConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kmsKey(KmsKeyConfiguration)}.
         * 
         * @param kmsKey
         *        a consumer that will call methods on {@link KmsKeyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kmsKey(KmsKeyConfiguration)
         */
        default Builder kmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
            return kmsKey(KmsKeyConfiguration.builder().applyMutation(kmsKey).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon RDS DB cluster snapshot.
         * </p>
         * 
         * @param rdsDbClusterSnapshot
         *        The access control configuration is for an Amazon RDS DB cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot);

        /**
         * <p>
         * The access control configuration is for an Amazon RDS DB cluster snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RdsDbClusterSnapshotConfiguration.Builder} avoiding the need to create one manually via
         * {@link RdsDbClusterSnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsDbClusterSnapshotConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration)}.
         * 
         * @param rdsDbClusterSnapshot
         *        a consumer that will call methods on {@link RdsDbClusterSnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration)
         */
        default Builder rdsDbClusterSnapshot(Consumer<RdsDbClusterSnapshotConfiguration.Builder> rdsDbClusterSnapshot) {
            return rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration.builder().applyMutation(rdsDbClusterSnapshot).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon RDS DB snapshot.
         * </p>
         * 
         * @param rdsDbSnapshot
         *        The access control configuration is for an Amazon RDS DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbSnapshot(RdsDbSnapshotConfiguration rdsDbSnapshot);

        /**
         * <p>
         * The access control configuration is for an Amazon RDS DB snapshot.
         * </p>
         * This is a convenience method that creates an instance of the {@link RdsDbSnapshotConfiguration.Builder}
         * avoiding the need to create one manually via {@link RdsDbSnapshotConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RdsDbSnapshotConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #rdsDbSnapshot(RdsDbSnapshotConfiguration)}.
         * 
         * @param rdsDbSnapshot
         *        a consumer that will call methods on {@link RdsDbSnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDbSnapshot(RdsDbSnapshotConfiguration)
         */
        default Builder rdsDbSnapshot(Consumer<RdsDbSnapshotConfiguration.Builder> rdsDbSnapshot) {
            return rdsDbSnapshot(RdsDbSnapshotConfiguration.builder().applyMutation(rdsDbSnapshot).build());
        }

        /**
         * <p>
         * The access control configuration is for a Secrets Manager secret.
         * </p>
         * 
         * @param secretsManagerSecret
         *        The access control configuration is for a Secrets Manager secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret);

        /**
         * <p>
         * The access control configuration is for a Secrets Manager secret.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerSecretConfiguration.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerSecretConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerSecretConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #secretsManagerSecret(SecretsManagerSecretConfiguration)}.
         * 
         * @param secretsManagerSecret
         *        a consumer that will call methods on {@link SecretsManagerSecretConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerSecret(SecretsManagerSecretConfiguration)
         */
        default Builder secretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
            return secretsManagerSecret(SecretsManagerSecretConfiguration.builder().applyMutation(secretsManagerSecret).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon S3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        The access control configuration is for an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(S3BucketConfiguration s3Bucket);

        /**
         * <p>
         * The access control configuration is for an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketConfiguration.Builder} avoiding
         * the need to create one manually via {@link S3BucketConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Bucket(S3BucketConfiguration)}.
         * 
         * @param s3Bucket
         *        a consumer that will call methods on {@link S3BucketConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Bucket(S3BucketConfiguration)
         */
        default Builder s3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
            return s3Bucket(S3BucketConfiguration.builder().applyMutation(s3Bucket).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon SNS topic
         * </p>
         * 
         * @param snsTopic
         *        The access control configuration is for an Amazon SNS topic
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopic(SnsTopicConfiguration snsTopic);

        /**
         * <p>
         * The access control configuration is for an Amazon SNS topic
         * </p>
         * This is a convenience method that creates an instance of the {@link SnsTopicConfiguration.Builder} avoiding
         * the need to create one manually via {@link SnsTopicConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnsTopicConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #snsTopic(SnsTopicConfiguration)}.
         * 
         * @param snsTopic
         *        a consumer that will call methods on {@link SnsTopicConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsTopic(SnsTopicConfiguration)
         */
        default Builder snsTopic(Consumer<SnsTopicConfiguration.Builder> snsTopic) {
            return snsTopic(SnsTopicConfiguration.builder().applyMutation(snsTopic).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon SQS queue.
         * </p>
         * 
         * @param sqsQueue
         *        The access control configuration is for an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueue(SqsQueueConfiguration sqsQueue);

        /**
         * <p>
         * The access control configuration is for an Amazon SQS queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsQueueConfiguration.Builder} avoiding
         * the need to create one manually via {@link SqsQueueConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsQueueConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sqsQueue(SqsQueueConfiguration)}.
         * 
         * @param sqsQueue
         *        a consumer that will call methods on {@link SqsQueueConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueue(SqsQueueConfiguration)
         */
        default Builder sqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
            return sqsQueue(SqsQueueConfiguration.builder().applyMutation(sqsQueue).build());
        }

        /**
         * <p>
         * The access control configuration is for an Amazon S3 directory bucket.
         * </p>
         * 
         * @param s3ExpressDirectoryBucket
         *        The access control configuration is for an Amazon S3 directory bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket);

        /**
         * <p>
         * The access control configuration is for an Amazon S3 directory bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link S3ExpressDirectoryBucketConfiguration.Builder} avoiding the need to create one manually via
         * {@link S3ExpressDirectoryBucketConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ExpressDirectoryBucketConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #s3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration)}.
         * 
         * @param s3ExpressDirectoryBucket
         *        a consumer that will call methods on {@link S3ExpressDirectoryBucketConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration)
         */
        default Builder s3ExpressDirectoryBucket(Consumer<S3ExpressDirectoryBucketConfiguration.Builder> s3ExpressDirectoryBucket) {
            return s3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration.builder()
                    .applyMutation(s3ExpressDirectoryBucket).build());
        }

        /**
         * <p>
         * The access control configuration is for a DynamoDB stream.
         * </p>
         * 
         * @param dynamodbStream
         *        The access control configuration is for a DynamoDB stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbStream(DynamodbStreamConfiguration dynamodbStream);

        /**
         * <p>
         * The access control configuration is for a DynamoDB stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamodbStreamConfiguration.Builder}
         * avoiding the need to create one manually via {@link DynamodbStreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamodbStreamConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamodbStream(DynamodbStreamConfiguration)}.
         * 
         * @param dynamodbStream
         *        a consumer that will call methods on {@link DynamodbStreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamodbStream(DynamodbStreamConfiguration)
         */
        default Builder dynamodbStream(Consumer<DynamodbStreamConfiguration.Builder> dynamodbStream) {
            return dynamodbStream(DynamodbStreamConfiguration.builder().applyMutation(dynamodbStream).build());
        }

        /**
         * <p>
         * The access control configuration is for a DynamoDB table or index.
         * </p>
         * 
         * @param dynamodbTable
         *        The access control configuration is for a DynamoDB table or index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamodbTable(DynamodbTableConfiguration dynamodbTable);

        /**
         * <p>
         * The access control configuration is for a DynamoDB table or index.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamodbTableConfiguration.Builder}
         * avoiding the need to create one manually via {@link DynamodbTableConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamodbTableConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dynamodbTable(DynamodbTableConfiguration)}.
         * 
         * @param dynamodbTable
         *        a consumer that will call methods on {@link DynamodbTableConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamodbTable(DynamodbTableConfiguration)
         */
        default Builder dynamodbTable(Consumer<DynamodbTableConfiguration.Builder> dynamodbTable) {
            return dynamodbTable(DynamodbTableConfiguration.builder().applyMutation(dynamodbTable).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EbsSnapshotConfiguration ebsSnapshot;

        private EcrRepositoryConfiguration ecrRepository;

        private IamRoleConfiguration iamRole;

        private EfsFileSystemConfiguration efsFileSystem;

        private KmsKeyConfiguration kmsKey;

        private RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot;

        private RdsDbSnapshotConfiguration rdsDbSnapshot;

        private SecretsManagerSecretConfiguration secretsManagerSecret;

        private S3BucketConfiguration s3Bucket;

        private SnsTopicConfiguration snsTopic;

        private SqsQueueConfiguration sqsQueue;

        private S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket;

        private DynamodbStreamConfiguration dynamodbStream;

        private DynamodbTableConfiguration dynamodbTable;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            ebsSnapshot(model.ebsSnapshot);
            ecrRepository(model.ecrRepository);
            iamRole(model.iamRole);
            efsFileSystem(model.efsFileSystem);
            kmsKey(model.kmsKey);
            rdsDbClusterSnapshot(model.rdsDbClusterSnapshot);
            rdsDbSnapshot(model.rdsDbSnapshot);
            secretsManagerSecret(model.secretsManagerSecret);
            s3Bucket(model.s3Bucket);
            snsTopic(model.snsTopic);
            sqsQueue(model.sqsQueue);
            s3ExpressDirectoryBucket(model.s3ExpressDirectoryBucket);
            dynamodbStream(model.dynamodbStream);
            dynamodbTable(model.dynamodbTable);
        }

        public final EbsSnapshotConfiguration.Builder getEbsSnapshot() {
            return ebsSnapshot != null ? ebsSnapshot.toBuilder() : null;
        }

        public final void setEbsSnapshot(EbsSnapshotConfiguration.BuilderImpl ebsSnapshot) {
            Object oldValue = this.ebsSnapshot;
            this.ebsSnapshot = ebsSnapshot != null ? ebsSnapshot.build() : null;
            handleUnionValueChange(Type.EBS_SNAPSHOT, oldValue, this.ebsSnapshot);
        }

        @Override
        public final Builder ebsSnapshot(EbsSnapshotConfiguration ebsSnapshot) {
            Object oldValue = this.ebsSnapshot;
            this.ebsSnapshot = ebsSnapshot;
            handleUnionValueChange(Type.EBS_SNAPSHOT, oldValue, this.ebsSnapshot);
            return this;
        }

        public final EcrRepositoryConfiguration.Builder getEcrRepository() {
            return ecrRepository != null ? ecrRepository.toBuilder() : null;
        }

        public final void setEcrRepository(EcrRepositoryConfiguration.BuilderImpl ecrRepository) {
            Object oldValue = this.ecrRepository;
            this.ecrRepository = ecrRepository != null ? ecrRepository.build() : null;
            handleUnionValueChange(Type.ECR_REPOSITORY, oldValue, this.ecrRepository);
        }

        @Override
        public final Builder ecrRepository(EcrRepositoryConfiguration ecrRepository) {
            Object oldValue = this.ecrRepository;
            this.ecrRepository = ecrRepository;
            handleUnionValueChange(Type.ECR_REPOSITORY, oldValue, this.ecrRepository);
            return this;
        }

        public final IamRoleConfiguration.Builder getIamRole() {
            return iamRole != null ? iamRole.toBuilder() : null;
        }

        public final void setIamRole(IamRoleConfiguration.BuilderImpl iamRole) {
            Object oldValue = this.iamRole;
            this.iamRole = iamRole != null ? iamRole.build() : null;
            handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
        }

        @Override
        public final Builder iamRole(IamRoleConfiguration iamRole) {
            Object oldValue = this.iamRole;
            this.iamRole = iamRole;
            handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
            return this;
        }

        public final EfsFileSystemConfiguration.Builder getEfsFileSystem() {
            return efsFileSystem != null ? efsFileSystem.toBuilder() : null;
        }

        public final void setEfsFileSystem(EfsFileSystemConfiguration.BuilderImpl efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem != null ? efsFileSystem.build() : null;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
        }

        @Override
        public final Builder efsFileSystem(EfsFileSystemConfiguration efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
            return this;
        }

        public final KmsKeyConfiguration.Builder getKmsKey() {
            return kmsKey != null ? kmsKey.toBuilder() : null;
        }

        public final void setKmsKey(KmsKeyConfiguration.BuilderImpl kmsKey) {
            Object oldValue = this.kmsKey;
            this.kmsKey = kmsKey != null ? kmsKey.build() : null;
            handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
        }

        @Override
        public final Builder kmsKey(KmsKeyConfiguration kmsKey) {
            Object oldValue = this.kmsKey;
            this.kmsKey = kmsKey;
            handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
            return this;
        }

        public final RdsDbClusterSnapshotConfiguration.Builder getRdsDbClusterSnapshot() {
            return rdsDbClusterSnapshot != null ? rdsDbClusterSnapshot.toBuilder() : null;
        }

        public final void setRdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration.BuilderImpl rdsDbClusterSnapshot) {
            Object oldValue = this.rdsDbClusterSnapshot;
            this.rdsDbClusterSnapshot = rdsDbClusterSnapshot != null ? rdsDbClusterSnapshot.build() : null;
            handleUnionValueChange(Type.RDS_DB_CLUSTER_SNAPSHOT, oldValue, this.rdsDbClusterSnapshot);
        }

        @Override
        public final Builder rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot) {
            Object oldValue = this.rdsDbClusterSnapshot;
            this.rdsDbClusterSnapshot = rdsDbClusterSnapshot;
            handleUnionValueChange(Type.RDS_DB_CLUSTER_SNAPSHOT, oldValue, this.rdsDbClusterSnapshot);
            return this;
        }

        public final RdsDbSnapshotConfiguration.Builder getRdsDbSnapshot() {
            return rdsDbSnapshot != null ? rdsDbSnapshot.toBuilder() : null;
        }

        public final void setRdsDbSnapshot(RdsDbSnapshotConfiguration.BuilderImpl rdsDbSnapshot) {
            Object oldValue = this.rdsDbSnapshot;
            this.rdsDbSnapshot = rdsDbSnapshot != null ? rdsDbSnapshot.build() : null;
            handleUnionValueChange(Type.RDS_DB_SNAPSHOT, oldValue, this.rdsDbSnapshot);
        }

        @Override
        public final Builder rdsDbSnapshot(RdsDbSnapshotConfiguration rdsDbSnapshot) {
            Object oldValue = this.rdsDbSnapshot;
            this.rdsDbSnapshot = rdsDbSnapshot;
            handleUnionValueChange(Type.RDS_DB_SNAPSHOT, oldValue, this.rdsDbSnapshot);
            return this;
        }

        public final SecretsManagerSecretConfiguration.Builder getSecretsManagerSecret() {
            return secretsManagerSecret != null ? secretsManagerSecret.toBuilder() : null;
        }

        public final void setSecretsManagerSecret(SecretsManagerSecretConfiguration.BuilderImpl secretsManagerSecret) {
            Object oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret != null ? secretsManagerSecret.build() : null;
            handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
        }

        @Override
        public final Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
            Object oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret;
            handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
            return this;
        }

        public final S3BucketConfiguration.Builder getS3Bucket() {
            return s3Bucket != null ? s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3BucketConfiguration.BuilderImpl s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        public final Builder s3Bucket(S3BucketConfiguration s3Bucket) {
            Object oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final SnsTopicConfiguration.Builder getSnsTopic() {
            return snsTopic != null ? snsTopic.toBuilder() : null;
        }

        public final void setSnsTopic(SnsTopicConfiguration.BuilderImpl snsTopic) {
            Object oldValue = this.snsTopic;
            this.snsTopic = snsTopic != null ? snsTopic.build() : null;
            handleUnionValueChange(Type.SNS_TOPIC, oldValue, this.snsTopic);
        }

        @Override
        public final Builder snsTopic(SnsTopicConfiguration snsTopic) {
            Object oldValue = this.snsTopic;
            this.snsTopic = snsTopic;
            handleUnionValueChange(Type.SNS_TOPIC, oldValue, this.snsTopic);
            return this;
        }

        public final SqsQueueConfiguration.Builder getSqsQueue() {
            return sqsQueue != null ? sqsQueue.toBuilder() : null;
        }

        public final void setSqsQueue(SqsQueueConfiguration.BuilderImpl sqsQueue) {
            Object oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue != null ? sqsQueue.build() : null;
            handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
        }

        @Override
        public final Builder sqsQueue(SqsQueueConfiguration sqsQueue) {
            Object oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue;
            handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
            return this;
        }

        public final S3ExpressDirectoryBucketConfiguration.Builder getS3ExpressDirectoryBucket() {
            return s3ExpressDirectoryBucket != null ? s3ExpressDirectoryBucket.toBuilder() : null;
        }

        public final void setS3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration.BuilderImpl s3ExpressDirectoryBucket) {
            Object oldValue = this.s3ExpressDirectoryBucket;
            this.s3ExpressDirectoryBucket = s3ExpressDirectoryBucket != null ? s3ExpressDirectoryBucket.build() : null;
            handleUnionValueChange(Type.S3_EXPRESS_DIRECTORY_BUCKET, oldValue, this.s3ExpressDirectoryBucket);
        }

        @Override
        public final Builder s3ExpressDirectoryBucket(S3ExpressDirectoryBucketConfiguration s3ExpressDirectoryBucket) {
            Object oldValue = this.s3ExpressDirectoryBucket;
            this.s3ExpressDirectoryBucket = s3ExpressDirectoryBucket;
            handleUnionValueChange(Type.S3_EXPRESS_DIRECTORY_BUCKET, oldValue, this.s3ExpressDirectoryBucket);
            return this;
        }

        public final DynamodbStreamConfiguration.Builder getDynamodbStream() {
            return dynamodbStream != null ? dynamodbStream.toBuilder() : null;
        }

        public final void setDynamodbStream(DynamodbStreamConfiguration.BuilderImpl dynamodbStream) {
            Object oldValue = this.dynamodbStream;
            this.dynamodbStream = dynamodbStream != null ? dynamodbStream.build() : null;
            handleUnionValueChange(Type.DYNAMODB_STREAM, oldValue, this.dynamodbStream);
        }

        @Override
        public final Builder dynamodbStream(DynamodbStreamConfiguration dynamodbStream) {
            Object oldValue = this.dynamodbStream;
            this.dynamodbStream = dynamodbStream;
            handleUnionValueChange(Type.DYNAMODB_STREAM, oldValue, this.dynamodbStream);
            return this;
        }

        public final DynamodbTableConfiguration.Builder getDynamodbTable() {
            return dynamodbTable != null ? dynamodbTable.toBuilder() : null;
        }

        public final void setDynamodbTable(DynamodbTableConfiguration.BuilderImpl dynamodbTable) {
            Object oldValue = this.dynamodbTable;
            this.dynamodbTable = dynamodbTable != null ? dynamodbTable.build() : null;
            handleUnionValueChange(Type.DYNAMODB_TABLE, oldValue, this.dynamodbTable);
        }

        @Override
        public final Builder dynamodbTable(DynamodbTableConfiguration dynamodbTable) {
            Object oldValue = this.dynamodbTable;
            this.dynamodbTable = dynamodbTable;
            handleUnionValueChange(Type.DYNAMODB_TABLE, oldValue, this.dynamodbTable);
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Configuration#type()
     */
    public enum Type {
        EBS_SNAPSHOT,

        ECR_REPOSITORY,

        IAM_ROLE,

        EFS_FILE_SYSTEM,

        KMS_KEY,

        RDS_DB_CLUSTER_SNAPSHOT,

        RDS_DB_SNAPSHOT,

        SECRETS_MANAGER_SECRET,

        S3_BUCKET,

        SNS_TOPIC,

        SQS_QUEUE,

        S3_EXPRESS_DIRECTORY_BUCKET,

        DYNAMODB_STREAM,

        DYNAMODB_TABLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
