/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an unused access finding for a permission. IAM Access Analyzer charges for unused access
 * analysis based on the number of IAM roles and users analyzed per month. For more details on pricing, see <a
 * href="https://aws.amazon.com/iam/access-analyzer/pricing">IAM Access Analyzer pricing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnusedPermissionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UnusedPermissionDetails.Builder, UnusedPermissionDetails> {
    private static final SdkField<List<UnusedAction>> ACTIONS_FIELD = SdkField
            .<List<UnusedAction>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(UnusedPermissionDetails::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnusedAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnusedAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNamespace").getter(getter(UnusedPermissionDetails::serviceNamespace))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNamespace").build()).build();

    private static final SdkField<Instant> LAST_ACCESSED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAccessed")
            .getter(getter(UnusedPermissionDetails::lastAccessed))
            .setter(setter(Builder::lastAccessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccessed").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            SERVICE_NAMESPACE_FIELD, LAST_ACCESSED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<UnusedAction> actions;

    private final String serviceNamespace;

    private final Instant lastAccessed;

    private UnusedPermissionDetails(BuilderImpl builder) {
        this.actions = builder.actions;
        this.serviceNamespace = builder.serviceNamespace;
        this.lastAccessed = builder.lastAccessed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unused actions for which the unused access finding was generated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of unused actions for which the unused access finding was generated.
     */
    public final List<UnusedAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The namespace of the Amazon Web Services service that contains the unused actions.
     * </p>
     * 
     * @return The namespace of the Amazon Web Services service that contains the unused actions.
     */
    public final String serviceNamespace() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The time at which the permission was last accessed.
     * </p>
     * 
     * @return The time at which the permission was last accessed.
     */
    public final Instant lastAccessed() {
        return lastAccessed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedPermissionDetails)) {
            return false;
        }
        UnusedPermissionDetails other = (UnusedPermissionDetails) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(serviceNamespace(), other.serviceNamespace())
                && Objects.equals(lastAccessed(), other.lastAccessed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnusedPermissionDetails").add("Actions", hasActions() ? actions() : null)
                .add("ServiceNamespace", serviceNamespace()).add("LastAccessed", lastAccessed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "serviceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespace()));
        case "lastAccessed":
            return Optional.ofNullable(clazz.cast(lastAccessed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnusedPermissionDetails, T> g) {
        return obj -> g.apply((UnusedPermissionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnusedPermissionDetails> {
        /**
         * <p>
         * A list of unused actions for which the unused access finding was generated.
         * </p>
         * 
         * @param actions
         *        A list of unused actions for which the unused access finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<UnusedAction> actions);

        /**
         * <p>
         * A list of unused actions for which the unused access finding was generated.
         * </p>
         * 
         * @param actions
         *        A list of unused actions for which the unused access finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(UnusedAction... actions);

        /**
         * <p>
         * A list of unused actions for which the unused access finding was generated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<UnusedAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.UnusedAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<UnusedAction>)
         */
        Builder actions(Consumer<UnusedAction.Builder>... actions);

        /**
         * <p>
         * The namespace of the Amazon Web Services service that contains the unused actions.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the Amazon Web Services service that contains the unused actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The time at which the permission was last accessed.
         * </p>
         * 
         * @param lastAccessed
         *        The time at which the permission was last accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessed(Instant lastAccessed);
    }

    static final class BuilderImpl implements Builder {
        private List<UnusedAction> actions = DefaultSdkAutoConstructList.getInstance();

        private String serviceNamespace;

        private Instant lastAccessed;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedPermissionDetails model) {
            actions(model.actions);
            serviceNamespace(model.serviceNamespace);
            lastAccessed(model.lastAccessed);
        }

        public final List<UnusedAction.Builder> getActions() {
            List<UnusedAction.Builder> result = UnusedActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<UnusedAction.BuilderImpl> actions) {
            this.actions = UnusedActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<UnusedAction> actions) {
            this.actions = UnusedActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(UnusedAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<UnusedAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> UnusedAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final Instant getLastAccessed() {
            return lastAccessed;
        }

        public final void setLastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        @Override
        public final Builder lastAccessed(Instant lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        @Override
        public UnusedPermissionDetails build() {
            return new UnusedPermissionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
