/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class RecommendedStepListCopier {
    static List<RecommendedStep> copy(Collection<? extends RecommendedStep> recommendedStepListParam) {
        List<RecommendedStep> list;
        if (recommendedStepListParam == null || recommendedStepListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RecommendedStep> modifiableList = new ArrayList<>(recommendedStepListParam.size());
            recommendedStepListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RecommendedStep> copyFromBuilder(Collection<? extends RecommendedStep.Builder> recommendedStepListParam) {
        List<RecommendedStep> list;
        if (recommendedStepListParam == null || recommendedStepListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RecommendedStep> modifiableList = new ArrayList<>(recommendedStepListParam.size());
            recommendedStepListParam.forEach(entry -> {
                RecommendedStep member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<RecommendedStep.Builder> copyToBuilder(Collection<? extends RecommendedStep> recommendedStepListParam) {
        List<RecommendedStep.Builder> list;
        if (recommendedStepListParam == null || recommendedStepListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<RecommendedStep.Builder> modifiableList = new ArrayList<>(recommendedStepListParam.size());
            recommendedStepListParam.forEach(entry -> {
                RecommendedStep.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
