/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration;
import software.amazon.awssdk.services.accessanalyzer.model.PolicyGenerationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyGenerationsResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, ListPolicyGenerationsResponse> {
    private static final SdkField<List<PolicyGeneration>> POLICY_GENERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyGenerations").getter(ListPolicyGenerationsResponse.getter(ListPolicyGenerationsResponse::policyGenerations)).setter(ListPolicyGenerationsResponse.setter(Builder::policyGenerations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyGeneration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPolicyGenerationsResponse.getter(ListPolicyGenerationsResponse::nextToken)).setter(ListPolicyGenerationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GENERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyGenerations", POLICY_GENERATIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PolicyGeneration> policyGenerations;
    private final String nextToken;

    private ListPolicyGenerationsResponse(BuilderImpl builder) {
        super(builder);
        this.policyGenerations = builder.policyGenerations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicyGenerations() {
        return this.policyGenerations != null && !(this.policyGenerations instanceof SdkAutoConstructList);
    }

    public final List<PolicyGeneration> policyGenerations() {
        return this.policyGenerations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyGenerations() ? this.policyGenerations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGenerationsResponse)) {
            return false;
        }
        ListPolicyGenerationsResponse other = (ListPolicyGenerationsResponse)((Object)obj);
        return this.hasPolicyGenerations() == other.hasPolicyGenerations() && Objects.equals(this.policyGenerations(), other.policyGenerations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyGenerationsResponse").add("PolicyGenerations", this.hasPolicyGenerations() ? this.policyGenerations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyGenerations": {
                return Optional.ofNullable(clazz.cast(this.policyGenerations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGenerationsResponse, T> g) {
        return obj -> g.apply((ListPolicyGenerationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<PolicyGeneration> policyGenerations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGenerationsResponse model) {
            super(model);
            this.policyGenerations(model.policyGenerations);
            this.nextToken(model.nextToken);
        }

        public final List<PolicyGeneration.Builder> getPolicyGenerations() {
            List<PolicyGeneration.Builder> result = PolicyGenerationListCopier.copyToBuilder(this.policyGenerations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyGenerations(Collection<PolicyGeneration.BuilderImpl> policyGenerations) {
            this.policyGenerations = PolicyGenerationListCopier.copyFromBuilder(policyGenerations);
        }

        @Override
        public final Builder policyGenerations(Collection<PolicyGeneration> policyGenerations) {
            this.policyGenerations = PolicyGenerationListCopier.copy(policyGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerations(PolicyGeneration ... policyGenerations) {
            this.policyGenerations(Arrays.asList(policyGenerations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGenerations(Consumer<PolicyGeneration.Builder> ... policyGenerations) {
            this.policyGenerations(Stream.of(policyGenerations).map(c -> (PolicyGeneration)((PolicyGeneration.Builder)PolicyGeneration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPolicyGenerationsResponse build() {
            return new ListPolicyGenerationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyGenerationsResponse> {
        public Builder policyGenerations(Collection<PolicyGeneration> var1);

        public Builder policyGenerations(PolicyGeneration ... var1);

        public Builder policyGenerations(Consumer<PolicyGeneration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

