/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria for an analysis rule for an analyzer. The criteria determine which entities will generate findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRuleCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRuleCriteria.Builder, AnalysisRuleCriteria> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(AnalysisRuleCriteria::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> RESOURCE_TAGS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("resourceTags")
            .getter(getter(AnalysisRuleCriteria::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            RESOURCE_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accountIds;

    private final List<Map<String, String>> resourceTags;

    private AnalysisRuleCriteria(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.resourceTags = builder.resourceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot include the
     * organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for
     * organization-level analyzers. The list cannot include more than 2,000 account IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot
     *         include the organization analyzer owner account. Account IDs can only be applied to the analysis rule
     *         criteria for organization-level analyzers. The list cannot include more than 2,000 account IDs.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits,
     * whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>, and <code>-</code>.
     * </p>
     * <p>
     * For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with
     * <code>aws:</code>.
     * </p>
     * <p>
     * For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value is 0
     * characters, the rule is applied to all principals with the specified tag key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits,
     *         whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>, and
     *         <code>-</code>.</p>
     *         <p>
     *         For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed
     *         with <code>aws:</code>.
     *         </p>
     *         <p>
     *         For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag
     *         value is 0 characters, the rule is applied to all principals with the specified tag key.
     */
    public final List<Map<String, String>> resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleCriteria)) {
            return false;
        }
        AnalysisRuleCriteria other = (AnalysisRuleCriteria) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasResourceTags() == other.hasResourceTags() && Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRuleCriteria").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "resourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleCriteria, T> g) {
        return obj -> g.apply((AnalysisRuleCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRuleCriteria> {
        /**
         * <p>
         * A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot include
         * the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for
         * organization-level analyzers. The list cannot include more than 2,000 account IDs.
         * </p>
         * 
         * @param accountIds
         *        A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot
         *        include the organization analyzer owner account. Account IDs can only be applied to the analysis rule
         *        criteria for organization-level analyzers. The list cannot include more than 2,000 account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot include
         * the organization analyzer owner account. Account IDs can only be applied to the analysis rule criteria for
         * organization-level analyzers. The list cannot include more than 2,000 account IDs.
         * </p>
         * 
         * @param accountIds
         *        A list of Amazon Web Services account IDs to apply to the analysis rule criteria. The accounts cannot
         *        include the organization analyzer owner account. Account IDs can only be applied to the analysis rule
         *        criteria for organization-level analyzers. The list cannot include more than 2,000 account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits,
         * whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>, and
         * <code>-</code>.
         * </p>
         * <p>
         * For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with
         * <code>aws:</code>.
         * </p>
         * <p>
         * For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value
         * is 0 characters, the rule is applied to all principals with the specified tag key.
         * </p>
         * 
         * @param resourceTags
         *        An array of key-value pairs to match for your resources. You can use the set of Unicode letters,
         *        digits, whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>,
         *        and <code>-</code>.</p>
         *        <p>
         *        For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed
         *        with <code>aws:</code>.
         *        </p>
         *        <p>
         *        For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag
         *        value is 0 characters, the rule is applied to all principals with the specified tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<? extends Map<String, String>> resourceTags);

        /**
         * <p>
         * An array of key-value pairs to match for your resources. You can use the set of Unicode letters, digits,
         * whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>, and
         * <code>-</code>.
         * </p>
         * <p>
         * For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with
         * <code>aws:</code>.
         * </p>
         * <p>
         * For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag value
         * is 0 characters, the rule is applied to all principals with the specified tag key.
         * </p>
         * 
         * @param resourceTags
         *        An array of key-value pairs to match for your resources. You can use the set of Unicode letters,
         *        digits, whitespace, <code>_</code>, <code>.</code>, <code>/</code>, <code>=</code>, <code>+</code>,
         *        and <code>-</code>.</p>
         *        <p>
         *        For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed
         *        with <code>aws:</code>.
         *        </p>
         *        <p>
         *        For the tag value, you can specify a value that is 0 to 256 characters in length. If the specified tag
         *        value is 0 characters, the rule is applied to all principals with the specified tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Map<String, String>... resourceTags);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, String>> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleCriteria model) {
            accountIds(model.accountIds);
            resourceTags(model.resourceTags);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<? extends Map<String, String>> getResourceTags() {
            if (resourceTags instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTags;
        }

        public final void setResourceTags(Collection<? extends Map<String, String>> resourceTags) {
            this.resourceTags = TagsListCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<? extends Map<String, String>> resourceTags) {
            this.resourceTags = TagsListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Map<String, String>... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        public AnalysisRuleCriteria build() {
            return new AnalysisRuleCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
