/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about CloudTrail access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudTrailDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudTrailDetails.Builder, CloudTrailDetails> {
    private static final SdkField<List<Trail>> TRAILS_FIELD = SdkField
            .<List<Trail>> builder(MarshallingType.LIST)
            .memberName("trails")
            .getter(getter(CloudTrailDetails::trails))
            .setter(setter(Builder::trails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trail> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessRole").getter(getter(CloudTrailDetails::accessRole)).setter(setter(Builder::accessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRole").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(CloudTrailDetails::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(CloudTrailDetails::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAILS_FIELD,
            ACCESS_ROLE_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Trail> trails;

    private final String accessRole;

    private final Instant startTime;

    private final Instant endTime;

    private CloudTrailDetails(BuilderImpl builder) {
        this.trails = builder.trails;
        this.accessRole = builder.accessRole;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Trails property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTrails() {
        return trails != null && !(trails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>Trail</code> object that contains settings for a trail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrails} method.
     * </p>
     * 
     * @return A <code>Trail</code> object that contains settings for a trail.
     */
    public final List<Trail> trails() {
        return trails;
    }

    /**
     * <p>
     * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service last
     * accessed information.
     * </p>
     * 
     * @return The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service
     *         last accessed information.
     */
    public final String accessRole() {
        return accessRole;
    }

    /**
     * <p>
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp
     * before this time are not considered to generate a policy.
     * </p>
     * 
     * @return The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
     *         timestamp before this time are not considered to generate a policy.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp
     * after this time are not considered to generate a policy. If this is not included in the request, the default
     * value is the current time.
     * </p>
     * 
     * @return The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
     *         timestamp after this time are not considered to generate a policy. If this is not included in the
     *         request, the default value is the current time.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTrails() ? trails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudTrailDetails)) {
            return false;
        }
        CloudTrailDetails other = (CloudTrailDetails) obj;
        return hasTrails() == other.hasTrails() && Objects.equals(trails(), other.trails())
                && Objects.equals(accessRole(), other.accessRole()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudTrailDetails").add("Trails", hasTrails() ? trails() : null).add("AccessRole", accessRole())
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trails":
            return Optional.ofNullable(clazz.cast(trails()));
        case "accessRole":
            return Optional.ofNullable(clazz.cast(accessRole()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trails", TRAILS_FIELD);
        map.put("accessRole", ACCESS_ROLE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudTrailDetails, T> g) {
        return obj -> g.apply((CloudTrailDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudTrailDetails> {
        /**
         * <p>
         * A <code>Trail</code> object that contains settings for a trail.
         * </p>
         * 
         * @param trails
         *        A <code>Trail</code> object that contains settings for a trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trails(Collection<Trail> trails);

        /**
         * <p>
         * A <code>Trail</code> object that contains settings for a trail.
         * </p>
         * 
         * @param trails
         *        A <code>Trail</code> object that contains settings for a trail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trails(Trail... trails);

        /**
         * <p>
         * A <code>Trail</code> object that contains settings for a trail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Trail.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.accessanalyzer.model.Trail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.Trail.Builder#build()} is called immediately and
         * its result is passed to {@link #trails(List<Trail>)}.
         * 
         * @param trails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.Trail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trails(java.util.Collection<Trail>)
         */
        Builder trails(Consumer<Trail.Builder>... trails);

        /**
         * <p>
         * The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service last
         * accessed information.
         * </p>
         * 
         * @param accessRole
         *        The ARN of the service role that IAM Access Analyzer uses to access your CloudTrail trail and service
         *        last accessed information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRole(String accessRole);

        /**
         * <p>
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         * timestamp before this time are not considered to generate a policy.
         * </p>
         * 
         * @param startTime
         *        The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         *        a timestamp before this time are not considered to generate a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         * timestamp after this time are not considered to generate a policy. If this is not included in the request,
         * the default value is the current time.
         * </p>
         * 
         * @param endTime
         *        The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         *        timestamp after this time are not considered to generate a policy. If this is not included in the
         *        request, the default value is the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private List<Trail> trails = DefaultSdkAutoConstructList.getInstance();

        private String accessRole;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudTrailDetails model) {
            trails(model.trails);
            accessRole(model.accessRole);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final List<Trail.Builder> getTrails() {
            List<Trail.Builder> result = TrailListCopier.copyToBuilder(this.trails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrails(Collection<Trail.BuilderImpl> trails) {
            this.trails = TrailListCopier.copyFromBuilder(trails);
        }

        @Override
        public final Builder trails(Collection<Trail> trails) {
            this.trails = TrailListCopier.copy(trails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trails(Trail... trails) {
            trails(Arrays.asList(trails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trails(Consumer<Trail.Builder>... trails) {
            trails(Stream.of(trails).map(c -> Trail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAccessRole() {
            return accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public CloudTrailDetails build() {
            return new CloudTrailDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
