/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about CloudTrail access.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudTrailProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudTrailProperties.Builder, CloudTrailProperties> {
    private static final SdkField<List<TrailProperties>> TRAIL_PROPERTIES_FIELD = SdkField
            .<List<TrailProperties>> builder(MarshallingType.LIST)
            .memberName("trailProperties")
            .getter(getter(CloudTrailProperties::trailProperties))
            .setter(setter(Builder::trailProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrailProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrailProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(CloudTrailProperties::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(CloudTrailProperties::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_PROPERTIES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TrailProperties> trailProperties;

    private final Instant startTime;

    private final Instant endTime;

    private CloudTrailProperties(BuilderImpl builder) {
        this.trailProperties = builder.trailProperties;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrailProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrailProperties() {
        return trailProperties != null && !(trailProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>TrailProperties</code> object that contains settings for trail properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrailProperties} method.
     * </p>
     * 
     * @return A <code>TrailProperties</code> object that contains settings for trail properties.
     */
    public final List<TrailProperties> trailProperties() {
        return trailProperties;
    }

    /**
     * <p>
     * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp
     * before this time are not considered to generate a policy.
     * </p>
     * 
     * @return The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
     *         timestamp before this time are not considered to generate a policy.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a timestamp
     * after this time are not considered to generate a policy. If this is not included in the request, the default
     * value is the current time.
     * </p>
     * 
     * @return The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
     *         timestamp after this time are not considered to generate a policy. If this is not included in the
     *         request, the default value is the current time.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTrailProperties() ? trailProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudTrailProperties)) {
            return false;
        }
        CloudTrailProperties other = (CloudTrailProperties) obj;
        return hasTrailProperties() == other.hasTrailProperties() && Objects.equals(trailProperties(), other.trailProperties())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudTrailProperties").add("TrailProperties", hasTrailProperties() ? trailProperties() : null)
                .add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trailProperties":
            return Optional.ofNullable(clazz.cast(trailProperties()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trailProperties", TRAIL_PROPERTIES_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudTrailProperties, T> g) {
        return obj -> g.apply((CloudTrailProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudTrailProperties> {
        /**
         * <p>
         * A <code>TrailProperties</code> object that contains settings for trail properties.
         * </p>
         * 
         * @param trailProperties
         *        A <code>TrailProperties</code> object that contains settings for trail properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailProperties(Collection<TrailProperties> trailProperties);

        /**
         * <p>
         * A <code>TrailProperties</code> object that contains settings for trail properties.
         * </p>
         * 
         * @param trailProperties
         *        A <code>TrailProperties</code> object that contains settings for trail properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailProperties(TrailProperties... trailProperties);

        /**
         * <p>
         * A <code>TrailProperties</code> object that contains settings for trail properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.TrailProperties.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.accessanalyzer.model.TrailProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.TrailProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #trailProperties(List<TrailProperties>)}.
         * 
         * @param trailProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.TrailProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trailProperties(java.util.Collection<TrailProperties>)
         */
        Builder trailProperties(Consumer<TrailProperties.Builder>... trailProperties);

        /**
         * <p>
         * The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         * timestamp before this time are not considered to generate a policy.
         * </p>
         * 
         * @param startTime
         *        The start of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with
         *        a timestamp before this time are not considered to generate a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         * timestamp after this time are not considered to generate a policy. If this is not included in the request,
         * the default value is the current time.
         * </p>
         * 
         * @param endTime
         *        The end of the time range for which IAM Access Analyzer reviews your CloudTrail events. Events with a
         *        timestamp after this time are not considered to generate a policy. If this is not included in the
         *        request, the default value is the current time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private List<TrailProperties> trailProperties = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudTrailProperties model) {
            trailProperties(model.trailProperties);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final List<TrailProperties.Builder> getTrailProperties() {
            List<TrailProperties.Builder> result = TrailPropertiesListCopier.copyToBuilder(this.trailProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrailProperties(Collection<TrailProperties.BuilderImpl> trailProperties) {
            this.trailProperties = TrailPropertiesListCopier.copyFromBuilder(trailProperties);
        }

        @Override
        public final Builder trailProperties(Collection<TrailProperties> trailProperties) {
            this.trailProperties = TrailPropertiesListCopier.copy(trailProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailProperties(TrailProperties... trailProperties) {
            trailProperties(Arrays.asList(trailProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailProperties(Consumer<TrailProperties.Builder>... trailProperties) {
            trailProperties(Stream.of(trailProperties).map(c -> TrailProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public CloudTrailProperties build() {
            return new CloudTrailProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
