/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for a DynamoDB stream. You can propose a configuration for a new DynamoDB
 * stream or an existing DynamoDB stream that you own by specifying the policy for the DynamoDB stream. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_PutResourcePolicy.html">PutResourcePolicy
 * </a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If the configuration is for an existing DynamoDB stream and you do not specify the DynamoDB policy, then the access
 * preview uses the existing DynamoDB policy for the stream.
 * </p>
 * </li>
 * <li>
 * <p>
 * If the access preview is for a new resource and you do not specify the policy, then the access preview assumes a
 * DynamoDB stream without a policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * To propose deletion of an existing DynamoDB stream policy, you can specify an empty string for the DynamoDB policy.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamodbStreamConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamodbStreamConfiguration.Builder, DynamodbStreamConfiguration> {
    private static final SdkField<String> STREAM_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamPolicy").getter(getter(DynamodbStreamConfiguration::streamPolicy))
            .setter(setter(Builder::streamPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamPolicy;

    private DynamodbStreamConfiguration(BuilderImpl builder) {
        this.streamPolicy = builder.streamPolicy;
    }

    /**
     * <p>
     * The proposed resource policy defining who can access or manage the DynamoDB stream.
     * </p>
     * 
     * @return The proposed resource policy defining who can access or manage the DynamoDB stream.
     */
    public final String streamPolicy() {
        return streamPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbStreamConfiguration)) {
            return false;
        }
        DynamodbStreamConfiguration other = (DynamodbStreamConfiguration) obj;
        return Objects.equals(streamPolicy(), other.streamPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamodbStreamConfiguration").add("StreamPolicy", streamPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamPolicy":
            return Optional.ofNullable(clazz.cast(streamPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("streamPolicy", STREAM_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamodbStreamConfiguration, T> g) {
        return obj -> g.apply((DynamodbStreamConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamodbStreamConfiguration> {
        /**
         * <p>
         * The proposed resource policy defining who can access or manage the DynamoDB stream.
         * </p>
         * 
         * @param streamPolicy
         *        The proposed resource policy defining who can access or manage the DynamoDB stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamPolicy(String streamPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String streamPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbStreamConfiguration model) {
            streamPolicy(model.streamPolicy);
        }

        public final String getStreamPolicy() {
            return streamPolicy;
        }

        public final void setStreamPolicy(String streamPolicy) {
            this.streamPolicy = streamPolicy;
        }

        @Override
        public final Builder streamPolicy(String streamPolicy) {
            this.streamPolicy = streamPolicy;
            return this;
        }

        @Override
        public DynamodbStreamConfiguration build() {
            return new DynamodbStreamConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
