/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for an Amazon ECR repository. You can propose a configuration for a new
 * Amazon ECR repository or an existing Amazon ECR repository that you own by specifying the Amazon ECR policy. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_Repository.html">Repository</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If the configuration is for an existing Amazon ECR repository and you do not specify the Amazon ECR policy, then the
 * access preview uses the existing Amazon ECR policy for the repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * If the access preview is for a new resource and you do not specify the policy, then the access preview assumes an
 * Amazon ECR repository without a policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * To propose deletion of an existing Amazon ECR repository policy, you can specify an empty string for the Amazon ECR
 * policy.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcrRepositoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EcrRepositoryConfiguration.Builder, EcrRepositoryConfiguration> {
    private static final SdkField<String> REPOSITORY_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryPolicy").getter(getter(EcrRepositoryConfiguration::repositoryPolicy))
            .setter(setter(Builder::repositoryPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryPolicy;

    private EcrRepositoryConfiguration(BuilderImpl builder) {
        this.repositoryPolicy = builder.repositoryPolicy;
    }

    /**
     * <p>
     * The JSON repository policy text to apply to the Amazon ECR repository. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Private repository
     * policy examples</a> in the <i>Amazon ECR User Guide</i>.
     * </p>
     * 
     * @return The JSON repository policy text to apply to the Amazon ECR repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Private
     *         repository policy examples</a> in the <i>Amazon ECR User Guide</i>.
     */
    public final String repositoryPolicy() {
        return repositoryPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrRepositoryConfiguration)) {
            return false;
        }
        EcrRepositoryConfiguration other = (EcrRepositoryConfiguration) obj;
        return Objects.equals(repositoryPolicy(), other.repositoryPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcrRepositoryConfiguration").add("RepositoryPolicy", repositoryPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryPolicy":
            return Optional.ofNullable(clazz.cast(repositoryPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("repositoryPolicy", REPOSITORY_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcrRepositoryConfiguration, T> g) {
        return obj -> g.apply((EcrRepositoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcrRepositoryConfiguration> {
        /**
         * <p>
         * The JSON repository policy text to apply to the Amazon ECR repository. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Private
         * repository policy examples</a> in the <i>Amazon ECR User Guide</i>.
         * </p>
         * 
         * @param repositoryPolicy
         *        The JSON repository policy text to apply to the Amazon ECR repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html">Private
         *        repository policy examples</a> in the <i>Amazon ECR User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryPolicy(String repositoryPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrRepositoryConfiguration model) {
            repositoryPolicy(model.repositoryPolicy);
        }

        public final String getRepositoryPolicy() {
            return repositoryPolicy;
        }

        public final void setRepositoryPolicy(String repositoryPolicy) {
            this.repositoryPolicy = repositoryPolicy;
        }

        @Override
        public final Builder repositoryPolicy(String repositoryPolicy) {
            this.repositoryPolicy = repositoryPolicy;
            return this;
        }

        @Override
        public EcrRepositoryConfiguration build() {
            return new EcrRepositoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
