/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes details about how the access that generated the finding is granted. This is populated for Amazon S3 bucket
 * findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingSourceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingSourceDetail.Builder, FindingSourceDetail> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPointArn").getter(getter(FindingSourceDetail::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointArn").build()).build();

    private static final SdkField<String> ACCESS_POINT_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPointAccount").getter(getter(FindingSourceDetail::accessPointAccount))
            .setter(setter(Builder::accessPointAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD,
            ACCESS_POINT_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessPointArn;

    private final String accessPointAccount;

    private FindingSourceDetail(BuilderImpl builder) {
        this.accessPointArn = builder.accessPointArn;
        this.accessPointAccount = builder.accessPointAccount;
    }

    /**
     * <p>
     * The ARN of the access point that generated the finding. The ARN format depends on whether the ARN represents an
     * access point or a multi-region access point.
     * </p>
     * 
     * @return The ARN of the access point that generated the finding. The ARN format depends on whether the ARN
     *         represents an access point or a multi-region access point.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * The account of the cross-account access point that generated the finding.
     * </p>
     * 
     * @return The account of the cross-account access point that generated the finding.
     */
    public final String accessPointAccount() {
        return accessPointAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSourceDetail)) {
            return false;
        }
        FindingSourceDetail other = (FindingSourceDetail) obj;
        return Objects.equals(accessPointArn(), other.accessPointArn())
                && Objects.equals(accessPointAccount(), other.accessPointAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingSourceDetail").add("AccessPointArn", accessPointArn())
                .add("AccessPointAccount", accessPointAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "accessPointAccount":
            return Optional.ofNullable(clazz.cast(accessPointAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("accessPointAccount", ACCESS_POINT_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingSourceDetail, T> g) {
        return obj -> g.apply((FindingSourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingSourceDetail> {
        /**
         * <p>
         * The ARN of the access point that generated the finding. The ARN format depends on whether the ARN represents
         * an access point or a multi-region access point.
         * </p>
         * 
         * @param accessPointArn
         *        The ARN of the access point that generated the finding. The ARN format depends on whether the ARN
         *        represents an access point or a multi-region access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * The account of the cross-account access point that generated the finding.
         * </p>
         * 
         * @param accessPointAccount
         *        The account of the cross-account access point that generated the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointAccount(String accessPointAccount);
    }

    static final class BuilderImpl implements Builder {
        private String accessPointArn;

        private String accessPointAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSourceDetail model) {
            accessPointArn(model.accessPointArn);
            accessPointAccount(model.accessPointAccount);
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getAccessPointAccount() {
            return accessPointAccount;
        }

        public final void setAccessPointAccount(String accessPointAccount) {
            this.accessPointAccount = accessPointAccount;
        }

        @Override
        public final Builder accessPointAccount(String accessPointAccount) {
            this.accessPointAccount = accessPointAccount;
            return this;
        }

        @Override
        public FindingSourceDetail build() {
            return new FindingSourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
