/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the reasoning why a check for access passed or failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReasonSummary implements SdkPojo, Serializable, ToCopyableBuilder<ReasonSummary.Builder, ReasonSummary> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReasonSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> STATEMENT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statementIndex").getter(getter(ReasonSummary::statementIndex)).setter(setter(Builder::statementIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementIndex").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(ReasonSummary::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            STATEMENT_INDEX_FIELD, STATEMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Integer statementIndex;

    private final String statementId;

    private ReasonSummary(BuilderImpl builder) {
        this.description = builder.description;
        this.statementIndex = builder.statementIndex;
        this.statementId = builder.statementId;
    }

    /**
     * <p>
     * A description of the reasoning of a result of checking for access.
     * </p>
     * 
     * @return A description of the reasoning of a result of checking for access.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The index number of the reason statement.
     * </p>
     * 
     * @return The index number of the reason statement.
     */
    public final Integer statementIndex() {
        return statementIndex;
    }

    /**
     * <p>
     * The identifier for the reason statement.
     * </p>
     * 
     * @return The identifier for the reason statement.
     */
    public final String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statementIndex());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReasonSummary)) {
            return false;
        }
        ReasonSummary other = (ReasonSummary) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(statementIndex(), other.statementIndex())
                && Objects.equals(statementId(), other.statementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReasonSummary").add("Description", description()).add("StatementIndex", statementIndex())
                .add("StatementId", statementId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "statementIndex":
            return Optional.ofNullable(clazz.cast(statementIndex()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("statementIndex", STATEMENT_INDEX_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReasonSummary, T> g) {
        return obj -> g.apply((ReasonSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReasonSummary> {
        /**
         * <p>
         * A description of the reasoning of a result of checking for access.
         * </p>
         * 
         * @param description
         *        A description of the reasoning of a result of checking for access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The index number of the reason statement.
         * </p>
         * 
         * @param statementIndex
         *        The index number of the reason statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementIndex(Integer statementIndex);

        /**
         * <p>
         * The identifier for the reason statement.
         * </p>
         * 
         * @param statementId
         *        The identifier for the reason statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Integer statementIndex;

        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReasonSummary model) {
            description(model.description);
            statementIndex(model.statementIndex);
            statementId(model.statementId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getStatementIndex() {
            return statementIndex;
        }

        public final void setStatementIndex(Integer statementIndex) {
            this.statementIndex = statementIndex;
        }

        @Override
        public final Builder statementIndex(Integer statementIndex) {
            this.statementIndex = statementIndex;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        @Override
        public ReasonSummary build() {
            return new ReasonSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
