/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a recommended step for an unused access analyzer finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedStep implements SdkPojo, Serializable, ToCopyableBuilder<RecommendedStep.Builder, RecommendedStep> {
    private static final SdkField<UnusedPermissionsRecommendedStep> UNUSED_PERMISSIONS_RECOMMENDED_STEP_FIELD = SdkField
            .<UnusedPermissionsRecommendedStep> builder(MarshallingType.SDK_POJO)
            .memberName("unusedPermissionsRecommendedStep")
            .getter(getter(RecommendedStep::unusedPermissionsRecommendedStep))
            .setter(setter(Builder::unusedPermissionsRecommendedStep))
            .constructor(UnusedPermissionsRecommendedStep::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedPermissionsRecommendedStep")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNUSED_PERMISSIONS_RECOMMENDED_STEP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep;

    private final Type type;

    private RecommendedStep(BuilderImpl builder) {
        this.unusedPermissionsRecommendedStep = builder.unusedPermissionsRecommendedStep;
        this.type = builder.type;
    }

    /**
     * <p>
     * A recommended step for an unused permissions finding.
     * </p>
     * 
     * @return A recommended step for an unused permissions finding.
     */
    public final UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep() {
        return unusedPermissionsRecommendedStep;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unusedPermissionsRecommendedStep());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedStep)) {
            return false;
        }
        RecommendedStep other = (RecommendedStep) obj;
        return Objects.equals(unusedPermissionsRecommendedStep(), other.unusedPermissionsRecommendedStep());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedStep").add("UnusedPermissionsRecommendedStep", unusedPermissionsRecommendedStep())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unusedPermissionsRecommendedStep":
            return Optional.ofNullable(clazz.cast(unusedPermissionsRecommendedStep()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #unusedPermissionsRecommendedStep()} initialized to the given value.
     *
     * <p>
     * A recommended step for an unused permissions finding.
     * </p>
     * 
     * @param unusedPermissionsRecommendedStep
     *        A recommended step for an unused permissions finding.
     */
    public static RecommendedStep fromUnusedPermissionsRecommendedStep(
            UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep) {
        return builder().unusedPermissionsRecommendedStep(unusedPermissionsRecommendedStep).build();
    }

    /**
     * Create an instance of this class with {@link #unusedPermissionsRecommendedStep()} initialized to the given value.
     *
     * <p>
     * A recommended step for an unused permissions finding.
     * </p>
     * 
     * @param unusedPermissionsRecommendedStep
     *        A recommended step for an unused permissions finding.
     */
    public static RecommendedStep fromUnusedPermissionsRecommendedStep(
            Consumer<UnusedPermissionsRecommendedStep.Builder> unusedPermissionsRecommendedStep) {
        UnusedPermissionsRecommendedStep.Builder builder = UnusedPermissionsRecommendedStep.builder();
        unusedPermissionsRecommendedStep.accept(builder);
        return fromUnusedPermissionsRecommendedStep(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unusedPermissionsRecommendedStep", UNUSED_PERMISSIONS_RECOMMENDED_STEP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedStep, T> g) {
        return obj -> g.apply((RecommendedStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedStep> {
        /**
         * <p>
         * A recommended step for an unused permissions finding.
         * </p>
         * 
         * @param unusedPermissionsRecommendedStep
         *        A recommended step for an unused permissions finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedPermissionsRecommendedStep(UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep);

        /**
         * <p>
         * A recommended step for an unused permissions finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedPermissionsRecommendedStep.Builder}
         * avoiding the need to create one manually via {@link UnusedPermissionsRecommendedStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedPermissionsRecommendedStep.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #unusedPermissionsRecommendedStep(UnusedPermissionsRecommendedStep)}.
         * 
         * @param unusedPermissionsRecommendedStep
         *        a consumer that will call methods on {@link UnusedPermissionsRecommendedStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedPermissionsRecommendedStep(UnusedPermissionsRecommendedStep)
         */
        default Builder unusedPermissionsRecommendedStep(
                Consumer<UnusedPermissionsRecommendedStep.Builder> unusedPermissionsRecommendedStep) {
            return unusedPermissionsRecommendedStep(UnusedPermissionsRecommendedStep.builder()
                    .applyMutation(unusedPermissionsRecommendedStep).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedStep model) {
            unusedPermissionsRecommendedStep(model.unusedPermissionsRecommendedStep);
        }

        public final UnusedPermissionsRecommendedStep.Builder getUnusedPermissionsRecommendedStep() {
            return unusedPermissionsRecommendedStep != null ? unusedPermissionsRecommendedStep.toBuilder() : null;
        }

        public final void setUnusedPermissionsRecommendedStep(
                UnusedPermissionsRecommendedStep.BuilderImpl unusedPermissionsRecommendedStep) {
            Object oldValue = this.unusedPermissionsRecommendedStep;
            this.unusedPermissionsRecommendedStep = unusedPermissionsRecommendedStep != null ? unusedPermissionsRecommendedStep
                    .build() : null;
            handleUnionValueChange(Type.UNUSED_PERMISSIONS_RECOMMENDED_STEP, oldValue, this.unusedPermissionsRecommendedStep);
        }

        @Override
        public final Builder unusedPermissionsRecommendedStep(UnusedPermissionsRecommendedStep unusedPermissionsRecommendedStep) {
            Object oldValue = this.unusedPermissionsRecommendedStep;
            this.unusedPermissionsRecommendedStep = unusedPermissionsRecommendedStep;
            handleUnionValueChange(Type.UNUSED_PERMISSIONS_RECOMMENDED_STEP, oldValue, this.unusedPermissionsRecommendedStep);
            return this;
        }

        @Override
        public RecommendedStep build() {
            return new RecommendedStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RecommendedStep#type()
     */
    public enum Type {
        UNUSED_PERMISSIONS_RECOMMENDED_STEP,

        UNKNOWN_TO_SDK_VERSION
    }
}
