/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for an Amazon SNS topic. You can propose a configuration for a new Amazon
 * SNS topic or an existing Amazon SNS topic that you own by specifying the policy. If the configuration is for an
 * existing Amazon SNS topic and you do not specify the Amazon SNS policy, then the access preview uses the existing
 * Amazon SNS policy for the topic. If the access preview is for a new resource and you do not specify the policy, then
 * the access preview assumes an Amazon SNS topic without a policy. To propose deletion of an existing Amazon SNS topic
 * policy, you can specify an empty string for the Amazon SNS policy. For more information, see <a
 * href="https://docs.aws.amazon.com/sns/latest/api/API_Topic.html">Topic</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnsTopicConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnsTopicConfiguration.Builder, SnsTopicConfiguration> {
    private static final SdkField<String> TOPIC_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("topicPolicy").getter(getter(SnsTopicConfiguration::topicPolicy)).setter(setter(Builder::topicPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String topicPolicy;

    private SnsTopicConfiguration(BuilderImpl builder) {
        this.topicPolicy = builder.topicPolicy;
    }

    /**
     * <p>
     * The JSON policy text that defines who can access an Amazon SNS topic. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-access-policy-use-cases.html">Example cases for Amazon SNS
     * access control</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * 
     * @return The JSON policy text that defines who can access an Amazon SNS topic. For more information, see <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/sns-access-policy-use-cases.html">Example cases for
     *         Amazon SNS access control</a> in the <i>Amazon SNS Developer Guide</i>.
     */
    public final String topicPolicy() {
        return topicPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsTopicConfiguration)) {
            return false;
        }
        SnsTopicConfiguration other = (SnsTopicConfiguration) obj;
        return Objects.equals(topicPolicy(), other.topicPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnsTopicConfiguration").add("TopicPolicy", topicPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicPolicy":
            return Optional.ofNullable(clazz.cast(topicPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicPolicy", TOPIC_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnsTopicConfiguration, T> g) {
        return obj -> g.apply((SnsTopicConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnsTopicConfiguration> {
        /**
         * <p>
         * The JSON policy text that defines who can access an Amazon SNS topic. For more information, see <a
         * href="https://docs.aws.amazon.com/sns/latest/dg/sns-access-policy-use-cases.html">Example cases for Amazon
         * SNS access control</a> in the <i>Amazon SNS Developer Guide</i>.
         * </p>
         * 
         * @param topicPolicy
         *        The JSON policy text that defines who can access an Amazon SNS topic. For more information, see <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/sns-access-policy-use-cases.html">Example cases for
         *        Amazon SNS access control</a> in the <i>Amazon SNS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicy(String topicPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String topicPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsTopicConfiguration model) {
            topicPolicy(model.topicPolicy);
        }

        public final String getTopicPolicy() {
            return topicPolicy;
        }

        public final void setTopicPolicy(String topicPolicy) {
            this.topicPolicy = topicPolicy;
        }

        @Override
        public final Builder topicPolicy(String topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        @Override
        public SnsTopicConfiguration build() {
            return new SnsTopicConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
