/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidatePolicyRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<ValidatePolicyRequest.Builder, ValidatePolicyRequest> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("locale")
            .getter(getter(ValidatePolicyRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ValidatePolicyRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ValidatePolicyRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(ValidatePolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(ValidatePolicyRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<String> VALIDATE_POLICY_RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("validatePolicyResourceType")
            .getter(getter(ValidatePolicyRequest::validatePolicyResourceTypeAsString))
            .setter(setter(Builder::validatePolicyResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatePolicyResourceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, POLICY_DOCUMENT_FIELD, POLICY_TYPE_FIELD, VALIDATE_POLICY_RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String locale;

    private final Integer maxResults;

    private final String nextToken;

    private final String policyDocument;

    private final String policyType;

    private final String validatePolicyResourceType;

    private ValidatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.policyDocument = builder.policyDocument;
        this.policyType = builder.policyType;
        this.validatePolicyResourceType = builder.validatePolicyResourceType;
    }

    /**
     * <p>
     * The locale to use for localizing the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale to use for localizing the findings.
     * @see Locale
     */
    public final Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The locale to use for localizing the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale to use for localizing the findings.
     * @see Locale
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The JSON policy document to use as the content for the policy.
     * </p>
     * 
     * @return The JSON policy document to use as the content for the policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include
     * managed and inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy
     * or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * </p>
     * <p>
     * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
     * organization, organizational unit (OU), or an account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies
     *         include managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
     *         identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     *         </p>
     *         <p>
     *         Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
     *         organization, organizational unit (OU), or an account.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies include
     * managed and inline policies for IAM roles, users, and groups.
     * </p>
     * <p>
     * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust policies
     * for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as identity policy
     * or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     * </p>
     * <p>
     * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
     * organization, organizational unit (OU), or an account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies
     *         include managed and inline policies for IAM roles, users, and groups.</p>
     *         <p>
     *         Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
     *         policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
     *         identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
     *         </p>
     *         <p>
     *         Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
     *         organization, organizational unit (OU), or an account.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * The type of resource to attach to your resource policy. Specify a value for the policy validation resource type
     * only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to
     * an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.
     * </p>
     * <p>
     * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all
     * resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for
     * the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validatePolicyResourceType} will return {@link ValidatePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #validatePolicyResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to attach to your resource policy. Specify a value for the policy validation
     *         resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a
     *         resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the
     *         policy validation resource type.</p>
     *         <p>
     *         For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to
     *         all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify
     *         a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply
     *         to all resource policies.
     * @see ValidatePolicyResourceType
     */
    public final ValidatePolicyResourceType validatePolicyResourceType() {
        return ValidatePolicyResourceType.fromValue(validatePolicyResourceType);
    }

    /**
     * <p>
     * The type of resource to attach to your resource policy. Specify a value for the policy validation resource type
     * only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to attach to
     * an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource type.
     * </p>
     * <p>
     * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all
     * resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value for
     * the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all resource
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validatePolicyResourceType} will return {@link ValidatePolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #validatePolicyResourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource to attach to your resource policy. Specify a value for the policy validation
     *         resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a
     *         resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the
     *         policy validation resource type.</p>
     *         <p>
     *         For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to
     *         all resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify
     *         a value for the policy validation resource type and IAM Access Analyzer will run policy checks that apply
     *         to all resource policies.
     * @see ValidatePolicyResourceType
     */
    public final String validatePolicyResourceTypeAsString() {
        return validatePolicyResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validatePolicyResourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePolicyRequest)) {
            return false;
        }
        ValidatePolicyRequest other = (ValidatePolicyRequest) obj;
        return Objects.equals(localeAsString(), other.localeAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(validatePolicyResourceTypeAsString(), other.validatePolicyResourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidatePolicyRequest").add("Locale", localeAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("PolicyDocument", policyDocument()).add("PolicyType", policyTypeAsString())
                .add("ValidatePolicyResourceType", validatePolicyResourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "validatePolicyResourceType":
            return Optional.ofNullable(clazz.cast(validatePolicyResourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("locale", LOCALE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("validatePolicyResourceType", VALIDATE_POLICY_RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatePolicyRequest, T> g) {
        return obj -> g.apply((ValidatePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ValidatePolicyRequest> {
        /**
         * <p>
         * The locale to use for localizing the findings.
         * </p>
         * 
         * @param locale
         *        The locale to use for localizing the findings.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale to use for localizing the findings.
         * </p>
         * 
         * @param locale
         *        The locale to use for localizing the findings.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The JSON policy document to use as the content for the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON policy document to use as the content for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies
         * include managed and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
         * identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
         * </p>
         * <p>
         * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
         * organization, organizational unit (OU), or an account.
         * </p>
         * 
         * @param policyType
         *        The type of policy to validate. Identity policies grant permissions to IAM principals. Identity
         *        policies include managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such
         *        as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket
         *        policy.
         *        </p>
         *        <p>
         *        Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
         *        organization, organizational unit (OU), or an account.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy to validate. Identity policies grant permissions to IAM principals. Identity policies
         * include managed and inline policies for IAM roles, users, and groups.
         * </p>
         * <p>
         * Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         * policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such as
         * identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket policy.
         * </p>
         * <p>
         * Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
         * organization, organizational unit (OU), or an account.
         * </p>
         * 
         * @param policyType
         *        The type of policy to validate. Identity policies grant permissions to IAM principals. Identity
         *        policies include managed and inline policies for IAM roles, users, and groups.</p>
         *        <p>
         *        Resource policies grant permissions on Amazon Web Services resources. Resource policies include trust
         *        policies for IAM roles and bucket policies for Amazon S3 buckets. You can provide a generic input such
         *        as identity policy or resource policy or a specific input such as managed policy or Amazon S3 bucket
         *        policy.
         *        </p>
         *        <p>
         *        Service control policies (SCPs) are a type of organization policy attached to an Amazon Web Services
         *        organization, organizational unit (OU), or an account.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * The type of resource to attach to your resource policy. Specify a value for the policy validation resource
         * type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to
         * attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource
         * type.
         * </p>
         * <p>
         * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all
         * resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value
         * for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all
         * resource policies.
         * </p>
         * 
         * @param validatePolicyResourceType
         *        The type of resource to attach to your resource policy. Specify a value for the policy validation
         *        resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a
         *        resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the
         *        policy validation resource type.</p>
         *        <p>
         *        For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to
         *        all resource policies. For example, to validate a resource policy to attach to a KMS key, do not
         *        specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks
         *        that apply to all resource policies.
         * @see ValidatePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatePolicyResourceType
         */
        Builder validatePolicyResourceType(String validatePolicyResourceType);

        /**
         * <p>
         * The type of resource to attach to your resource policy. Specify a value for the policy validation resource
         * type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a resource policy to
         * attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the policy validation resource
         * type.
         * </p>
         * <p>
         * For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to all
         * resource policies. For example, to validate a resource policy to attach to a KMS key, do not specify a value
         * for the policy validation resource type and IAM Access Analyzer will run policy checks that apply to all
         * resource policies.
         * </p>
         * 
         * @param validatePolicyResourceType
         *        The type of resource to attach to your resource policy. Specify a value for the policy validation
         *        resource type only if the policy type is <code>RESOURCE_POLICY</code>. For example, to validate a
         *        resource policy to attach to an Amazon S3 bucket, you can choose <code>AWS::S3::Bucket</code> for the
         *        policy validation resource type.</p>
         *        <p>
         *        For resource types not supported as valid values, IAM Access Analyzer runs policy checks that apply to
         *        all resource policies. For example, to validate a resource policy to attach to a KMS key, do not
         *        specify a value for the policy validation resource type and IAM Access Analyzer will run policy checks
         *        that apply to all resource policies.
         * @see ValidatePolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidatePolicyResourceType
         */
        Builder validatePolicyResourceType(ValidatePolicyResourceType validatePolicyResourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String locale;

        private Integer maxResults;

        private String nextToken;

        private String policyDocument;

        private String policyType;

        private String validatePolicyResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePolicyRequest model) {
            super(model);
            locale(model.locale);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            policyDocument(model.policyDocument);
            policyType(model.policyType);
            validatePolicyResourceType(model.validatePolicyResourceType);
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getValidatePolicyResourceType() {
            return validatePolicyResourceType;
        }

        public final void setValidatePolicyResourceType(String validatePolicyResourceType) {
            this.validatePolicyResourceType = validatePolicyResourceType;
        }

        @Override
        public final Builder validatePolicyResourceType(String validatePolicyResourceType) {
            this.validatePolicyResourceType = validatePolicyResourceType;
            return this;
        }

        @Override
        public final Builder validatePolicyResourceType(ValidatePolicyResourceType validatePolicyResourceType) {
            this.validatePolicyResourceType(validatePolicyResourceType == null ? null : validatePolicyResourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidatePolicyRequest build() {
            return new ValidatePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
