/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccountIdsListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceArnsListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternalAccessAnalysisRuleCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternalAccessAnalysisRuleCriteria> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIds").getter(InternalAccessAnalysisRuleCriteria.getter(InternalAccessAnalysisRuleCriteria::accountIds)).setter(InternalAccessAnalysisRuleCriteria.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTypes").getter(InternalAccessAnalysisRuleCriteria.getter(InternalAccessAnalysisRuleCriteria::resourceTypesAsStrings)).setter(InternalAccessAnalysisRuleCriteria.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(InternalAccessAnalysisRuleCriteria.getter(InternalAccessAnalysisRuleCriteria::resourceArns)).setter(InternalAccessAnalysisRuleCriteria.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, RESOURCE_TYPES_FIELD, RESOURCE_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InternalAccessAnalysisRuleCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> accountIds;
    private final List<String> resourceTypes;
    private final List<String> resourceArns;

    private InternalAccessAnalysisRuleCriteria(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.resourceTypes = builder.resourceTypes;
        this.resourceArns = builder.resourceArns;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final List<ResourceType> resourceTypes() {
        return ResourceTypeListCopier.copyStringToEnum(this.resourceTypes);
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public final boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArns() {
        return this.resourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessAnalysisRuleCriteria)) {
            return false;
        }
        InternalAccessAnalysisRuleCriteria other = (InternalAccessAnalysisRuleCriteria)obj;
        return this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns());
    }

    public final String toString() {
        return ToString.builder((String)"InternalAccessAnalysisRuleCriteria").add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypesAsStrings() : null).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "resourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessAnalysisRuleCriteria, T> g) {
        return obj -> g.apply((InternalAccessAnalysisRuleCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessAnalysisRuleCriteria model) {
            this.accountIds(model.accountIds);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.resourceArns(model.resourceArns);
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceType ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public InternalAccessAnalysisRuleCriteria build() {
            return new InternalAccessAnalysisRuleCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternalAccessAnalysisRuleCriteria> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceType> var1);

        public Builder resourceTypes(ResourceType ... var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);
    }
}

