/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You specify each grantee as a type-value pair using one of these types. You can specify only one type of grantee. For
 * more information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketAcl.html">PutBucketAcl</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AclGrantee implements SdkPojo, Serializable, ToCopyableBuilder<AclGrantee.Builder, AclGrantee> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AclGrantee::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uri")
            .getter(getter(AclGrantee::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String uri;

    private final Type type;

    private AclGrantee(BuilderImpl builder) {
        this.id = builder.id;
        this.uri = builder.uri;
        this.type = builder.type;
    }

    /**
     * <p>
     * The value specified is the canonical user ID of an Amazon Web Services account.
     * </p>
     * 
     * @return The value specified is the canonical user ID of an Amazon Web Services account.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Used for granting permissions to a predefined group.
     * </p>
     * 
     * @return Used for granting permissions to a predefined group.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AclGrantee)) {
            return false;
        }
        AclGrantee other = (AclGrantee) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AclGrantee").add("Id", id()).add("Uri", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "uri":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #id()} initialized to the given value.
     *
     * <p>
     * The value specified is the canonical user ID of an Amazon Web Services account.
     * </p>
     * 
     * @param id
     *        The value specified is the canonical user ID of an Amazon Web Services account.
     */
    public static AclGrantee fromId(String id) {
        return builder().id(id).build();
    }

    /**
     * Create an instance of this class with {@link #uri()} initialized to the given value.
     *
     * <p>
     * Used for granting permissions to a predefined group.
     * </p>
     * 
     * @param uri
     *        Used for granting permissions to a predefined group.
     */
    public static AclGrantee fromUri(String uri) {
        return builder().uri(uri).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("uri", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AclGrantee, T> g) {
        return obj -> g.apply((AclGrantee) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AclGrantee> {
        /**
         * <p>
         * The value specified is the canonical user ID of an Amazon Web Services account.
         * </p>
         * 
         * @param id
         *        The value specified is the canonical user ID of an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Used for granting permissions to a predefined group.
         * </p>
         * 
         * @param uri
         *        Used for granting permissions to a predefined group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String uri;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AclGrantee model) {
            id(model.id);
            uri(model.uri);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            Object oldValue = this.id;
            this.id = id;
            handleUnionValueChange(Type.ID, oldValue, this.id);
        }

        @Override
        public final Builder id(String id) {
            Object oldValue = this.id;
            this.id = id;
            handleUnionValueChange(Type.ID, oldValue, this.id);
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            Object oldValue = this.uri;
            this.uri = uri;
            handleUnionValueChange(Type.URI, oldValue, this.uri);
        }

        @Override
        public final Builder uri(String uri) {
            Object oldValue = this.uri;
            this.uri = uri;
            handleUnionValueChange(Type.URI, oldValue, this.uri);
            return this;
        }

        @Override
        public AclGrantee build() {
            return new AclGrantee(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AclGrantee#type()
     */
    public enum Type {
        ID,

        URI,

        UNKNOWN_TO_SDK_VERSION
    }
}
