/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class InternalAccessResourceTypeStatisticsMapCopier {
    static Map<String, InternalAccessResourceTypeDetails> copy(
            Map<String, ? extends InternalAccessResourceTypeDetails> internalAccessResourceTypeStatisticsMapParam) {
        Map<String, InternalAccessResourceTypeDetails> map;
        if (internalAccessResourceTypeStatisticsMapParam == null
                || internalAccessResourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, InternalAccessResourceTypeDetails> modifiableMap = new LinkedHashMap<>(
                    internalAccessResourceTypeStatisticsMapParam.size());
            internalAccessResourceTypeStatisticsMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, InternalAccessResourceTypeDetails> copyFromBuilder(
            Map<String, ? extends InternalAccessResourceTypeDetails.Builder> internalAccessResourceTypeStatisticsMapParam) {
        Map<String, InternalAccessResourceTypeDetails> map;
        if (internalAccessResourceTypeStatisticsMapParam == null
                || internalAccessResourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, InternalAccessResourceTypeDetails> modifiableMap = new LinkedHashMap<>(
                    internalAccessResourceTypeStatisticsMapParam.size());
            internalAccessResourceTypeStatisticsMapParam.forEach((key, value) -> {
                InternalAccessResourceTypeDetails member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, InternalAccessResourceTypeDetails.Builder> copyToBuilder(
            Map<String, ? extends InternalAccessResourceTypeDetails> internalAccessResourceTypeStatisticsMapParam) {
        Map<String, InternalAccessResourceTypeDetails.Builder> map;
        if (internalAccessResourceTypeStatisticsMapParam == null
                || internalAccessResourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, InternalAccessResourceTypeDetails.Builder> modifiableMap = new LinkedHashMap<>(
                    internalAccessResourceTypeStatisticsMapParam.size());
            internalAccessResourceTypeStatisticsMapParam.forEach((key, value) -> {
                InternalAccessResourceTypeDetails.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, InternalAccessResourceTypeDetails> copyEnumToString(
            Map<ResourceType, ? extends InternalAccessResourceTypeDetails> internalAccessResourceTypeStatisticsMapParam) {
        Map<String, InternalAccessResourceTypeDetails> map;
        if (internalAccessResourceTypeStatisticsMapParam == null
                || internalAccessResourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, InternalAccessResourceTypeDetails> modifiableMap = new LinkedHashMap<>(
                    internalAccessResourceTypeStatisticsMapParam.size());
            internalAccessResourceTypeStatisticsMapParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ResourceType, InternalAccessResourceTypeDetails> copyStringToEnum(
            Map<String, ? extends InternalAccessResourceTypeDetails> internalAccessResourceTypeStatisticsMapParam) {
        Map<ResourceType, InternalAccessResourceTypeDetails> map;
        if (internalAccessResourceTypeStatisticsMapParam == null
                || internalAccessResourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ResourceType, InternalAccessResourceTypeDetails> modifiableMap = new LinkedHashMap<>(
                    internalAccessResourceTypeStatisticsMapParam.size());
            internalAccessResourceTypeStatisticsMapParam.forEach((key, value) -> {
                ResourceType result = ResourceType.fromValue(key);
                if (result != ResourceType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
