/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the total number of active cross-account and public findings for a resource type of an
 * external access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTypeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTypeDetails.Builder, ResourceTypeDetails> {
    private static final SdkField<Integer> TOTAL_ACTIVE_PUBLIC_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalActivePublic").getter(getter(ResourceTypeDetails::totalActivePublic))
            .setter(setter(Builder::totalActivePublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActivePublic").build()).build();

    private static final SdkField<Integer> TOTAL_ACTIVE_CROSS_ACCOUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalActiveCrossAccount").getter(getter(ResourceTypeDetails::totalActiveCrossAccount))
            .setter(setter(Builder::totalActiveCrossAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveCrossAccount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ACTIVE_PUBLIC_FIELD,
            TOTAL_ACTIVE_CROSS_ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalActivePublic;

    private final Integer totalActiveCrossAccount;

    private ResourceTypeDetails(BuilderImpl builder) {
        this.totalActivePublic = builder.totalActivePublic;
        this.totalActiveCrossAccount = builder.totalActiveCrossAccount;
    }

    /**
     * <p>
     * The total number of active public findings for the resource type.
     * </p>
     * 
     * @return The total number of active public findings for the resource type.
     */
    public final Integer totalActivePublic() {
        return totalActivePublic;
    }

    /**
     * <p>
     * The total number of active cross-account findings for the resource type.
     * </p>
     * 
     * @return The total number of active cross-account findings for the resource type.
     */
    public final Integer totalActiveCrossAccount() {
        return totalActiveCrossAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalActivePublic());
        hashCode = 31 * hashCode + Objects.hashCode(totalActiveCrossAccount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTypeDetails)) {
            return false;
        }
        ResourceTypeDetails other = (ResourceTypeDetails) obj;
        return Objects.equals(totalActivePublic(), other.totalActivePublic())
                && Objects.equals(totalActiveCrossAccount(), other.totalActiveCrossAccount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTypeDetails").add("TotalActivePublic", totalActivePublic())
                .add("TotalActiveCrossAccount", totalActiveCrossAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalActivePublic":
            return Optional.ofNullable(clazz.cast(totalActivePublic()));
        case "totalActiveCrossAccount":
            return Optional.ofNullable(clazz.cast(totalActiveCrossAccount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalActivePublic", TOTAL_ACTIVE_PUBLIC_FIELD);
        map.put("totalActiveCrossAccount", TOTAL_ACTIVE_CROSS_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceTypeDetails, T> g) {
        return obj -> g.apply((ResourceTypeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTypeDetails> {
        /**
         * <p>
         * The total number of active public findings for the resource type.
         * </p>
         * 
         * @param totalActivePublic
         *        The total number of active public findings for the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActivePublic(Integer totalActivePublic);

        /**
         * <p>
         * The total number of active cross-account findings for the resource type.
         * </p>
         * 
         * @param totalActiveCrossAccount
         *        The total number of active cross-account findings for the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActiveCrossAccount(Integer totalActiveCrossAccount);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalActivePublic;

        private Integer totalActiveCrossAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTypeDetails model) {
            totalActivePublic(model.totalActivePublic);
            totalActiveCrossAccount(model.totalActiveCrossAccount);
        }

        public final Integer getTotalActivePublic() {
            return totalActivePublic;
        }

        public final void setTotalActivePublic(Integer totalActivePublic) {
            this.totalActivePublic = totalActivePublic;
        }

        @Override
        public final Builder totalActivePublic(Integer totalActivePublic) {
            this.totalActivePublic = totalActivePublic;
            return this;
        }

        public final Integer getTotalActiveCrossAccount() {
            return totalActiveCrossAccount;
        }

        public final void setTotalActiveCrossAccount(Integer totalActiveCrossAccount) {
            this.totalActiveCrossAccount = totalActiveCrossAccount;
        }

        @Override
        public final Builder totalActiveCrossAccount(Integer totalActiveCrossAccount) {
            this.totalActiveCrossAccount = totalActiveCrossAccount;
            return this;
        }

        @Override
        public ResourceTypeDetails build() {
            return new ResourceTypeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
