/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria to use in the filter that defines the archive rule. For more information on available filter keys, see
 * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-filter-keys.html">IAM Access
 * Analyzer filter keys</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Criterion implements SdkPojo, Serializable, ToCopyableBuilder<Criterion.Builder, Criterion> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eq")
            .getter(getter(Criterion::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("neq")
            .getter(getter(Criterion::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("contains")
            .getter(getter(Criterion::contains))
            .setter(setter(Builder::contains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("exists").getter(getter(Criterion::exists)).setter(setter(Builder::exists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exists").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD, NEQ_FIELD,
            CONTAINS_FIELD, EXISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final List<String> neq;

    private final List<String> contains;

    private final Boolean exists;

    private Criterion(BuilderImpl builder) {
        this.eq = builder.eq;
        this.neq = builder.neq;
        this.contains = builder.contains;
        this.exists = builder.exists;
    }

    /**
     * For responses, this returns true if the service returned a value for the Eq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An "equals" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEq} method.
     * </p>
     * 
     * @return An "equals" operator to match for the filter used to create the rule.
     */
    public final List<String> eq() {
        return eq;
    }

    /**
     * For responses, this returns true if the service returned a value for the Neq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A "not equals" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNeq} method.
     * </p>
     * 
     * @return A "not equals" operator to match for the filter used to create the rule.
     */
    public final List<String> neq() {
        return neq;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContains() {
        return contains != null && !(contains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A "contains" operator to match for the filter used to create the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContains} method.
     * </p>
     * 
     * @return A "contains" operator to match for the filter used to create the rule.
     */
    public final List<String> contains() {
        return contains;
    }

    /**
     * <p>
     * An "exists" operator to match for the filter used to create the rule.
     * </p>
     * 
     * @return An "exists" operator to match for the filter used to create the rule.
     */
    public final Boolean exists() {
        return exists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEq() ? eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNeq() ? neq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContains() ? contains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(exists());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Criterion)) {
            return false;
        }
        Criterion other = (Criterion) obj;
        return hasEq() == other.hasEq() && Objects.equals(eq(), other.eq()) && hasNeq() == other.hasNeq()
                && Objects.equals(neq(), other.neq()) && hasContains() == other.hasContains()
                && Objects.equals(contains(), other.contains()) && Objects.equals(exists(), other.exists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Criterion").add("Eq", hasEq() ? eq() : null).add("Neq", hasNeq() ? neq() : null)
                .add("Contains", hasContains() ? contains() : null).add("Exists", exists()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "neq":
            return Optional.ofNullable(clazz.cast(neq()));
        case "contains":
            return Optional.ofNullable(clazz.cast(contains()));
        case "exists":
            return Optional.ofNullable(clazz.cast(exists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eq", EQ_FIELD);
        map.put("neq", NEQ_FIELD);
        map.put("contains", CONTAINS_FIELD);
        map.put("exists", EXISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Criterion, T> g) {
        return obj -> g.apply((Criterion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Criterion> {
        /**
         * <p>
         * An "equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param eq
         *        An "equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * An "equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param eq
         *        An "equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * A "not equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param neq
         *        A "not equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * A "not equals" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param neq
         *        A "not equals" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);

        /**
         * <p>
         * A "contains" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param contains
         *        A "contains" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contains(Collection<String> contains);

        /**
         * <p>
         * A "contains" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param contains
         *        A "contains" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contains(String... contains);

        /**
         * <p>
         * An "exists" operator to match for the filter used to create the rule.
         * </p>
         * 
         * @param exists
         *        An "exists" operator to match for the filter used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exists(Boolean exists);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private List<String> contains = DefaultSdkAutoConstructList.getInstance();

        private Boolean exists;

        private BuilderImpl() {
        }

        private BuilderImpl(Criterion model) {
            eq(model.eq);
            neq(model.neq);
            contains(model.contains);
            exists(model.exists);
        }

        public final Collection<String> getEq() {
            if (eq instanceof SdkAutoConstructList) {
                return null;
            }
            return eq;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ValueListCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final Collection<String> getNeq() {
            if (neq instanceof SdkAutoConstructList) {
                return null;
            }
            return neq;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ValueListCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        public final Collection<String> getContains() {
            if (contains instanceof SdkAutoConstructList) {
                return null;
            }
            return contains;
        }

        public final void setContains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
        }

        @Override
        public final Builder contains(Collection<String> contains) {
            this.contains = ValueListCopier.copy(contains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contains(String... contains) {
            contains(Arrays.asList(contains));
            return this;
        }

        public final Boolean getExists() {
            return exists;
        }

        public final void setExists(Boolean exists) {
            this.exists = exists;
        }

        @Override
        public final Builder exists(Boolean exists) {
            this.exists = exists;
            return this;
        }

        @Override
        public Criterion build() {
            return new Criterion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
