/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the generated policy details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedPolicyProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedPolicyProperties.Builder, GeneratedPolicyProperties> {
    private static final SdkField<Boolean> IS_COMPLETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isComplete").getter(getter(GeneratedPolicyProperties::isComplete)).setter(setter(Builder::isComplete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isComplete").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(GeneratedPolicyProperties::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final SdkField<CloudTrailProperties> CLOUD_TRAIL_PROPERTIES_FIELD = SdkField
            .<CloudTrailProperties> builder(MarshallingType.SDK_POJO).memberName("cloudTrailProperties")
            .getter(getter(GeneratedPolicyProperties::cloudTrailProperties)).setter(setter(Builder::cloudTrailProperties))
            .constructor(CloudTrailProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_COMPLETE_FIELD,
            PRINCIPAL_ARN_FIELD, CLOUD_TRAIL_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isComplete;

    private final String principalArn;

    private final CloudTrailProperties cloudTrailProperties;

    private GeneratedPolicyProperties(BuilderImpl builder) {
        this.isComplete = builder.isComplete;
        this.principalArn = builder.principalArn;
        this.cloudTrailProperties = builder.cloudTrailProperties;
    }

    /**
     * <p>
     * This value is set to <code>true</code> if the generated policy contains all possible actions for a service that
     * IAM Access Analyzer identified from the CloudTrail trail that you specified, and <code>false</code> otherwise.
     * </p>
     * 
     * @return This value is set to <code>true</code> if the generated policy contains all possible actions for a
     *         service that IAM Access Analyzer identified from the CloudTrail trail that you specified, and
     *         <code>false</code> otherwise.
     */
    public final Boolean isComplete() {
        return isComplete;
    }

    /**
     * <p>
     * The ARN of the IAM entity (user or role) for which you are generating a policy.
     * </p>
     * 
     * @return The ARN of the IAM entity (user or role) for which you are generating a policy.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * Lists details about the <code>Trail</code> used to generated policy.
     * </p>
     * 
     * @return Lists details about the <code>Trail</code> used to generated policy.
     */
    public final CloudTrailProperties cloudTrailProperties() {
        return cloudTrailProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isComplete());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudTrailProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedPolicyProperties)) {
            return false;
        }
        GeneratedPolicyProperties other = (GeneratedPolicyProperties) obj;
        return Objects.equals(isComplete(), other.isComplete()) && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(cloudTrailProperties(), other.cloudTrailProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedPolicyProperties").add("IsComplete", isComplete()).add("PrincipalArn", principalArn())
                .add("CloudTrailProperties", cloudTrailProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isComplete":
            return Optional.ofNullable(clazz.cast(isComplete()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "cloudTrailProperties":
            return Optional.ofNullable(clazz.cast(cloudTrailProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isComplete", IS_COMPLETE_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("cloudTrailProperties", CLOUD_TRAIL_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeneratedPolicyProperties, T> g) {
        return obj -> g.apply((GeneratedPolicyProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedPolicyProperties> {
        /**
         * <p>
         * This value is set to <code>true</code> if the generated policy contains all possible actions for a service
         * that IAM Access Analyzer identified from the CloudTrail trail that you specified, and <code>false</code>
         * otherwise.
         * </p>
         * 
         * @param isComplete
         *        This value is set to <code>true</code> if the generated policy contains all possible actions for a
         *        service that IAM Access Analyzer identified from the CloudTrail trail that you specified, and
         *        <code>false</code> otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isComplete(Boolean isComplete);

        /**
         * <p>
         * The ARN of the IAM entity (user or role) for which you are generating a policy.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the IAM entity (user or role) for which you are generating a policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * Lists details about the <code>Trail</code> used to generated policy.
         * </p>
         * 
         * @param cloudTrailProperties
         *        Lists details about the <code>Trail</code> used to generated policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudTrailProperties(CloudTrailProperties cloudTrailProperties);

        /**
         * <p>
         * Lists details about the <code>Trail</code> used to generated policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudTrailProperties.Builder} avoiding
         * the need to create one manually via {@link CloudTrailProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudTrailProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudTrailProperties(CloudTrailProperties)}.
         * 
         * @param cloudTrailProperties
         *        a consumer that will call methods on {@link CloudTrailProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudTrailProperties(CloudTrailProperties)
         */
        default Builder cloudTrailProperties(Consumer<CloudTrailProperties.Builder> cloudTrailProperties) {
            return cloudTrailProperties(CloudTrailProperties.builder().applyMutation(cloudTrailProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean isComplete;

        private String principalArn;

        private CloudTrailProperties cloudTrailProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedPolicyProperties model) {
            isComplete(model.isComplete);
            principalArn(model.principalArn);
            cloudTrailProperties(model.cloudTrailProperties);
        }

        public final Boolean getIsComplete() {
            return isComplete;
        }

        public final void setIsComplete(Boolean isComplete) {
            this.isComplete = isComplete;
        }

        @Override
        public final Builder isComplete(Boolean isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final CloudTrailProperties.Builder getCloudTrailProperties() {
            return cloudTrailProperties != null ? cloudTrailProperties.toBuilder() : null;
        }

        public final void setCloudTrailProperties(CloudTrailProperties.BuilderImpl cloudTrailProperties) {
            this.cloudTrailProperties = cloudTrailProperties != null ? cloudTrailProperties.build() : null;
        }

        @Override
        public final Builder cloudTrailProperties(CloudTrailProperties cloudTrailProperties) {
            this.cloudTrailProperties = cloudTrailProperties;
            return this;
        }

        @Override
        public GeneratedPolicyProperties build() {
            return new GeneratedPolicyProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
