/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAnalyzerResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<UpdateAnalyzerResponse.Builder, UpdateAnalyzerResponse> {
    private static final SdkField<AnalyzerConfiguration> CONFIGURATION_FIELD = SdkField
            .<AnalyzerConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateAnalyzerResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(AnalyzerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnalyzerConfiguration configuration;

    private UpdateAnalyzerResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * Returns the value of the Configuration property for this object.
     * 
     * @return The value of the Configuration property for this object.
     */
    public final AnalyzerConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnalyzerResponse)) {
            return false;
        }
        UpdateAnalyzerResponse other = (UpdateAnalyzerResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAnalyzerResponse").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnalyzerResponse, T> g) {
        return obj -> g.apply((UpdateAnalyzerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAnalyzerResponse> {
        /**
         * Sets the value of the Configuration property for this object.
         *
         * @param configuration
         *        The new value for the Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AnalyzerConfiguration configuration);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnalyzerConfiguration.Builder} avoiding
         * the need to create one manually via {@link AnalyzerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalyzerConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(AnalyzerConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AnalyzerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AnalyzerConfiguration)
         */
        default Builder configuration(Consumer<AnalyzerConfiguration.Builder> configuration) {
            return configuration(AnalyzerConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private AnalyzerConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnalyzerResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final AnalyzerConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnalyzerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnalyzerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public UpdateAnalyzerResponse build() {
            return new UpdateAnalyzerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
