/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the details of an alternate contact associated with an Amazon Web Services account
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlternateContact implements SdkPojo, Serializable,
        ToCopyableBuilder<AlternateContact.Builder, AlternateContact> {
    private static final SdkField<String> ALTERNATE_CONTACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlternateContactType").getter(getter(AlternateContact::alternateContactTypeAsString))
            .setter(setter(Builder::alternateContactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateContactType").build())
            .build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(AlternateContact::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AlternateContact::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(AlternateContact::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(AlternateContact::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_CONTACT_TYPE_FIELD,
            EMAIL_ADDRESS_FIELD, NAME_FIELD, PHONE_NUMBER_FIELD, TITLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alternateContactType;

    private final String emailAddress;

    private final String name;

    private final String phoneNumber;

    private final String title;

    private AlternateContact(BuilderImpl builder) {
        this.alternateContactType = builder.alternateContactType;
        this.emailAddress = builder.emailAddress;
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.title = builder.title;
    }

    /**
     * <p>
     * The type of alternate contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateContactType} will return {@link AlternateContactType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateContactTypeAsString}.
     * </p>
     * 
     * @return The type of alternate contact.
     * @see AlternateContactType
     */
    public final AlternateContactType alternateContactType() {
        return AlternateContactType.fromValue(alternateContactType);
    }

    /**
     * <p>
     * The type of alternate contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateContactType} will return {@link AlternateContactType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateContactTypeAsString}.
     * </p>
     * 
     * @return The type of alternate contact.
     * @see AlternateContactType
     */
    public final String alternateContactTypeAsString() {
        return alternateContactType;
    }

    /**
     * <p>
     * The email address associated with this alternate contact.
     * </p>
     * 
     * @return The email address associated with this alternate contact.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The name associated with this alternate contact.
     * </p>
     * 
     * @return The name associated with this alternate contact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The phone number associated with this alternate contact.
     * </p>
     * 
     * @return The phone number associated with this alternate contact.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The title associated with this alternate contact.
     * </p>
     * 
     * @return The title associated with this alternate contact.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alternateContactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlternateContact)) {
            return false;
        }
        AlternateContact other = (AlternateContact) obj;
        return Objects.equals(alternateContactTypeAsString(), other.alternateContactTypeAsString())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(name(), other.name())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlternateContact").add("AlternateContactType", alternateContactTypeAsString())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlternateContactType":
            return Optional.ofNullable(clazz.cast(alternateContactTypeAsString()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlternateContact, T> g) {
        return obj -> g.apply((AlternateContact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlternateContact> {
        /**
         * <p>
         * The type of alternate contact.
         * </p>
         * 
         * @param alternateContactType
         *        The type of alternate contact.
         * @see AlternateContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlternateContactType
         */
        Builder alternateContactType(String alternateContactType);

        /**
         * <p>
         * The type of alternate contact.
         * </p>
         * 
         * @param alternateContactType
         *        The type of alternate contact.
         * @see AlternateContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlternateContactType
         */
        Builder alternateContactType(AlternateContactType alternateContactType);

        /**
         * <p>
         * The email address associated with this alternate contact.
         * </p>
         * 
         * @param emailAddress
         *        The email address associated with this alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The name associated with this alternate contact.
         * </p>
         * 
         * @param name
         *        The name associated with this alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The phone number associated with this alternate contact.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number associated with this alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The title associated with this alternate contact.
         * </p>
         * 
         * @param title
         *        The title associated with this alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);
    }

    static final class BuilderImpl implements Builder {
        private String alternateContactType;

        private String emailAddress;

        private String name;

        private String phoneNumber;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(AlternateContact model) {
            alternateContactType(model.alternateContactType);
            emailAddress(model.emailAddress);
            name(model.name);
            phoneNumber(model.phoneNumber);
            title(model.title);
        }

        public final String getAlternateContactType() {
            return alternateContactType;
        }

        public final void setAlternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
        }

        @Override
        @Transient
        public final Builder alternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
            return this;
        }

        @Override
        @Transient
        public final Builder alternateContactType(AlternateContactType alternateContactType) {
            this.alternateContactType(alternateContactType == null ? null : alternateContactType.toString());
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        @Transient
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public AlternateContact build() {
            return new AlternateContact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
