/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAlternateContactRequest extends AccountRequest implements
        ToCopyableBuilder<PutAlternateContactRequest.Builder, PutAlternateContactRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(PutAlternateContactRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ALTERNATE_CONTACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlternateContactType").getter(getter(PutAlternateContactRequest::alternateContactTypeAsString))
            .setter(setter(Builder::alternateContactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateContactType").build())
            .build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(PutAlternateContactRequest::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutAlternateContactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(PutAlternateContactRequest::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(PutAlternateContactRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ALTERNATE_CONTACT_TYPE_FIELD, EMAIL_ADDRESS_FIELD, NAME_FIELD, PHONE_NUMBER_FIELD, TITLE_FIELD));

    private final String accountId;

    private final String alternateContactType;

    private final String emailAddress;

    private final String name;

    private final String phoneNumber;

    private final String title;

    private PutAlternateContactRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.alternateContactType = builder.alternateContactType;
        this.emailAddress = builder.emailAddress;
        this.name = builder.name;
        this.phoneNumber = builder.phoneNumber;
        this.title = builder.title;
    }

    /**
     * <p>
     * Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify
     * with this operation.
     * </p>
     * <p>
     * If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to call
     * the operation.
     * </p>
     * <p>
     * To use this parameter, the caller must be an identity in the <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     * >organization's management account</a> or a delegated administrator account, and the specified account ID must be
     * a member account in the same organization. The organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html">all
     * features enabled</a>, and the organization must have <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     * access</a> enabled for the Account Management service, and optionally a <a
     * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
     * admin</a> account assigned.
     * </p>
     * <note>
     * <p>
     * The management account can't specify its own <code>AccountId</code>; it must call the operation in standalone
     * context by not including the <code>AccountId</code> parameter.
     * </p>
     * </note>
     * <p>
     * To call this operation on an account that is not a member of an organization, then don't specify this parameter,
     * and call the operation using an identity belonging to the account whose contacts you wish to retrieve or modify.
     * </p>
     * 
     * @return Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or
     *         modify with this operation.</p>
     *         <p>
     *         If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used
     *         to call the operation.
     *         </p>
     *         <p>
     *         To use this parameter, the caller must be an identity in the <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
     *         >organization's management account</a> or a delegated administrator account, and the specified account ID
     *         must be a member account in the same organization. The organization must have <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
     *         >all features enabled</a>, and the organization must have <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
     *         access</a> enabled for the Account Management service, and optionally a <a
     *         href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
     *         >delegated admin</a> account assigned.
     *         </p>
     *         <note>
     *         <p>
     *         The management account can't specify its own <code>AccountId</code>; it must call the operation in
     *         standalone context by not including the <code>AccountId</code> parameter.
     *         </p>
     *         </note>
     *         <p>
     *         To call this operation on an account that is not a member of an organization, then don't specify this
     *         parameter, and call the operation using an identity belonging to the account whose contacts you wish to
     *         retrieve or modify.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Specifies which alternate contact you want to create or update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateContactType} will return {@link AlternateContactType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateContactTypeAsString}.
     * </p>
     * 
     * @return Specifies which alternate contact you want to create or update.
     * @see AlternateContactType
     */
    public final AlternateContactType alternateContactType() {
        return AlternateContactType.fromValue(alternateContactType);
    }

    /**
     * <p>
     * Specifies which alternate contact you want to create or update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternateContactType} will return {@link AlternateContactType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #alternateContactTypeAsString}.
     * </p>
     * 
     * @return Specifies which alternate contact you want to create or update.
     * @see AlternateContactType
     */
    public final String alternateContactTypeAsString() {
        return alternateContactType;
    }

    /**
     * <p>
     * Specifies an email address for the alternate contact.
     * </p>
     * 
     * @return Specifies an email address for the alternate contact.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * Specifies a name for the alternate contact.
     * </p>
     * 
     * @return Specifies a name for the alternate contact.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies a phone number for the alternate contact.
     * </p>
     * 
     * @return Specifies a phone number for the alternate contact.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * Specifies a title for the alternate contact.
     * </p>
     * 
     * @return Specifies a title for the alternate contact.
     */
    public final String title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(alternateContactTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAlternateContactRequest)) {
            return false;
        }
        PutAlternateContactRequest other = (PutAlternateContactRequest) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(alternateContactTypeAsString(), other.alternateContactTypeAsString())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(name(), other.name())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAlternateContactRequest").add("AccountId", accountId())
                .add("AlternateContactType", alternateContactTypeAsString())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AlternateContactType":
            return Optional.ofNullable(clazz.cast(alternateContactTypeAsString()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAlternateContactRequest, T> g) {
        return obj -> g.apply((PutAlternateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccountRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAlternateContactRequest> {
        /**
         * <p>
         * Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or modify
         * with this operation.
         * </p>
         * <p>
         * If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity used to
         * call the operation.
         * </p>
         * <p>
         * To use this parameter, the caller must be an identity in the <a href=
         * "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         * >organization's management account</a> or a delegated administrator account, and the specified account ID
         * must be a member account in the same organization. The organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         * >all features enabled</a>, and the organization must have <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html">trusted
         * access</a> enabled for the Account Management service, and optionally a <a
         * href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html">delegated
         * admin</a> account assigned.
         * </p>
         * <note>
         * <p>
         * The management account can't specify its own <code>AccountId</code>; it must call the operation in standalone
         * context by not including the <code>AccountId</code> parameter.
         * </p>
         * </note>
         * <p>
         * To call this operation on an account that is not a member of an organization, then don't specify this
         * parameter, and call the operation using an identity belonging to the account whose contacts you wish to
         * retrieve or modify.
         * </p>
         * 
         * @param accountId
         *        Specifies the 12 digit account ID number of the Amazon Web Services account that you want to access or
         *        modify with this operation.</p>
         *        <p>
         *        If you do not specify this parameter, it defaults to the Amazon Web Services account of the identity
         *        used to call the operation.
         *        </p>
         *        <p>
         *        To use this parameter, the caller must be an identity in the <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account"
         *        >organization's management account</a> or a delegated administrator account, and the specified account
         *        ID must be a member account in the same organization. The organization must have <a href=
         *        "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html"
         *        >all features enabled</a>, and the organization must have <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-trusted-access.html"
         *        >trusted access</a> enabled for the Account Management service, and optionally a <a
         *        href="https://docs.aws.amazon.com/organizations/latest/userguide/using-orgs-delegated-admin.html"
         *        >delegated admin</a> account assigned.
         *        </p>
         *        <note>
         *        <p>
         *        The management account can't specify its own <code>AccountId</code>; it must call the operation in
         *        standalone context by not including the <code>AccountId</code> parameter.
         *        </p>
         *        </note>
         *        <p>
         *        To call this operation on an account that is not a member of an organization, then don't specify this
         *        parameter, and call the operation using an identity belonging to the account whose contacts you wish
         *        to retrieve or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Specifies which alternate contact you want to create or update.
         * </p>
         * 
         * @param alternateContactType
         *        Specifies which alternate contact you want to create or update.
         * @see AlternateContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlternateContactType
         */
        Builder alternateContactType(String alternateContactType);

        /**
         * <p>
         * Specifies which alternate contact you want to create or update.
         * </p>
         * 
         * @param alternateContactType
         *        Specifies which alternate contact you want to create or update.
         * @see AlternateContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlternateContactType
         */
        Builder alternateContactType(AlternateContactType alternateContactType);

        /**
         * <p>
         * Specifies an email address for the alternate contact.
         * </p>
         * 
         * @param emailAddress
         *        Specifies an email address for the alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * Specifies a name for the alternate contact.
         * </p>
         * 
         * @param name
         *        Specifies a name for the alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies a phone number for the alternate contact.
         * </p>
         * 
         * @param phoneNumber
         *        Specifies a phone number for the alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * Specifies a title for the alternate contact.
         * </p>
         * 
         * @param title
         *        Specifies a title for the alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccountRequest.BuilderImpl implements Builder {
        private String accountId;

        private String alternateContactType;

        private String emailAddress;

        private String name;

        private String phoneNumber;

        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAlternateContactRequest model) {
            super(model);
            accountId(model.accountId);
            alternateContactType(model.alternateContactType);
            emailAddress(model.emailAddress);
            name(model.name);
            phoneNumber(model.phoneNumber);
            title(model.title);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAlternateContactType() {
            return alternateContactType;
        }

        public final void setAlternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
        }

        @Override
        @Transient
        public final Builder alternateContactType(String alternateContactType) {
            this.alternateContactType = alternateContactType;
            return this;
        }

        @Override
        @Transient
        public final Builder alternateContactType(AlternateContactType alternateContactType) {
            this.alternateContactType(alternateContactType == null ? null : alternateContactType.toString());
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        @Transient
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        @Transient
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAlternateContactRequest build() {
            return new PutAlternateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
