/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactRequest;
import software.amazon.awssdk.services.account.model.DeleteAlternateContactResponse;
import software.amazon.awssdk.services.account.model.GetAlternateContactRequest;
import software.amazon.awssdk.services.account.model.GetAlternateContactResponse;
import software.amazon.awssdk.services.account.model.PutAlternateContactRequest;
import software.amazon.awssdk.services.account.model.PutAlternateContactResponse;

/**
 * Service client for accessing AWS Account asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Operations for Amazon Web Services Account Management
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AccountAsyncClient extends SdkClient {
    String SERVICE_NAME = "account";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "account";

    /**
     * Create a {@link AccountAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AccountAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AccountAsyncClient}.
     */
    static AccountAsyncClientBuilder builder() {
        return new DefaultAccountAsyncClientBuilder();
    }

    /**
     * <p>
     * Deletes the specified alternate contact from an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     *
     * @param deleteAlternateContactRequest
     * @return A Java Future containing the result of the DeleteAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DeleteAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DeleteAlternateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlternateContactResponse> deleteAlternateContact(
            DeleteAlternateContactRequest deleteAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified alternate contact from an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAlternateContactRequest#builder()}
     * </p>
     *
     * @param deleteAlternateContactRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.DeleteAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/DeleteAlternateContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAlternateContactResponse> deleteAlternateContact(
            Consumer<DeleteAlternateContactRequest.Builder> deleteAlternateContactRequest) {
        return deleteAlternateContact(DeleteAlternateContactRequest.builder().applyMutation(deleteAlternateContactRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     *
     * @param getAlternateContactRequest
     * @return A Java Future containing the result of the GetAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAlternateContactResponse> getAlternateContact(
            GetAlternateContactRequest getAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link GetAlternateContactRequest#builder()}
     * </p>
     *
     * @param getAlternateContactRequest
     *        A {@link Consumer} that will call methods on {@link GetAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation failed because it specified a resource that can't be found.</li>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.GetAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/GetAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAlternateContactResponse> getAlternateContact(
            Consumer<GetAlternateContactRequest.Builder> getAlternateContactRequest) {
        return getAlternateContact(GetAlternateContactRequest.builder().applyMutation(getAlternateContactRequest).build());
    }

    /**
     * <p>
     * Modifies the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     *
     * @param putAlternateContactRequest
     * @return A Java Future containing the result of the PutAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlternateContactResponse> putAlternateContact(
            PutAlternateContactRequest putAlternateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified alternate contact attached to an Amazon Web Services account.
     * </p>
     * <p>
     * For complete details about how to use the alternate contact operations, see <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-update-contact.html">Access or updating
     * the alternate contacts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAlternateContactRequest.Builder} avoiding the
     * need to create one manually via {@link PutAlternateContactRequest#builder()}
     * </p>
     *
     * @param putAlternateContactRequest
     *        A {@link Consumer} that will call methods on {@link PutAlternateContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAlternateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The operation failed because one of the input parameters was invalid.</li>
     *         <li>AccessDeniedException The operation failed because the calling identity doesn't have the minimum
     *         required permissions.</li>
     *         <li>TooManyRequestsException The operation failed because it was called too frequently and exceeded a
     *         throttle limit.</li>
     *         <li>InternalServerException The operation failed because of an error internal to Amazon Web Services. Try
     *         your operation again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AccountException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AccountAsyncClient.PutAlternateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/account-2021-02-01/PutAlternateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutAlternateContactResponse> putAlternateContact(
            Consumer<PutAlternateContactRequest.Builder> putAlternateContactRequest) {
        return putAlternateContact(PutAlternateContactRequest.builder().applyMutation(putAlternateContactRequest).build());
    }
}
