/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointParams;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointProvider;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultAccountEndpointProvider implements AccountEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(AccountEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        } catch (Exception error) {
            return CompletableFutureUtils.failedFuture(error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(AccountEndpointParams params) {
        Map<Identifier, Value> paramsMap = new HashMap<>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build())
                .error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_3(), endpointRule_4()));
    }

    private static Rule endpointRule_0() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_1(), endpointRule_2()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_10() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_11()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_9() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_10(), endpointRule_12()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.amazonaws.com")).build());
    }

    private static Rule endpointRule_14() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build()).treeRule(Arrays.asList(endpointRule_15()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_13() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_14(), endpointRule_16()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://account.{Region}.api.aws")).build());
    }

    private static Rule endpointRule_18() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_19()));
    }

    private static Rule endpointRule_20() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_17() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_18(), endpointRule_20()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(
                EndpointResult
                        .builder()
                        .url(Expr.of("https://account.us-east-1.amazonaws.com"))
                        .addProperty(
                                Identifier.of("authSchemes"),
                                Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                        Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("account"),
                                        Identifier.of("signingRegion"), Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("stringEquals")
                                        .argv(Arrays.asList(
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("name"))).build().validate(), Expr.of("aws"))).build()
                                        .validate()).build())
                .treeRule(Arrays.asList(endpointRule_9(), endpointRule_13(), endpointRule_17(), endpointRule_21()));
    }

    private static Rule endpointRule_25() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_24() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_25()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_23() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_24(), endpointRule_26()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.amazonaws.com.cn")).build());
    }

    private static Rule endpointRule_28() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build()).treeRule(Arrays.asList(endpointRule_29()));
    }

    private static Rule endpointRule_30() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_27() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_28(), endpointRule_30()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account.{Region}.api.amazonwebservices.com.cn")).build());
    }

    private static Rule endpointRule_32() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_33()));
    }

    private static Rule endpointRule_34() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_31() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_32(), endpointRule_34()));
    }

    private static Rule endpointRule_35() {
        return Rule.builder().endpoint(
                EndpointResult
                        .builder()
                        .url(Expr.of("https://account.cn-northwest-1.amazonaws.com.cn"))
                        .addProperty(
                                Identifier.of("authSchemes"),
                                Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                        Literal.fromStr("sigv4"), Identifier.of("signingName"), Literal.fromStr("account"),
                                        Identifier.of("signingRegion"), Literal.fromStr("cn-northwest-1")))))).build());
    }

    private static Rule endpointRule_22() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("stringEquals")
                                        .argv(Arrays.asList(
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build()
                                        .validate()).build())
                .treeRule(Arrays.asList(endpointRule_23(), endpointRule_27(), endpointRule_31(), endpointRule_35()));
    }

    private static Rule endpointRule_39() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.{PartitionResult#dualStackDnsSuffix}"))
                        .build());
    }

    private static Rule endpointRule_38() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_39()));
    }

    private static Rule endpointRule_37() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_38()));
    }

    private static Rule endpointRule_40() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_36() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build())
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_37(), endpointRule_40()));
    }

    private static Rule endpointRule_44() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_43() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_44()));
    }

    private static Rule endpointRule_42() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsFIPS"))).build().validate())).build().validate())
                                .build()).treeRule(Arrays.asList(endpointRule_43()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_41() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_42(), endpointRule_45()));
    }

    private static Rule endpointRule_49() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_48() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_49()));
    }

    private static Rule endpointRule_47() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode
                                        .builder()
                                        .fn("booleanEquals")
                                        .argv(Arrays.asList(
                                                Expr.of(true),
                                                FnNode.builder()
                                                        .fn("getAttr")
                                                        .argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")),
                                                                Expr.of("supportsDualStack"))).build().validate())).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_48()));
    }

    private static Rule endpointRule_50() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_46() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("booleanEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_47(), endpointRule_50()));
    }

    private static Rule endpointRule_52() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://account.us-east-1.amazonaws.com"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"),
                                                Literal.fromStr("account"), Identifier.of("signingRegion"),
                                                Literal.fromStr("us-east-1")))))).build());
    }

    private static Rule endpointRule_53() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("stringEquals")
                                        .argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-cn-global"))).build()
                                        .validate()).build())
                .endpoint(
                        EndpointResult
                                .builder()
                                .url(Expr.of("https://account.cn-northwest-1.amazonaws.com.cn"))
                                .addProperty(
                                        Identifier.of("authSchemes"),
                                        Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of(Identifier.of("name"),
                                                Literal.fromStr("sigv4"), Identifier.of("signingName"),
                                                Literal.fromStr("account"), Identifier.of("signingRegion"),
                                                Literal.fromStr("cn-northwest-1")))))).build());
    }

    private static Rule endpointRule_54() {
        return Rule.builder().endpoint(
                EndpointResult.builder().url(Expr.of("https://account.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_51() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_52(), endpointRule_53(), endpointRule_54()));
    }

    private static Rule endpointRule_7() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region"))))
                                        .build().validate()).result("PartitionResult").build())
                .treeRule(
                        Arrays.asList(endpointRule_8(), endpointRule_22(), endpointRule_36(), endpointRule_41(),
                                endpointRule_46(), endpointRule_51()));
    }

    private static Rule endpointRule_6() {
        return Rule
                .builder()
                .addCondition(
                        Condition
                                .builder()
                                .fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build()
                                        .validate()).build()).treeRule(Arrays.asList(endpointRule_7()));
    }

    private static Rule endpointRule_55() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(endpointRule_6(), endpointRule_55()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset
                .builder()
                .version("1.0")
                .serviceId(null)
                .parameters(
                        Parameters
                                .builder()
                                .addParameter(
                                        Parameter.builder().name("Region").type(ParameterType.fromValue("String"))
                                                .required(false).builtIn("AWS::Region")
                                                .documentation("The AWS region used to dispatch the request.").build())
                                .addParameter(
                                        Parameter
                                                .builder()
                                                .name("UseDualStack")
                                                .type(ParameterType.fromValue("Boolean"))
                                                .required(true)
                                                .builtIn("AWS::UseDualStack")
                                                .documentation(
                                                        "When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.")
                                                .defaultValue(Value.fromBool(false)).build())
                                .addParameter(
                                        Parameter
                                                .builder()
                                                .name("UseFIPS")
                                                .type(ParameterType.fromValue("Boolean"))
                                                .required(true)
                                                .builtIn("AWS::UseFIPS")
                                                .documentation(
                                                        "When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.")
                                                .defaultValue(Value.fromBool(false)).build())
                                .addParameter(
                                        Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String"))
                                                .required(false).builtIn("SDK::Endpoint")
                                                .documentation("Override the endpoint used to send this request").build())
                                .build()).addRule(endpointRule_0()).addRule(endpointRule_5()).build();
    }
}
