/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAlternateContactResponse extends AccountResponse implements
        ToCopyableBuilder<GetAlternateContactResponse.Builder, GetAlternateContactResponse> {
    private static final SdkField<AlternateContact> ALTERNATE_CONTACT_FIELD = SdkField
            .<AlternateContact> builder(MarshallingType.SDK_POJO).memberName("AlternateContact")
            .getter(getter(GetAlternateContactResponse::alternateContact)).setter(setter(Builder::alternateContact))
            .constructor(AlternateContact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateContact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_CONTACT_FIELD));

    private final AlternateContact alternateContact;

    private GetAlternateContactResponse(BuilderImpl builder) {
        super(builder);
        this.alternateContact = builder.alternateContact;
    }

    /**
     * <p>
     * A structure that contains the details for the specified alternate contact.
     * </p>
     * 
     * @return A structure that contains the details for the specified alternate contact.
     */
    public final AlternateContact alternateContact() {
        return alternateContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alternateContact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAlternateContactResponse)) {
            return false;
        }
        GetAlternateContactResponse other = (GetAlternateContactResponse) obj;
        return Objects.equals(alternateContact(), other.alternateContact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAlternateContactResponse").add("AlternateContact", alternateContact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlternateContact":
            return Optional.ofNullable(clazz.cast(alternateContact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAlternateContactResponse, T> g) {
        return obj -> g.apply((GetAlternateContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccountResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAlternateContactResponse> {
        /**
         * <p>
         * A structure that contains the details for the specified alternate contact.
         * </p>
         * 
         * @param alternateContact
         *        A structure that contains the details for the specified alternate contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateContact(AlternateContact alternateContact);

        /**
         * <p>
         * A structure that contains the details for the specified alternate contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlternateContact.Builder} avoiding the
         * need to create one manually via {@link AlternateContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlternateContact.Builder#build()} is called immediately and its
         * result is passed to {@link #alternateContact(AlternateContact)}.
         * 
         * @param alternateContact
         *        a consumer that will call methods on {@link AlternateContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateContact(AlternateContact)
         */
        default Builder alternateContact(Consumer<AlternateContact.Builder> alternateContact) {
            return alternateContact(AlternateContact.builder().applyMutation(alternateContact).build());
        }
    }

    static final class BuilderImpl extends AccountResponse.BuilderImpl implements Builder {
        private AlternateContact alternateContact;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAlternateContactResponse model) {
            super(model);
            alternateContact(model.alternateContact);
        }

        public final AlternateContact.Builder getAlternateContact() {
            return alternateContact != null ? alternateContact.toBuilder() : null;
        }

        public final void setAlternateContact(AlternateContact.BuilderImpl alternateContact) {
            this.alternateContact = alternateContact != null ? alternateContact.build() : null;
        }

        @Override
        public final Builder alternateContact(AlternateContact alternateContact) {
            this.alternateContact = alternateContact;
            return this;
        }

        @Override
        public GetAlternateContactResponse build() {
            return new GetAlternateContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
