/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of the primary contact information associated with an Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactInformation.Builder, ContactInformation> {
    private static final SdkField<String> ADDRESS_LINE1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine1").getter(getter(ContactInformation::addressLine1)).setter(setter(Builder::addressLine1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine1").build()).build();

    private static final SdkField<String> ADDRESS_LINE2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine2").getter(getter(ContactInformation::addressLine2)).setter(setter(Builder::addressLine2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine2").build()).build();

    private static final SdkField<String> ADDRESS_LINE3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AddressLine3").getter(getter(ContactInformation::addressLine3)).setter(setter(Builder::addressLine3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressLine3").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(ContactInformation::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(ContactInformation::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(ContactInformation::countryCode)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> DISTRICT_OR_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DistrictOrCounty").getter(getter(ContactInformation::districtOrCounty))
            .setter(setter(Builder::districtOrCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistrictOrCounty").build()).build();

    private static final SdkField<String> FULL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FullName").getter(getter(ContactInformation::fullName)).setter(setter(Builder::fullName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullName").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(ContactInformation::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(ContactInformation::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrRegion").getter(getter(ContactInformation::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteUrl").getter(getter(ContactInformation::websiteUrl)).setter(setter(Builder::websiteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_LINE1_FIELD,
            ADDRESS_LINE2_FIELD, ADDRESS_LINE3_FIELD, CITY_FIELD, COMPANY_NAME_FIELD, COUNTRY_CODE_FIELD,
            DISTRICT_OR_COUNTY_FIELD, FULL_NAME_FIELD, PHONE_NUMBER_FIELD, POSTAL_CODE_FIELD, STATE_OR_REGION_FIELD,
            WEBSITE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String addressLine1;

    private final String addressLine2;

    private final String addressLine3;

    private final String city;

    private final String companyName;

    private final String countryCode;

    private final String districtOrCounty;

    private final String fullName;

    private final String phoneNumber;

    private final String postalCode;

    private final String stateOrRegion;

    private final String websiteUrl;

    private ContactInformation(BuilderImpl builder) {
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.addressLine3 = builder.addressLine3;
        this.city = builder.city;
        this.companyName = builder.companyName;
        this.countryCode = builder.countryCode;
        this.districtOrCounty = builder.districtOrCounty;
        this.fullName = builder.fullName;
        this.phoneNumber = builder.phoneNumber;
        this.postalCode = builder.postalCode;
        this.stateOrRegion = builder.stateOrRegion;
        this.websiteUrl = builder.websiteUrl;
    }

    /**
     * <p>
     * The first line of the primary contact address.
     * </p>
     * 
     * @return The first line of the primary contact address.
     */
    public final String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * The second line of the primary contact address, if any.
     * </p>
     * 
     * @return The second line of the primary contact address, if any.
     */
    public final String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The third line of the primary contact address, if any.
     * </p>
     * 
     * @return The third line of the primary contact address, if any.
     */
    public final String addressLine3() {
        return addressLine3;
    }

    /**
     * <p>
     * The city of the primary contact address.
     * </p>
     * 
     * @return The city of the primary contact address.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The name of the company associated with the primary contact information, if any.
     * </p>
     * 
     * @return The name of the company associated with the primary contact information, if any.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * The ISO-3166 two-letter country code for the primary contact address.
     * </p>
     * 
     * @return The ISO-3166 two-letter country code for the primary contact address.
     */
    public final String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The district or county of the primary contact address, if any.
     * </p>
     * 
     * @return The district or county of the primary contact address, if any.
     */
    public final String districtOrCounty() {
        return districtOrCounty;
    }

    /**
     * <p>
     * The full name of the primary contact address.
     * </p>
     * 
     * @return The full name of the primary contact address.
     */
    public final String fullName() {
        return fullName;
    }

    /**
     * <p>
     * The phone number of the primary contact information. The number will be validated and, in some countries, checked
     * for activation.
     * </p>
     * 
     * @return The phone number of the primary contact information. The number will be validated and, in some countries,
     *         checked for activation.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The postal code of the primary contact address.
     * </p>
     * 
     * @return The postal code of the primary contact address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The state or region of the primary contact address. This field is required in selected countries.
     * </p>
     * 
     * @return The state or region of the primary contact address. This field is required in selected countries.
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    /**
     * <p>
     * The URL of the website associated with the primary contact information, if any.
     * </p>
     * 
     * @return The URL of the website associated with the primary contact information, if any.
     */
    public final String websiteUrl() {
        return websiteUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(addressLine1());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine2());
        hashCode = 31 * hashCode + Objects.hashCode(addressLine3());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(districtOrCounty());
        hashCode = 31 * hashCode + Objects.hashCode(fullName());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(websiteUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactInformation)) {
            return false;
        }
        ContactInformation other = (ContactInformation) obj;
        return Objects.equals(addressLine1(), other.addressLine1()) && Objects.equals(addressLine2(), other.addressLine2())
                && Objects.equals(addressLine3(), other.addressLine3()) && Objects.equals(city(), other.city())
                && Objects.equals(companyName(), other.companyName()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(districtOrCounty(), other.districtOrCounty()) && Objects.equals(fullName(), other.fullName())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(stateOrRegion(), other.stateOrRegion()) && Objects.equals(websiteUrl(), other.websiteUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactInformation")
                .add("AddressLine1", addressLine1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AddressLine2", addressLine2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AddressLine3", addressLine3() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CompanyName", companyName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CountryCode", countryCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DistrictOrCounty", districtOrCounty() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FullName", fullName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateOrRegion", stateOrRegion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebsiteUrl", websiteUrl() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AddressLine1":
            return Optional.ofNullable(clazz.cast(addressLine1()));
        case "AddressLine2":
            return Optional.ofNullable(clazz.cast(addressLine2()));
        case "AddressLine3":
            return Optional.ofNullable(clazz.cast(addressLine3()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "DistrictOrCounty":
            return Optional.ofNullable(clazz.cast(districtOrCounty()));
        case "FullName":
            return Optional.ofNullable(clazz.cast(fullName()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "StateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        case "WebsiteUrl":
            return Optional.ofNullable(clazz.cast(websiteUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactInformation, T> g) {
        return obj -> g.apply((ContactInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactInformation> {
        /**
         * <p>
         * The first line of the primary contact address.
         * </p>
         * 
         * @param addressLine1
         *        The first line of the primary contact address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * The second line of the primary contact address, if any.
         * </p>
         * 
         * @param addressLine2
         *        The second line of the primary contact address, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The third line of the primary contact address, if any.
         * </p>
         * 
         * @param addressLine3
         *        The third line of the primary contact address, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine3(String addressLine3);

        /**
         * <p>
         * The city of the primary contact address.
         * </p>
         * 
         * @param city
         *        The city of the primary contact address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The name of the company associated with the primary contact information, if any.
         * </p>
         * 
         * @param companyName
         *        The name of the company associated with the primary contact information, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * The ISO-3166 two-letter country code for the primary contact address.
         * </p>
         * 
         * @param countryCode
         *        The ISO-3166 two-letter country code for the primary contact address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The district or county of the primary contact address, if any.
         * </p>
         * 
         * @param districtOrCounty
         *        The district or county of the primary contact address, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder districtOrCounty(String districtOrCounty);

        /**
         * <p>
         * The full name of the primary contact address.
         * </p>
         * 
         * @param fullName
         *        The full name of the primary contact address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullName(String fullName);

        /**
         * <p>
         * The phone number of the primary contact information. The number will be validated and, in some countries,
         * checked for activation.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the primary contact information. The number will be validated and, in some
         *        countries, checked for activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The postal code of the primary contact address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of the primary contact address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The state or region of the primary contact address. This field is required in selected countries.
         * </p>
         * 
         * @param stateOrRegion
         *        The state or region of the primary contact address. This field is required in selected countries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);

        /**
         * <p>
         * The URL of the website associated with the primary contact information, if any.
         * </p>
         * 
         * @param websiteUrl
         *        The URL of the website associated with the primary contact information, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteUrl(String websiteUrl);
    }

    static final class BuilderImpl implements Builder {
        private String addressLine1;

        private String addressLine2;

        private String addressLine3;

        private String city;

        private String companyName;

        private String countryCode;

        private String districtOrCounty;

        private String fullName;

        private String phoneNumber;

        private String postalCode;

        private String stateOrRegion;

        private String websiteUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactInformation model) {
            addressLine1(model.addressLine1);
            addressLine2(model.addressLine2);
            addressLine3(model.addressLine3);
            city(model.city);
            companyName(model.companyName);
            countryCode(model.countryCode);
            districtOrCounty(model.districtOrCounty);
            fullName(model.fullName);
            phoneNumber(model.phoneNumber);
            postalCode(model.postalCode);
            stateOrRegion(model.stateOrRegion);
            websiteUrl(model.websiteUrl);
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final String getAddressLine3() {
            return addressLine3;
        }

        public final void setAddressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
        }

        @Override
        public final Builder addressLine3(String addressLine3) {
            this.addressLine3 = addressLine3;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getDistrictOrCounty() {
            return districtOrCounty;
        }

        public final void setDistrictOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
        }

        @Override
        public final Builder districtOrCounty(String districtOrCounty) {
            this.districtOrCounty = districtOrCounty;
            return this;
        }

        public final String getFullName() {
            return fullName;
        }

        public final void setFullName(String fullName) {
            this.fullName = fullName;
        }

        @Override
        public final Builder fullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public final String getWebsiteUrl() {
            return websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        @Override
        public ContactInformation build() {
            return new ContactInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
