/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.account.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPrimaryEmailResponse extends AccountResponse implements
        ToCopyableBuilder<GetPrimaryEmailResponse.Builder, GetPrimaryEmailResponse> {
    private static final SdkField<String> PRIMARY_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryEmail").getter(getter(GetPrimaryEmailResponse::primaryEmail))
            .setter(setter(Builder::primaryEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_EMAIL_FIELD));

    private final String primaryEmail;

    private GetPrimaryEmailResponse(BuilderImpl builder) {
        super(builder);
        this.primaryEmail = builder.primaryEmail;
    }

    /**
     * <p>
     * Retrieves the primary email address associated with the specified account.
     * </p>
     * 
     * @return Retrieves the primary email address associated with the specified account.
     */
    public final String primaryEmail() {
        return primaryEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(primaryEmail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPrimaryEmailResponse)) {
            return false;
        }
        GetPrimaryEmailResponse other = (GetPrimaryEmailResponse) obj;
        return Objects.equals(primaryEmail(), other.primaryEmail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPrimaryEmailResponse")
                .add("PrimaryEmail", primaryEmail() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryEmail":
            return Optional.ofNullable(clazz.cast(primaryEmail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPrimaryEmailResponse, T> g) {
        return obj -> g.apply((GetPrimaryEmailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccountResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPrimaryEmailResponse> {
        /**
         * <p>
         * Retrieves the primary email address associated with the specified account.
         * </p>
         * 
         * @param primaryEmail
         *        Retrieves the primary email address associated with the specified account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryEmail(String primaryEmail);
    }

    static final class BuilderImpl extends AccountResponse.BuilderImpl implements Builder {
        private String primaryEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPrimaryEmailResponse model) {
            super(model);
            primaryEmail(model.primaryEmail);
        }

        public final String getPrimaryEmail() {
            return primaryEmail;
        }

        public final void setPrimaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
        }

        @Override
        public final Builder primaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        @Override
        public GetPrimaryEmailResponse build() {
            return new GetPrimaryEmailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
