/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.account.model.AccountResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountInformationResponse
extends AccountResponse
implements ToCopyableBuilder<Builder, GetAccountInformationResponse> {
    private static final SdkField<Instant> ACCOUNT_CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AccountCreatedDate").getter(GetAccountInformationResponse.getter(GetAccountInformationResponse::accountCreatedDate)).setter(GetAccountInformationResponse.setter(Builder::accountCreatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(GetAccountInformationResponse.getter(GetAccountInformationResponse::accountId)).setter(GetAccountInformationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(GetAccountInformationResponse.getter(GetAccountInformationResponse::accountName)).setter(GetAccountInformationResponse.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_CREATED_DATE_FIELD, ACCOUNT_ID_FIELD, ACCOUNT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccountInformationResponse.memberNameToFieldInitializer();
    private final Instant accountCreatedDate;
    private final String accountId;
    private final String accountName;

    private GetAccountInformationResponse(BuilderImpl builder) {
        super(builder);
        this.accountCreatedDate = builder.accountCreatedDate;
        this.accountId = builder.accountId;
        this.accountName = builder.accountName;
    }

    public final Instant accountCreatedDate() {
        return this.accountCreatedDate;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String accountName() {
        return this.accountName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountCreatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountInformationResponse)) {
            return false;
        }
        GetAccountInformationResponse other = (GetAccountInformationResponse)((Object)obj);
        return Objects.equals(this.accountCreatedDate(), other.accountCreatedDate()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accountName(), other.accountName());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountInformationResponse").add("AccountCreatedDate", (Object)this.accountCreatedDate()).add("AccountId", (Object)this.accountId()).add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountCreatedDate": {
                return Optional.ofNullable(clazz.cast(this.accountCreatedDate()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountCreatedDate", ACCOUNT_CREATED_DATE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccountInformationResponse, T> g) {
        return obj -> g.apply((GetAccountInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccountResponse.BuilderImpl
    implements Builder {
        private Instant accountCreatedDate;
        private String accountId;
        private String accountName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountInformationResponse model) {
            super(model);
            this.accountCreatedDate(model.accountCreatedDate);
            this.accountId(model.accountId);
            this.accountName(model.accountName);
        }

        public final Instant getAccountCreatedDate() {
            return this.accountCreatedDate;
        }

        public final void setAccountCreatedDate(Instant accountCreatedDate) {
            this.accountCreatedDate = accountCreatedDate;
        }

        @Override
        public final Builder accountCreatedDate(Instant accountCreatedDate) {
            this.accountCreatedDate = accountCreatedDate;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Override
        public GetAccountInformationResponse build() {
            return new GetAccountInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccountResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountInformationResponse> {
        public Builder accountCreatedDate(Instant var1);

        public Builder accountId(String var1);

        public Builder accountName(String var1);
    }
}

