/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportCertificateRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, ExportCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(ExportCertificateRequest.getter(ExportCertificateRequest::certificateArn)).setter(ExportCertificateRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<SdkBytes> PASSPHRASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Passphrase").getter(ExportCertificateRequest.getter(ExportCertificateRequest::passphrase)).setter(ExportCertificateRequest.setter(Builder::passphrase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passphrase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, PASSPHRASE_FIELD));
    private final String certificateArn;
    private final SdkBytes passphrase;

    private ExportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.passphrase = builder.passphrase;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final SdkBytes passphrase() {
        return this.passphrase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.passphrase());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportCertificateRequest)) {
            return false;
        }
        ExportCertificateRequest other = (ExportCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.passphrase(), other.passphrase());
    }

    public final String toString() {
        return ToString.builder((String)"ExportCertificateRequest").add("CertificateArn", (Object)this.certificateArn()).add("Passphrase", (Object)(this.passphrase() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Passphrase": {
                return Optional.ofNullable(clazz.cast(this.passphrase()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportCertificateRequest, T> g) {
        return obj -> g.apply((ExportCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String certificateArn;
        private SdkBytes passphrase;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportCertificateRequest model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.passphrase(model.passphrase);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getPassphrase() {
            return this.passphrase == null ? null : this.passphrase.asByteBuffer();
        }

        @Override
        public final Builder passphrase(SdkBytes passphrase) {
            this.passphrase = StandardMemberCopier.copy((SdkBytes)passphrase);
            return this;
        }

        public final void setPassphrase(ByteBuffer passphrase) {
            this.passphrase(passphrase == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)passphrase));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportCertificateRequest build() {
            return new ExportCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportCertificateRequest> {
        public Builder certificateArn(String var1);

        public Builder passphrase(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

