/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyAlgorithm {
    RSA_1024("RSA_1024"),
    RSA_2048("RSA_2048"),
    RSA_3072("RSA_3072"),
    RSA_4096("RSA_4096"),
    EC_PRIME256_V1("EC_prime256v1"),
    EC_SECP384_R1("EC_secp384r1"),
    EC_SECP521_R1("EC_secp521r1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyAlgorithm> VALUE_MAP;
    private final String value;

    private KeyAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyAlgorithm> knownValues() {
        EnumSet<KeyAlgorithm> knownValues = EnumSet.allOf(KeyAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyAlgorithm.class, KeyAlgorithm::toString);
    }
}

