/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.acm.AcmClient;
import software.amazon.awssdk.services.acm.AcmClientBuilder;
import software.amazon.awssdk.services.acm.AcmServiceClientConfiguration;
import software.amazon.awssdk.services.acm.DefaultAcmBaseClientBuilder;
import software.amazon.awssdk.services.acm.DefaultAcmClient;
import software.amazon.awssdk.services.acm.endpoints.AcmEndpointProvider;

@SdkInternalApi
final class DefaultAcmClientBuilder
extends DefaultAcmBaseClientBuilder<AcmClientBuilder, AcmClient>
implements AcmClientBuilder {
    DefaultAcmClientBuilder() {
    }

    @Override
    public DefaultAcmClientBuilder endpointProvider(AcmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AcmClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAcmClientBuilder.validateClientOptions(clientConfiguration);
        AcmServiceClientConfiguration serviceClientConfiguration = AcmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultAcmClient(serviceClientConfiguration, clientConfiguration);
    }
}

