/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyUsageName {
    DIGITAL_SIGNATURE("DIGITAL_SIGNATURE"),
    NON_REPUDIATION("NON_REPUDIATION"),
    KEY_ENCIPHERMENT("KEY_ENCIPHERMENT"),
    DATA_ENCIPHERMENT("DATA_ENCIPHERMENT"),
    KEY_AGREEMENT("KEY_AGREEMENT"),
    CERTIFICATE_SIGNING("CERTIFICATE_SIGNING"),
    CRL_SIGNING("CRL_SIGNING"),
    ENCIPHER_ONLY("ENCIPHER_ONLY"),
    DECIPHER_ONLY("DECIPHER_ONLY"),
    ANY("ANY"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyUsageName> VALUE_MAP;
    private final String value;

    private KeyUsageName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyUsageName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyUsageName> knownValues() {
        EnumSet<KeyUsageName> knownValues = EnumSet.allOf(KeyUsageName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyUsageName.class, KeyUsageName::toString);
    }
}

