/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for HTTP-based domain validation of certificates requested through CloudFront and issued by ACM.
 * This field exists only when the certificate type is <code>AMAZON_ISSUED</code> and the validation method is
 * <code>HTTP</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRedirect implements SdkPojo, Serializable, ToCopyableBuilder<HttpRedirect.Builder, HttpRedirect> {
    private static final SdkField<String> REDIRECT_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectFrom").getter(getter(HttpRedirect::redirectFrom)).setter(setter(Builder::redirectFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectFrom").build()).build();

    private static final SdkField<String> REDIRECT_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RedirectTo").getter(getter(HttpRedirect::redirectTo)).setter(setter(Builder::redirectTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDIRECT_FROM_FIELD,
            REDIRECT_TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String redirectFrom;

    private final String redirectTo;

    private HttpRedirect(BuilderImpl builder) {
        this.redirectFrom = builder.redirectFrom;
        this.redirectTo = builder.redirectTo;
    }

    /**
     * <p>
     * The URL including the domain to be validated. The certificate authority sends <code>GET</code> requests here
     * during validation.
     * </p>
     * 
     * @return The URL including the domain to be validated. The certificate authority sends <code>GET</code> requests
     *         here during validation.
     */
    public final String redirectFrom() {
        return redirectFrom;
    }

    /**
     * <p>
     * The URL hosting the validation token. <code>RedirectFrom</code> must return this content or redirect here.
     * </p>
     * 
     * @return The URL hosting the validation token. <code>RedirectFrom</code> must return this content or redirect
     *         here.
     */
    public final String redirectTo() {
        return redirectTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(redirectFrom());
        hashCode = 31 * hashCode + Objects.hashCode(redirectTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRedirect)) {
            return false;
        }
        HttpRedirect other = (HttpRedirect) obj;
        return Objects.equals(redirectFrom(), other.redirectFrom()) && Objects.equals(redirectTo(), other.redirectTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpRedirect").add("RedirectFrom", redirectFrom()).add("RedirectTo", redirectTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RedirectFrom":
            return Optional.ofNullable(clazz.cast(redirectFrom()));
        case "RedirectTo":
            return Optional.ofNullable(clazz.cast(redirectTo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RedirectFrom", REDIRECT_FROM_FIELD);
        map.put("RedirectTo", REDIRECT_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpRedirect, T> g) {
        return obj -> g.apply((HttpRedirect) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRedirect> {
        /**
         * <p>
         * The URL including the domain to be validated. The certificate authority sends <code>GET</code> requests here
         * during validation.
         * </p>
         * 
         * @param redirectFrom
         *        The URL including the domain to be validated. The certificate authority sends <code>GET</code>
         *        requests here during validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectFrom(String redirectFrom);

        /**
         * <p>
         * The URL hosting the validation token. <code>RedirectFrom</code> must return this content or redirect here.
         * </p>
         * 
         * @param redirectTo
         *        The URL hosting the validation token. <code>RedirectFrom</code> must return this content or redirect
         *        here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectTo(String redirectTo);
    }

    static final class BuilderImpl implements Builder {
        private String redirectFrom;

        private String redirectTo;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRedirect model) {
            redirectFrom(model.redirectFrom);
            redirectTo(model.redirectTo);
        }

        public final String getRedirectFrom() {
            return redirectFrom;
        }

        public final void setRedirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
        }

        @Override
        public final Builder redirectFrom(String redirectFrom) {
            this.redirectFrom = redirectFrom;
            return this;
        }

        public final String getRedirectTo() {
            return redirectTo;
        }

        public final void setRedirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
        }

        @Override
        public final Builder redirectTo(String redirectTo) {
            this.redirectTo = redirectTo;
            return this;
        }

        @Override
        public HttpRedirect build() {
            return new HttpRedirect(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
