/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the X.509 <code>CertificatePolicies</code> extension.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyInformation.Builder, PolicyInformation> {
    private static final SdkField<String> CERT_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertPolicyId").getter(getter(PolicyInformation::certPolicyId)).setter(setter(Builder::certPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertPolicyId").build()).build();

    private static final SdkField<List<PolicyQualifierInfo>> POLICY_QUALIFIERS_FIELD = SdkField
            .<List<PolicyQualifierInfo>> builder(MarshallingType.LIST)
            .memberName("PolicyQualifiers")
            .getter(getter(PolicyInformation::policyQualifiers))
            .setter(setter(Builder::policyQualifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyQualifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyQualifierInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyQualifierInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERT_POLICY_ID_FIELD,
            POLICY_QUALIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certPolicyId;

    private final List<PolicyQualifierInfo> policyQualifiers;

    private PolicyInformation(BuilderImpl builder) {
        this.certPolicyId = builder.certPolicyId;
        this.policyQualifiers = builder.policyQualifiers;
    }

    /**
     * <p>
     * Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For more
     * information, see NIST's definition of <a href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object
     * Identifier (OID)</a>.
     * </p>
     * 
     * @return Specifies the object identifier (OID) of the certificate policy under which the certificate was issued.
     *         For more information, see NIST's definition of <a
     *         href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
     */
    public final String certPolicyId() {
        return certPolicyId;
    }

    /**
     * Returns true if the PolicyQualifiers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPolicyQualifiers() {
        return policyQualifiers != null && !(policyQualifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification practice
     * statement (CPS) qualifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyQualifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification
     *         practice statement (CPS) qualifier.
     */
    public final List<PolicyQualifierInfo> policyQualifiers() {
        return policyQualifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyQualifiers() ? policyQualifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation other = (PolicyInformation) obj;
        return Objects.equals(certPolicyId(), other.certPolicyId()) && hasPolicyQualifiers() == other.hasPolicyQualifiers()
                && Objects.equals(policyQualifiers(), other.policyQualifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyInformation").add("CertPolicyId", certPolicyId())
                .add("PolicyQualifiers", hasPolicyQualifiers() ? policyQualifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertPolicyId":
            return Optional.ofNullable(clazz.cast(certPolicyId()));
        case "PolicyQualifiers":
            return Optional.ofNullable(clazz.cast(policyQualifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyInformation, T> g) {
        return obj -> g.apply((PolicyInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyInformation> {
        /**
         * <p>
         * Specifies the object identifier (OID) of the certificate policy under which the certificate was issued. For
         * more information, see NIST's definition of <a
         * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * </p>
         * 
         * @param certPolicyId
         *        Specifies the object identifier (OID) of the certificate policy under which the certificate was
         *        issued. For more information, see NIST's definition of <a
         *        href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certPolicyId(String certPolicyId);

        /**
         * <p>
         * Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification
         * practice statement (CPS) qualifier.
         * </p>
         * 
         * @param policyQualifiers
         *        Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
         *        certification practice statement (CPS) qualifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyQualifiers(Collection<PolicyQualifierInfo> policyQualifiers);

        /**
         * <p>
         * Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification
         * practice statement (CPS) qualifier.
         * </p>
         * 
         * @param policyQualifiers
         *        Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the
         *        certification practice statement (CPS) qualifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyQualifiers(PolicyQualifierInfo... policyQualifiers);

        /**
         * <p>
         * Modifies the given <code>CertPolicyId</code> with a qualifier. ACM Private CA supports the certification
         * practice statement (CPS) qualifier.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyQualifierInfo>.Builder} avoiding the
         * need to create one manually via {@link List<PolicyQualifierInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyQualifierInfo>.Builder#build()} is called immediately
         * and its result is passed to {@link #policyQualifiers(List<PolicyQualifierInfo>)}.
         * 
         * @param policyQualifiers
         *        a consumer that will call methods on {@link List<PolicyQualifierInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyQualifiers(List<PolicyQualifierInfo>)
         */
        Builder policyQualifiers(Consumer<PolicyQualifierInfo.Builder>... policyQualifiers);
    }

    static final class BuilderImpl implements Builder {
        private String certPolicyId;

        private List<PolicyQualifierInfo> policyQualifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyInformation model) {
            certPolicyId(model.certPolicyId);
            policyQualifiers(model.policyQualifiers);
        }

        public final String getCertPolicyId() {
            return certPolicyId;
        }

        @Override
        public final Builder certPolicyId(String certPolicyId) {
            this.certPolicyId = certPolicyId;
            return this;
        }

        public final void setCertPolicyId(String certPolicyId) {
            this.certPolicyId = certPolicyId;
        }

        public final List<PolicyQualifierInfo.Builder> getPolicyQualifiers() {
            List<PolicyQualifierInfo.Builder> result = PolicyQualifierInfoListCopier.copyToBuilder(this.policyQualifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policyQualifiers(Collection<PolicyQualifierInfo> policyQualifiers) {
            this.policyQualifiers = PolicyQualifierInfoListCopier.copy(policyQualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyQualifiers(PolicyQualifierInfo... policyQualifiers) {
            policyQualifiers(Arrays.asList(policyQualifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyQualifiers(Consumer<PolicyQualifierInfo.Builder>... policyQualifiers) {
            policyQualifiers(Stream.of(policyQualifiers).map(c -> PolicyQualifierInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyQualifiers(Collection<PolicyQualifierInfo.BuilderImpl> policyQualifiers) {
            this.policyQualifiers = PolicyQualifierInfoListCopier.copyFromBuilder(policyQualifiers);
        }

        @Override
        public PolicyInformation build() {
            return new PolicyInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
