/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPolicyRequest extends AcmPcaRequest implements
        ToCopyableBuilder<PutPolicyRequest.Builder, PutPolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutPolicyRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Policy")
            .getter(getter(PutPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            POLICY_FIELD));

    private final String resourceArn;

    private final String policy;

    private PutPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be found
     * by calling the <a
     * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html"
     * >ListCertificateAuthorities</a> action.
     * </p>
     * <p/>
     * 
     * @return The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be
     *         found by calling the <a
     *         href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html"
     *         >ListCertificateAuthorities</a> action.
     *         </p>
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this
     * policy does not contain all required statements or if it includes any statement that is not allowed, the
     * <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM policy
     * and statement structure, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of
     * JSON Policies</a>.
     * </p>
     * 
     * @return The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If
     *         this policy does not contain all required statements or if it includes any statement that is not allowed,
     *         the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about
     *         IAM policy and statement structure, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json"
     *         >Overview of JSON Policies</a>.
     */
    public final String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPolicyRequest)) {
            return false;
        }
        PutPolicyRequest other = (PutPolicyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPolicyRequest").add("ResourceArn", resourceArn()).add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPolicyRequest, T> g) {
        return obj -> g.apply((PutPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutPolicyRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can be
         * found by calling the <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html"
         * >ListCertificateAuthorities</a> action.
         * </p>
         * <p/>
         * 
         * @param resourceArn
         *        The Amazon Resource Number (ARN) of the private CA to associate with the policy. The ARN of the CA can
         *        be found by calling the <a
         *        href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html"
         *        >ListCertificateAuthorities</a> action.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource. If this
         * policy does not contain all required statements or if it includes any statement that is not allowed, the
         * <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For information about IAM
         * policy and statement structure, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json">Overview of
         * JSON Policies</a>.
         * </p>
         * 
         * @param policy
         *        The path and file name of a JSON-formatted IAM policy to attach to the specified private CA resource.
         *        If this policy does not contain all required statements or if it includes any statement that is not
         *        allowed, the <code>PutPolicy</code> action returns an <code>InvalidPolicyException</code>. For
         *        information about IAM policy and statement structure, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json"
         *        >Overview of JSON Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPolicyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            policy(model.policy);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPolicyRequest build() {
            return new PutPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
