/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCertificateAuthorityRequest extends AcmPcaRequest implements
        ToCopyableBuilder<UpdateCertificateAuthorityRequest.Builder, UpdateCertificateAuthorityRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityArn").getter(getter(UpdateCertificateAuthorityRequest::certificateAuthorityArn))
            .setter(setter(Builder::certificateAuthorityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build())
            .build();

    private static final SdkField<RevocationConfiguration> REVOCATION_CONFIGURATION_FIELD = SdkField
            .<RevocationConfiguration> builder(MarshallingType.SDK_POJO).memberName("RevocationConfiguration")
            .getter(getter(UpdateCertificateAuthorityRequest::revocationConfiguration))
            .setter(setter(Builder::revocationConfiguration)).constructor(RevocationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateCertificateAuthorityRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_FIELD, REVOCATION_CONFIGURATION_FIELD, STATUS_FIELD));

    private final String certificateAuthorityArn;

    private final RevocationConfiguration revocationConfiguration;

    private final String status;

    private UpdateCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.revocationConfiguration = builder.revocationConfiguration;
        this.status = builder.status;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the form:
     * </p>
     * <p>
     * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of
     *         the form:</p>
     *         <p>
     *         <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
     */
    public final String certificateAuthorityArn() {
        return certificateAuthorityArn;
    }

    /**
     * <p>
     * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate
     * revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing
     * capibilites remain unchanged. For more information, see the <a
     * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html">OcspConfiguration</a>
     * and <a
     * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a>
     * types.
     * </p>
     * 
     * @return Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate
     *         revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing
     *         capibilites remain unchanged. For more information, see the <a
     *         href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html"
     *         >OcspConfiguration</a> and <a
     *         href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html"
     *         >CrlConfiguration</a> types.
     */
    public final RevocationConfiguration revocationConfiguration() {
        return revocationConfiguration;
    }

    /**
     * <p>
     * Status of your private CA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateAuthorityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of your private CA.
     * @see CertificateAuthorityStatus
     */
    public final CertificateAuthorityStatus status() {
        return CertificateAuthorityStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of your private CA.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateAuthorityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of your private CA.
     * @see CertificateAuthorityStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(revocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateAuthorityRequest)) {
            return false;
        }
        UpdateCertificateAuthorityRequest other = (UpdateCertificateAuthorityRequest) obj;
        return Objects.equals(certificateAuthorityArn(), other.certificateAuthorityArn())
                && Objects.equals(revocationConfiguration(), other.revocationConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCertificateAuthorityRequest").add("CertificateAuthorityArn", certificateAuthorityArn())
                .add("RevocationConfiguration", revocationConfiguration()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArn":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArn()));
        case "RevocationConfiguration":
            return Optional.ofNullable(clazz.cast(revocationConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((UpdateCertificateAuthorityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCertificateAuthorityRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be of the
         * form:
         * </p>
         * <p>
         * <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * </p>
         * 
         * @param certificateAuthorityArn
         *        Amazon Resource Name (ARN) of the private CA that issued the certificate to be revoked. This must be
         *        of the form:</p>
         *        <p>
         *        <code>arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArn(String certificateAuthorityArn);

        /**
         * <p>
         * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate
         * revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing
         * capibilites remain unchanged. For more information, see the <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html"
         * >OcspConfiguration</a> and <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a>
         * types.
         * </p>
         * 
         * @param revocationConfiguration
         *        Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a
         *        certificate revocation list (CRL), to enable both, or to enable neither. If this parameter is not
         *        supplied, existing capibilites remain unchanged. For more information, see the <a
         *        href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html"
         *        >OcspConfiguration</a> and <a
         *        href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html"
         *        >CrlConfiguration</a> types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revocationConfiguration(RevocationConfiguration revocationConfiguration);

        /**
         * <p>
         * Contains information to enable Online Certificate Status Protocol (OCSP) support, to enable a certificate
         * revocation list (CRL), to enable both, or to enable neither. If this parameter is not supplied, existing
         * capibilites remain unchanged. For more information, see the <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html"
         * >OcspConfiguration</a> and <a
         * href="https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html">CrlConfiguration</a>
         * types.
         * </p>
         * This is a convenience method that creates an instance of the {@link RevocationConfiguration.Builder} avoiding
         * the need to create one manually via {@link RevocationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RevocationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #revocationConfiguration(RevocationConfiguration)}.
         * 
         * @param revocationConfiguration
         *        a consumer that will call methods on {@link RevocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revocationConfiguration(RevocationConfiguration)
         */
        default Builder revocationConfiguration(Consumer<RevocationConfiguration.Builder> revocationConfiguration) {
            return revocationConfiguration(RevocationConfiguration.builder().applyMutation(revocationConfiguration).build());
        }

        /**
         * <p>
         * Status of your private CA.
         * </p>
         * 
         * @param status
         *        Status of your private CA.
         * @see CertificateAuthorityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateAuthorityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of your private CA.
         * </p>
         * 
         * @param status
         *        Status of your private CA.
         * @see CertificateAuthorityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateAuthorityStatus
         */
        Builder status(CertificateAuthorityStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private String certificateAuthorityArn;

        private RevocationConfiguration revocationConfiguration;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateAuthorityRequest model) {
            super(model);
            certificateAuthorityArn(model.certificateAuthorityArn);
            revocationConfiguration(model.revocationConfiguration);
            status(model.status);
        }

        public final String getCertificateAuthorityArn() {
            return certificateAuthorityArn;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final RevocationConfiguration.Builder getRevocationConfiguration() {
            return revocationConfiguration != null ? revocationConfiguration.toBuilder() : null;
        }

        public final void setRevocationConfiguration(RevocationConfiguration.BuilderImpl revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration != null ? revocationConfiguration.build() : null;
        }

        @Override
        public final Builder revocationConfiguration(RevocationConfiguration revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateAuthorityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateAuthorityRequest build() {
            return new UpdateCertificateAuthorityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
