/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificateAuthoritiesResponse extends AcmPcaResponse implements
        ToCopyableBuilder<ListCertificateAuthoritiesResponse.Builder, ListCertificateAuthoritiesResponse> {
    private static final SdkField<List<CertificateAuthority>> CERTIFICATE_AUTHORITIES_FIELD = SdkField
            .<List<CertificateAuthority>> builder(MarshallingType.LIST)
            .memberName("CertificateAuthorities")
            .getter(getter(ListCertificateAuthoritiesResponse::certificateAuthorities))
            .setter(setter(Builder::certificateAuthorities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CertificateAuthority> builder(MarshallingType.SDK_POJO)
                                            .constructor(CertificateAuthority::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCertificateAuthoritiesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CertificateAuthority> certificateAuthorities;

    private final String nextToken;

    private ListCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorities = builder.certificateAuthorities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateAuthorities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCertificateAuthorities() {
        return certificateAuthorities != null && !(certificateAuthorities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about each certificate authority you have created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateAuthorities} method.
     * </p>
     * 
     * @return Summary information about each certificate authority you have created.
     */
    public final List<CertificateAuthority> certificateAuthorities() {
        return certificateAuthorities;
    }

    /**
     * <p>
     * When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter in
     * a subsequent pagination request.
     * </p>
     * 
     * @return When the list is truncated, this value is present and should be used for the <code>NextToken</code>
     *         parameter in a subsequent pagination request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateAuthorities() ? certificateAuthorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateAuthoritiesResponse)) {
            return false;
        }
        ListCertificateAuthoritiesResponse other = (ListCertificateAuthoritiesResponse) obj;
        return hasCertificateAuthorities() == other.hasCertificateAuthorities()
                && Objects.equals(certificateAuthorities(), other.certificateAuthorities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCertificateAuthoritiesResponse")
                .add("CertificateAuthorities", hasCertificateAuthorities() ? certificateAuthorities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorities":
            return Optional.ofNullable(clazz.cast(certificateAuthorities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListCertificateAuthoritiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCertificateAuthoritiesResponse> {
        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * 
         * @param certificateAuthorities
         *        Summary information about each certificate authority you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorities(Collection<CertificateAuthority> certificateAuthorities);

        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * 
         * @param certificateAuthorities
         *        Summary information about each certificate authority you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorities(CertificateAuthority... certificateAuthorities);

        /**
         * <p>
         * Summary information about each certificate authority you have created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CertificateAuthority>.Builder} avoiding the
         * need to create one manually via {@link List<CertificateAuthority>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CertificateAuthority>.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateAuthorities(List<CertificateAuthority>)}.
         * 
         * @param certificateAuthorities
         *        a consumer that will call methods on {@link List<CertificateAuthority>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateAuthorities(List<CertificateAuthority>)
         */
        Builder certificateAuthorities(Consumer<CertificateAuthority.Builder>... certificateAuthorities);

        /**
         * <p>
         * When the list is truncated, this value is present and should be used for the <code>NextToken</code> parameter
         * in a subsequent pagination request.
         * </p>
         * 
         * @param nextToken
         *        When the list is truncated, this value is present and should be used for the <code>NextToken</code>
         *        parameter in a subsequent pagination request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AcmPcaResponse.BuilderImpl implements Builder {
        private List<CertificateAuthority> certificateAuthorities = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateAuthoritiesResponse model) {
            super(model);
            certificateAuthorities(model.certificateAuthorities);
            nextToken(model.nextToken);
        }

        public final List<CertificateAuthority.Builder> getCertificateAuthorities() {
            List<CertificateAuthority.Builder> result = CertificateAuthoritiesCopier.copyToBuilder(this.certificateAuthorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateAuthorities(Collection<CertificateAuthority.BuilderImpl> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copyFromBuilder(certificateAuthorities);
        }

        @Override
        @Transient
        public final Builder certificateAuthorities(Collection<CertificateAuthority> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copy(certificateAuthorities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder certificateAuthorities(CertificateAuthority... certificateAuthorities) {
            certificateAuthorities(Arrays.asList(certificateAuthorities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder certificateAuthorities(Consumer<CertificateAuthority.Builder>... certificateAuthorities) {
            certificateAuthorities(Stream.of(certificateAuthorities)
                    .map(c -> CertificateAuthority.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCertificateAuthoritiesResponse build() {
            return new ListCertificateAuthoritiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
