/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Modifies the <code>CertPolicyId</code> of a <code>PolicyInformation</code> object with a qualifier. ACM Private CA
 * supports the certification practice statement (CPS) qualifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyQualifierInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyQualifierInfo.Builder, PolicyQualifierInfo> {
    private static final SdkField<String> POLICY_QUALIFIER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyQualifierId").getter(getter(PolicyQualifierInfo::policyQualifierIdAsString))
            .setter(setter(Builder::policyQualifierId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyQualifierId").build()).build();

    private static final SdkField<Qualifier> QUALIFIER_FIELD = SdkField.<Qualifier> builder(MarshallingType.SDK_POJO)
            .memberName("Qualifier").getter(getter(PolicyQualifierInfo::qualifier)).setter(setter(Builder::qualifier))
            .constructor(Qualifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Qualifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_QUALIFIER_ID_FIELD,
            QUALIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String policyQualifierId;

    private final Qualifier qualifier;

    private PolicyQualifierInfo(BuilderImpl builder) {
        this.policyQualifierId = builder.policyQualifierId;
        this.qualifier = builder.qualifier;
    }

    /**
     * <p>
     * Identifies the qualifier modifying a <code>CertPolicyId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyQualifierId}
     * will return {@link PolicyQualifierId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyQualifierIdAsString}.
     * </p>
     * 
     * @return Identifies the qualifier modifying a <code>CertPolicyId</code>.
     * @see PolicyQualifierId
     */
    public final PolicyQualifierId policyQualifierId() {
        return PolicyQualifierId.fromValue(policyQualifierId);
    }

    /**
     * <p>
     * Identifies the qualifier modifying a <code>CertPolicyId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyQualifierId}
     * will return {@link PolicyQualifierId#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #policyQualifierIdAsString}.
     * </p>
     * 
     * @return Identifies the qualifier modifying a <code>CertPolicyId</code>.
     * @see PolicyQualifierId
     */
    public final String policyQualifierIdAsString() {
        return policyQualifierId;
    }

    /**
     * <p>
     * Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this field.
     * </p>
     * 
     * @return Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this field.
     */
    public final Qualifier qualifier() {
        return qualifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyQualifierIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyQualifierInfo)) {
            return false;
        }
        PolicyQualifierInfo other = (PolicyQualifierInfo) obj;
        return Objects.equals(policyQualifierIdAsString(), other.policyQualifierIdAsString())
                && Objects.equals(qualifier(), other.qualifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyQualifierInfo").add("PolicyQualifierId", policyQualifierIdAsString())
                .add("Qualifier", qualifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyQualifierId":
            return Optional.ofNullable(clazz.cast(policyQualifierIdAsString()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyQualifierInfo, T> g) {
        return obj -> g.apply((PolicyQualifierInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyQualifierInfo> {
        /**
         * <p>
         * Identifies the qualifier modifying a <code>CertPolicyId</code>.
         * </p>
         * 
         * @param policyQualifierId
         *        Identifies the qualifier modifying a <code>CertPolicyId</code>.
         * @see PolicyQualifierId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyQualifierId
         */
        Builder policyQualifierId(String policyQualifierId);

        /**
         * <p>
         * Identifies the qualifier modifying a <code>CertPolicyId</code>.
         * </p>
         * 
         * @param policyQualifierId
         *        Identifies the qualifier modifying a <code>CertPolicyId</code>.
         * @see PolicyQualifierId
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyQualifierId
         */
        Builder policyQualifierId(PolicyQualifierId policyQualifierId);

        /**
         * <p>
         * Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this field.
         * </p>
         * 
         * @param qualifier
         *        Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(Qualifier qualifier);

        /**
         * <p>
         * Defines the qualifier type. ACM Private CA supports the use of a URI for a CPS qualifier in this field.
         * </p>
         * This is a convenience that creates an instance of the {@link Qualifier.Builder} avoiding the need to create
         * one manually via {@link Qualifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link Qualifier.Builder#build()} is called immediately and its result
         * is passed to {@link #qualifier(Qualifier)}.
         * 
         * @param qualifier
         *        a consumer that will call methods on {@link Qualifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qualifier(Qualifier)
         */
        default Builder qualifier(Consumer<Qualifier.Builder> qualifier) {
            return qualifier(Qualifier.builder().applyMutation(qualifier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String policyQualifierId;

        private Qualifier qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyQualifierInfo model) {
            policyQualifierId(model.policyQualifierId);
            qualifier(model.qualifier);
        }

        public final String getPolicyQualifierId() {
            return policyQualifierId;
        }

        public final void setPolicyQualifierId(String policyQualifierId) {
            this.policyQualifierId = policyQualifierId;
        }

        @Override
        @Transient
        public final Builder policyQualifierId(String policyQualifierId) {
            this.policyQualifierId = policyQualifierId;
            return this;
        }

        @Override
        @Transient
        public final Builder policyQualifierId(PolicyQualifierId policyQualifierId) {
            this.policyQualifierId(policyQualifierId == null ? null : policyQualifierId.toString());
            return this;
        }

        public final Qualifier.Builder getQualifier() {
            return qualifier != null ? qualifier.toBuilder() : null;
        }

        public final void setQualifier(Qualifier.BuilderImpl qualifier) {
            this.qualifier = qualifier != null ? qualifier.build() : null;
        }

        @Override
        @Transient
        public final Builder qualifier(Qualifier qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        @Override
        public PolicyQualifierInfo build() {
            return new PolicyQualifierInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
