/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a custom ASN.1 X.400 <code>GeneralName</code> using an object identifier (OID) and value. The OID must
 * satisfy the regular expression shown below. For more information, see NIST's definition of <a
 * href="https://csrc.nist.gov/glossary/term/Object_Identifier">Object Identifier (OID)</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OtherName implements SdkPojo, Serializable, ToCopyableBuilder<OtherName.Builder, OtherName> {
    private static final SdkField<String> TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TypeId")
            .getter(getter(OtherName::typeId)).setter(setter(Builder::typeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeId").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(OtherName::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_ID_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typeId;

    private final String value;

    private OtherName(BuilderImpl builder) {
        this.typeId = builder.typeId;
        this.value = builder.value;
    }

    /**
     * <p>
     * Specifies an OID.
     * </p>
     * 
     * @return Specifies an OID.
     */
    public final String typeId() {
        return typeId;
    }

    /**
     * <p>
     * Specifies an OID value.
     * </p>
     * 
     * @return Specifies an OID value.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeId());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OtherName)) {
            return false;
        }
        OtherName other = (OtherName) obj;
        return Objects.equals(typeId(), other.typeId()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OtherName").add("TypeId", typeId()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeId":
            return Optional.ofNullable(clazz.cast(typeId()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OtherName, T> g) {
        return obj -> g.apply((OtherName) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OtherName> {
        /**
         * <p>
         * Specifies an OID.
         * </p>
         * 
         * @param typeId
         *        Specifies an OID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeId(String typeId);

        /**
         * <p>
         * Specifies an OID value.
         * </p>
         * 
         * @param value
         *        Specifies an OID value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String typeId;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(OtherName model) {
            typeId(model.typeId);
            value(model.value);
        }

        public final String getTypeId() {
            return typeId;
        }

        public final void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        @Override
        public final Builder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public OtherName build() {
            return new OtherName(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
