/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.acmpca.model.AcmPcaResponse;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthoritiesCopier;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificateAuthoritiesResponse
extends AcmPcaResponse
implements ToCopyableBuilder<Builder, ListCertificateAuthoritiesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificateAuthoritiesResponse.getter(ListCertificateAuthoritiesResponse::nextToken)).setter(ListCertificateAuthoritiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<CertificateAuthority>> CERTIFICATE_AUTHORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CertificateAuthorities").getter(ListCertificateAuthoritiesResponse.getter(ListCertificateAuthoritiesResponse::certificateAuthorities)).setter(ListCertificateAuthoritiesResponse.setter(Builder::certificateAuthorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateAuthority::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CERTIFICATE_AUTHORITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CertificateAuthorities", CERTIFICATE_AUTHORITIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<CertificateAuthority> certificateAuthorities;

    private ListCertificateAuthoritiesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificateAuthorities = builder.certificateAuthorities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCertificateAuthorities() {
        return this.certificateAuthorities != null && !(this.certificateAuthorities instanceof SdkAutoConstructList);
    }

    public final List<CertificateAuthority> certificateAuthorities() {
        return this.certificateAuthorities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificateAuthorities() ? this.certificateAuthorities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateAuthoritiesResponse)) {
            return false;
        }
        ListCertificateAuthoritiesResponse other = (ListCertificateAuthoritiesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCertificateAuthorities() == other.hasCertificateAuthorities() && Objects.equals(this.certificateAuthorities(), other.certificateAuthorities());
    }

    public final String toString() {
        return ToString.builder((String)"ListCertificateAuthoritiesResponse").add("NextToken", (Object)this.nextToken()).add("CertificateAuthorities", this.hasCertificateAuthorities() ? this.certificateAuthorities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CertificateAuthorities": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateAuthoritiesResponse, T> g) {
        return obj -> g.apply((ListCertificateAuthoritiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CertificateAuthority> certificateAuthorities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateAuthoritiesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.certificateAuthorities(model.certificateAuthorities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CertificateAuthority.Builder> getCertificateAuthorities() {
            List<CertificateAuthority.Builder> result = CertificateAuthoritiesCopier.copyToBuilder(this.certificateAuthorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificateAuthorities(Collection<CertificateAuthority.BuilderImpl> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copyFromBuilder(certificateAuthorities);
        }

        @Override
        public final Builder certificateAuthorities(Collection<CertificateAuthority> certificateAuthorities) {
            this.certificateAuthorities = CertificateAuthoritiesCopier.copy(certificateAuthorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorities(CertificateAuthority ... certificateAuthorities) {
            this.certificateAuthorities(Arrays.asList(certificateAuthorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorities(Consumer<CertificateAuthority.Builder> ... certificateAuthorities) {
            this.certificateAuthorities(Stream.of(certificateAuthorities).map(c -> (CertificateAuthority)((CertificateAuthority.Builder)CertificateAuthority.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCertificateAuthoritiesResponse build() {
            return new ListCertificateAuthoritiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AcmPcaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificateAuthoritiesResponse> {
        public Builder nextToken(String var1);

        public Builder certificateAuthorities(Collection<CertificateAuthority> var1);

        public Builder certificateAuthorities(CertificateAuthority ... var1);

        public Builder certificateAuthorities(Consumer<CertificateAuthority.Builder> ... var1);
    }
}

