/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information for the default behavior of the CRL Distribution Point (CDP) extension in
 * certificates issued by your CA. This extension contains a link to download the CRL, so you can check whether a
 * certificate has been revoked. To choose whether you want this extension omitted or not in certificates issued by your
 * CA, you can set the <b>OmitExtension</b> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrlDistributionPointExtensionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CrlDistributionPointExtensionConfiguration.Builder, CrlDistributionPointExtensionConfiguration> {
    private static final SdkField<Boolean> OMIT_EXTENSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OmitExtension").getter(getter(CrlDistributionPointExtensionConfiguration::omitExtension))
            .setter(setter(Builder::omitExtension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OmitExtension").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OMIT_EXTENSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean omitExtension;

    private CrlDistributionPointExtensionConfiguration(BuilderImpl builder) {
        this.omitExtension = builder.omitExtension;
    }

    /**
     * <p>
     * Configures whether the CRL Distribution Point extension should be populated with the default URL to the CRL. If
     * set to <code>true</code>, then the CDP extension will not be present in any certificates issued by that CA unless
     * otherwise specified through CSR or API passthrough.
     * </p>
     * <note>
     * <p>
     * Only set this if you have another way to distribute the CRL Distribution Points ffor certificates issued by your
     * CA, such as the Matter Distributed Compliance Ledger
     * </p>
     * <p>
     * This configuration cannot be enabled with a custom CNAME set.
     * </p>
     * </note>
     * 
     * @return Configures whether the CRL Distribution Point extension should be populated with the default URL to the
     *         CRL. If set to <code>true</code>, then the CDP extension will not be present in any certificates issued
     *         by that CA unless otherwise specified through CSR or API passthrough.</p> <note>
     *         <p>
     *         Only set this if you have another way to distribute the CRL Distribution Points ffor certificates issued
     *         by your CA, such as the Matter Distributed Compliance Ledger
     *         </p>
     *         <p>
     *         This configuration cannot be enabled with a custom CNAME set.
     *         </p>
     */
    public final Boolean omitExtension() {
        return omitExtension;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(omitExtension());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrlDistributionPointExtensionConfiguration)) {
            return false;
        }
        CrlDistributionPointExtensionConfiguration other = (CrlDistributionPointExtensionConfiguration) obj;
        return Objects.equals(omitExtension(), other.omitExtension());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrlDistributionPointExtensionConfiguration").add("OmitExtension", omitExtension()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OmitExtension":
            return Optional.ofNullable(clazz.cast(omitExtension()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OmitExtension", OMIT_EXTENSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrlDistributionPointExtensionConfiguration, T> g) {
        return obj -> g.apply((CrlDistributionPointExtensionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrlDistributionPointExtensionConfiguration> {
        /**
         * <p>
         * Configures whether the CRL Distribution Point extension should be populated with the default URL to the CRL.
         * If set to <code>true</code>, then the CDP extension will not be present in any certificates issued by that CA
         * unless otherwise specified through CSR or API passthrough.
         * </p>
         * <note>
         * <p>
         * Only set this if you have another way to distribute the CRL Distribution Points ffor certificates issued by
         * your CA, such as the Matter Distributed Compliance Ledger
         * </p>
         * <p>
         * This configuration cannot be enabled with a custom CNAME set.
         * </p>
         * </note>
         * 
         * @param omitExtension
         *        Configures whether the CRL Distribution Point extension should be populated with the default URL to
         *        the CRL. If set to <code>true</code>, then the CDP extension will not be present in any certificates
         *        issued by that CA unless otherwise specified through CSR or API passthrough.</p> <note>
         *        <p>
         *        Only set this if you have another way to distribute the CRL Distribution Points ffor certificates
         *        issued by your CA, such as the Matter Distributed Compliance Ledger
         *        </p>
         *        <p>
         *        This configuration cannot be enabled with a custom CNAME set.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder omitExtension(Boolean omitExtension);
    }

    static final class BuilderImpl implements Builder {
        private Boolean omitExtension;

        private BuilderImpl() {
        }

        private BuilderImpl(CrlDistributionPointExtensionConfiguration model) {
            omitExtension(model.omitExtension);
        }

        public final Boolean getOmitExtension() {
            return omitExtension;
        }

        public final void setOmitExtension(Boolean omitExtension) {
            this.omitExtension = omitExtension;
        }

        @Override
        public final Builder omitExtension(Boolean omitExtension) {
            this.omitExtension = omitExtension;
            return this;
        }

        @Override
        public CrlDistributionPointExtensionConfiguration build() {
            return new CrlDistributionPointExtensionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
