/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 * <p>
 * Specifies the X.509 extension information for a certificate.
 * </p>
 * <p>
 * Extensions present in <code>CustomExtensions</code> follow the <code>ApiPassthrough</code> <a
 * href="https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html#template-order-of-operations"
 * >template rules</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomExtension implements SdkPojo, Serializable, ToCopyableBuilder<CustomExtension.Builder, CustomExtension> {
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectIdentifier").getter(getter(CustomExtension::objectIdentifier))
            .setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CustomExtension::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Critical").getter(getter(CustomExtension::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIER_FIELD,
            VALUE_FIELD, CRITICAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectIdentifier;

    private final String value;

    private final Boolean critical;

    private CustomExtension(BuilderImpl builder) {
        this.objectIdentifier = builder.objectIdentifier;
        this.value = builder.value;
        this.critical = builder.critical;
    }

    /**
     * <p/>
     * <p>
     * Specifies the object identifier (OID) of the X.509 extension. For more information, see the <a
     * href="https://oidref.com/2.5.29">Global OID reference database.</a>
     * </p>
     * 
     * @return <p>
     *         Specifies the object identifier (OID) of the X.509 extension. For more information, see the <a
     *         href="https://oidref.com/2.5.29">Global OID reference database.</a>
     */
    public final String objectIdentifier() {
        return objectIdentifier;
    }

    /**
     * <p/>
     * <p>
     * Specifies the base64-encoded value of the X.509 extension.
     * </p>
     * 
     * @return <p>
     *         Specifies the base64-encoded value of the X.509 extension.
     */
    public final String value() {
        return value;
    }

    /**
     * <p/>
     * <p>
     * Specifies the critical flag of the X.509 extension.
     * </p>
     * 
     * @return <p>
     *         Specifies the critical flag of the X.509 extension.
     */
    public final Boolean critical() {
        return critical;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomExtension)) {
            return false;
        }
        CustomExtension other = (CustomExtension) obj;
        return Objects.equals(objectIdentifier(), other.objectIdentifier()) && Objects.equals(value(), other.value())
                && Objects.equals(critical(), other.critical());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomExtension").add("ObjectIdentifier", objectIdentifier()).add("Value", value())
                .add("Critical", critical()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Critical":
            return Optional.ofNullable(clazz.cast(critical()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectIdentifier", OBJECT_IDENTIFIER_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Critical", CRITICAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomExtension, T> g) {
        return obj -> g.apply((CustomExtension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomExtension> {
        /**
         * <p/>
         * <p>
         * Specifies the object identifier (OID) of the X.509 extension. For more information, see the <a
         * href="https://oidref.com/2.5.29">Global OID reference database.</a>
         * </p>
         * 
         * @param objectIdentifier
         *        <p>
         *        Specifies the object identifier (OID) of the X.509 extension. For more information, see the <a
         *        href="https://oidref.com/2.5.29">Global OID reference database.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);

        /**
         * <p/>
         * <p>
         * Specifies the base64-encoded value of the X.509 extension.
         * </p>
         * 
         * @param value
         *        <p>
         *        Specifies the base64-encoded value of the X.509 extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p/>
         * <p>
         * Specifies the critical flag of the X.509 extension.
         * </p>
         * 
         * @param critical
         *        <p>
         *        Specifies the critical flag of the X.509 extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Boolean critical);
    }

    static final class BuilderImpl implements Builder {
        private String objectIdentifier;

        private String value;

        private Boolean critical;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomExtension model) {
            objectIdentifier(model.objectIdentifier);
            value(model.value);
            critical(model.critical);
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Boolean getCritical() {
            return critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        @Override
        public CustomExtension build() {
            return new CustomExtension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
