/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificateAuthoritiesRequest extends AcmPcaRequest implements
        ToCopyableBuilder<ListCertificateAuthoritiesRequest.Builder, ListCertificateAuthoritiesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCertificateAuthoritiesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCertificateAuthoritiesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceOwner").getter(getter(ListCertificateAuthoritiesRequest::resourceOwnerAsString))
            .setter(setter(Builder::resourceOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCE_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceOwner;

    private ListCertificateAuthoritiesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceOwner = builder.resourceOwner;
    }

    /**
     * <p>
     * Use this parameter when paginating results to specify the maximum number of items to return in the response on
     * each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in
     * the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.
     * </p>
     * <p>
     * Although the maximum value is 1000, the action only returns a maximum of 100 items.
     * </p>
     * 
     * @return Use this parameter when paginating results to specify the maximum number of items to return in the
     *         response on each page. If additional items exist beyond the number you specify, the
     *         <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a
     *         subsequent request to retrieve additional items.</p>
     *         <p>
     *         Although the maximum value is 1000, the action only returns a maximum of 100 items.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Use this parameter when paginating results in a subsequent request after you receive a response with truncated
     * results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.
     * </p>
     * 
     * @return Use this parameter when paginating results in a subsequent request after you receive a response with
     *         truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
     *         received.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Use this parameter to filter the returned set of certificate authorities based on their owner. The default is
     * SELF.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return Use this parameter to filter the returned set of certificate authorities based on their owner. The
     *         default is SELF.
     * @see ResourceOwner
     */
    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(resourceOwner);
    }

    /**
     * <p>
     * Use this parameter to filter the returned set of certificate authorities based on their owner. The default is
     * SELF.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceOwner}
     * will return {@link ResourceOwner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceOwnerAsString}.
     * </p>
     * 
     * @return Use this parameter to filter the returned set of certificate authorities based on their owner. The
     *         default is SELF.
     * @see ResourceOwner
     */
    public final String resourceOwnerAsString() {
        return resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateAuthoritiesRequest)) {
            return false;
        }
        ListCertificateAuthoritiesRequest other = (ListCertificateAuthoritiesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceOwnerAsString(), other.resourceOwnerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCertificateAuthoritiesRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ResourceOwner", resourceOwnerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceOwner":
            return Optional.ofNullable(clazz.cast(resourceOwnerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResourceOwner", RESOURCE_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateAuthoritiesRequest, T> g) {
        return obj -> g.apply((ListCertificateAuthoritiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AcmPcaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCertificateAuthoritiesRequest> {
        /**
         * <p>
         * Use this parameter when paginating results to specify the maximum number of items to return in the response
         * on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is
         * sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional
         * items.
         * </p>
         * <p>
         * Although the maximum value is 1000, the action only returns a maximum of 100 items.
         * </p>
         * 
         * @param maxResults
         *        Use this parameter when paginating results to specify the maximum number of items to return in the
         *        response on each page. If additional items exist beyond the number you specify, the
         *        <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a
         *        subsequent request to retrieve additional items.</p>
         *        <p>
         *        Although the maximum value is 1000, the action only returns a maximum of 100 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Use this parameter when paginating results in a subsequent request after you receive a response with
         * truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just
         * received.
         * </p>
         * 
         * @param nextToken
         *        Use this parameter when paginating results in a subsequent request after you receive a response with
         *        truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you
         *        just received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Use this parameter to filter the returned set of certificate authorities based on their owner. The default is
         * SELF.
         * </p>
         * 
         * @param resourceOwner
         *        Use this parameter to filter the returned set of certificate authorities based on their owner. The
         *        default is SELF.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(String resourceOwner);

        /**
         * <p>
         * Use this parameter to filter the returned set of certificate authorities based on their owner. The default is
         * SELF.
         * </p>
         * 
         * @param resourceOwner
         *        Use this parameter to filter the returned set of certificate authorities based on their owner. The
         *        default is SELF.
         * @see ResourceOwner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceOwner
         */
        Builder resourceOwner(ResourceOwner resourceOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AcmPcaRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateAuthoritiesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceOwner(model.resourceOwner);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceOwner() {
            return resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCertificateAuthoritiesRequest build() {
            return new ListCertificateAuthoritiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
