/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information to enable and configure Online Certificate Status Protocol (OCSP) for validating certificate
 * revocation status.
 * </p>
 * <p>
 * When you revoke a certificate, OCSP responses may take up to 60 minutes to reflect the new status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OcspConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OcspConfiguration.Builder, OcspConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(OcspConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> OCSP_CUSTOM_CNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OcspCustomCname").getter(getter(OcspConfiguration::ocspCustomCname))
            .setter(setter(Builder::ocspCustomCname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OcspCustomCname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            OCSP_CUSTOM_CNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String ocspCustomCname;

    private OcspConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.ocspCustomCname = builder.ocspCustomCname;
    }

    /**
     * <p>
     * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation status.
     * </p>
     * 
     * @return Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation
     *         status.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * By default, Amazon Web Services Private CA injects an Amazon Web Services domain into certificates being
     * validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to
     * define a CNAME specifying a customized OCSP domain.
     * </p>
     * <note>
     * <p>
     * The content of a Canonical Name (CNAME) record must conform to <a
     * href="https://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> restrictions on the use of special characters in URIs.
     * Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or "https://".
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/privateca/latest/userguide/ocsp-customize.html">Customizing Online Certificate
     * Status Protocol (OCSP) </a> in the <i>Amazon Web Services Private Certificate Authority User Guide</i>.
     * </p>
     * 
     * @return By default, Amazon Web Services Private CA injects an Amazon Web Services domain into certificates being
     *         validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object
     *         to define a CNAME specifying a customized OCSP domain.</p> <note>
     *         <p>
     *         The content of a Canonical Name (CNAME) record must conform to <a
     *         href="https://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> restrictions on the use of special characters in
     *         URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or
     *         "https://".
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/privateca/latest/userguide/ocsp-customize.html">Customizing Online
     *         Certificate Status Protocol (OCSP) </a> in the <i>Amazon Web Services Private Certificate Authority User
     *         Guide</i>.
     */
    public final String ocspCustomCname() {
        return ocspCustomCname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(ocspCustomCname());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OcspConfiguration)) {
            return false;
        }
        OcspConfiguration other = (OcspConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(ocspCustomCname(), other.ocspCustomCname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OcspConfiguration").add("Enabled", enabled()).add("OcspCustomCname", ocspCustomCname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "OcspCustomCname":
            return Optional.ofNullable(clazz.cast(ocspCustomCname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("OcspCustomCname", OCSP_CUSTOM_CNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OcspConfiguration, T> g) {
        return obj -> g.apply((OcspConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OcspConfiguration> {
        /**
         * <p>
         * Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate revocation
         * status.
         * </p>
         * 
         * @param enabled
         *        Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating certificate
         *        revocation status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * By default, Amazon Web Services Private CA injects an Amazon Web Services domain into certificates being
         * validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use this object to
         * define a CNAME specifying a customized OCSP domain.
         * </p>
         * <note>
         * <p>
         * The content of a Canonical Name (CNAME) record must conform to <a
         * href="https://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> restrictions on the use of special characters in
         * URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or
         * "https://".
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/privateca/latest/userguide/ocsp-customize.html">Customizing Online
         * Certificate Status Protocol (OCSP) </a> in the <i>Amazon Web Services Private Certificate Authority User
         * Guide</i>.
         * </p>
         * 
         * @param ocspCustomCname
         *        By default, Amazon Web Services Private CA injects an Amazon Web Services domain into certificates
         *        being validated by the Online Certificate Status Protocol (OCSP). A customer can alternatively use
         *        this object to define a CNAME specifying a customized OCSP domain.</p> <note>
         *        <p>
         *        The content of a Canonical Name (CNAME) record must conform to <a
         *        href="https://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> restrictions on the use of special characters
         *        in URIs. Additionally, the value of the CNAME must not include a protocol prefix such as "http://" or
         *        "https://".
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/privateca/latest/userguide/ocsp-customize.html">Customizing Online
         *        Certificate Status Protocol (OCSP) </a> in the <i>Amazon Web Services Private Certificate Authority
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocspCustomCname(String ocspCustomCname);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String ocspCustomCname;

        private BuilderImpl() {
        }

        private BuilderImpl(OcspConfiguration model) {
            enabled(model.enabled);
            ocspCustomCname(model.ocspCustomCname);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getOcspCustomCname() {
            return ocspCustomCname;
        }

        public final void setOcspCustomCname(String ocspCustomCname) {
            this.ocspCustomCname = ocspCustomCname;
        }

        @Override
        public final Builder ocspCustomCname(String ocspCustomCname) {
            this.ocspCustomCname = ocspCustomCname;
            return this;
        }

        @Override
        public OcspConfiguration build() {
            return new OcspConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
