/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.acmpca.AcmPcaAsyncClient;
import software.amazon.awssdk.services.acmpca.AcmPcaServiceClientConfiguration;
import software.amazon.awssdk.services.acmpca.internal.AcmPcaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.acmpca.model.AcmPcaException;
import software.amazon.awssdk.services.acmpca.model.CertificateMismatchException;
import software.amazon.awssdk.services.acmpca.model.ConcurrentModificationException;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.CreateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.CreatePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DeleteCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePermissionResponse;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyRequest;
import software.amazon.awssdk.services.acmpca.model.DeletePolicyResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityAuditReportResponse;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.DescribeCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateAuthorityCsrResponse;
import software.amazon.awssdk.services.acmpca.model.GetCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.GetCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.GetPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.GetPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.ImportCertificateAuthorityCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.InvalidArgsException;
import software.amazon.awssdk.services.acmpca.model.InvalidArnException;
import software.amazon.awssdk.services.acmpca.model.InvalidNextTokenException;
import software.amazon.awssdk.services.acmpca.model.InvalidPolicyException;
import software.amazon.awssdk.services.acmpca.model.InvalidRequestException;
import software.amazon.awssdk.services.acmpca.model.InvalidStateException;
import software.amazon.awssdk.services.acmpca.model.InvalidTagException;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.IssueCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.LimitExceededException;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsRequest;
import software.amazon.awssdk.services.acmpca.model.ListPermissionsResponse;
import software.amazon.awssdk.services.acmpca.model.ListTagsRequest;
import software.amazon.awssdk.services.acmpca.model.ListTagsResponse;
import software.amazon.awssdk.services.acmpca.model.LockoutPreventedException;
import software.amazon.awssdk.services.acmpca.model.MalformedCertificateException;
import software.amazon.awssdk.services.acmpca.model.MalformedCsrException;
import software.amazon.awssdk.services.acmpca.model.PermissionAlreadyExistsException;
import software.amazon.awssdk.services.acmpca.model.PutPolicyRequest;
import software.amazon.awssdk.services.acmpca.model.PutPolicyResponse;
import software.amazon.awssdk.services.acmpca.model.RequestAlreadyProcessedException;
import software.amazon.awssdk.services.acmpca.model.RequestFailedException;
import software.amazon.awssdk.services.acmpca.model.RequestInProgressException;
import software.amazon.awssdk.services.acmpca.model.ResourceNotFoundException;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.RestoreCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateRequest;
import software.amazon.awssdk.services.acmpca.model.RevokeCertificateResponse;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.TagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.TooManyTagsException;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UntagCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityRequest;
import software.amazon.awssdk.services.acmpca.model.UpdateCertificateAuthorityResponse;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.CreatePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeleteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePermissionRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityAuditReportRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.DescribeCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateAuthorityCsrRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ImportCertificateAuthorityCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.IssueCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.PutPolicyRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RestoreCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.RevokeCertificateRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.TagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UntagCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.transform.UpdateCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.acmpca.waiters.AcmPcaAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultAcmPcaAsyncClient
implements AcmPcaAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAcmPcaAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultAcmPcaAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"ACM_PCA#2.31.78").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<CreateCertificateAuthorityResponse> createCertificateAuthority(CreateCertificateAuthorityRequest createCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, createCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$createCertificateAuthority$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$createCertificateAuthority$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCertificateAuthorityAuditReportResponse> createCertificateAuthorityAuditReport(CreateCertificateAuthorityAuditReportRequest createCertificateAuthorityAuditReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCertificateAuthorityAuditReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, createCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificateAuthorityAuditReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateAuthorityAuditReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificateAuthorityAuditReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCertificateAuthorityAuditReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$createCertificateAuthorityAuditReport$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$createCertificateAuthorityAuditReport$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePermissionResponse> createPermission(CreatePermissionRequest createPermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, createPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$createPermission$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$createPermission$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCertificateAuthorityResponse> deleteCertificateAuthority(DeleteCertificateAuthorityRequest deleteCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$deleteCertificateAuthority$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$deleteCertificateAuthority$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePermissionResponse> deletePermission(DeletePermissionRequest deletePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, deletePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$deletePermission$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$deletePermission$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePolicyResponse> deletePolicy(DeletePolicyRequest deletePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, deletePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$deletePolicy$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$deletePolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificateAuthorityResponse> describeCertificateAuthority(DescribeCertificateAuthorityRequest describeCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, describeCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$describeCertificateAuthority$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$describeCertificateAuthority$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCertificateAuthorityAuditReportResponse> describeCertificateAuthorityAuditReport(DescribeCertificateAuthorityAuditReportRequest describeCertificateAuthorityAuditReportRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCertificateAuthorityAuditReportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, describeCertificateAuthorityAuditReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCertificateAuthorityAuditReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCertificateAuthorityAuditReportResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCertificateAuthorityAuditReport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCertificateAuthorityAuditReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCertificateAuthorityAuditReportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$describeCertificateAuthorityAuditReport$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$describeCertificateAuthorityAuditReport$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificateResponse> getCertificate(GetCertificateRequest getCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, getCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$getCertificate$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$getCertificate$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificateAuthorityCertificateResponse> getCertificateAuthorityCertificate(GetCertificateAuthorityCertificateRequest getCertificateAuthorityCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateAuthorityCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, getCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificateAuthorityCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$getCertificateAuthorityCertificate$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$getCertificateAuthorityCertificate$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificateAuthorityCsrResponse> getCertificateAuthorityCsr(GetCertificateAuthorityCsrRequest getCertificateAuthorityCsrRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCertificateAuthorityCsrRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, getCertificateAuthorityCsrRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificateAuthorityCsr");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificateAuthorityCsrResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificateAuthorityCsr").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCertificateAuthorityCsrRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificateAuthorityCsrRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$getCertificateAuthorityCsr$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$getCertificateAuthorityCsr$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, getPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$getPolicy$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$getPolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportCertificateAuthorityCertificateResponse> importCertificateAuthorityCertificate(ImportCertificateAuthorityCertificateRequest importCertificateAuthorityCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importCertificateAuthorityCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, importCertificateAuthorityCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportCertificateAuthorityCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportCertificateAuthorityCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportCertificateAuthorityCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportCertificateAuthorityCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importCertificateAuthorityCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$importCertificateAuthorityCertificate$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$importCertificateAuthorityCertificate$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<IssueCertificateResponse> issueCertificate(IssueCertificateRequest issueCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)issueCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, issueCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IssueCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IssueCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IssueCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new IssueCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)issueCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$issueCertificate$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$issueCertificate$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCertificateAuthoritiesResponse> listCertificateAuthorities(ListCertificateAuthoritiesRequest listCertificateAuthoritiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCertificateAuthoritiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, listCertificateAuthoritiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCertificateAuthorities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCertificateAuthoritiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCertificateAuthorities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCertificateAuthoritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCertificateAuthoritiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$listCertificateAuthorities$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$listCertificateAuthorities$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPermissionsResponse> listPermissions(ListPermissionsRequest listPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$listPermissions$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$listPermissions$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$listTags$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$listTags$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutPolicyResponse> putPolicy(PutPolicyRequest putPolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, putPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$putPolicy$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$putPolicy$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreCertificateAuthorityResponse> restoreCertificateAuthority(RestoreCertificateAuthorityRequest restoreCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, restoreCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$restoreCertificateAuthority$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$restoreCertificateAuthority$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeCertificateResponse> revokeCertificate(RevokeCertificateRequest revokeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeCertificateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, revokeCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeCertificate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$revokeCertificate$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$revokeCertificate$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagCertificateAuthorityResponse> tagCertificateAuthority(TagCertificateAuthorityRequest tagCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, tagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$tagCertificateAuthority$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$tagCertificateAuthority$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagCertificateAuthorityResponse> untagCertificateAuthority(UntagCertificateAuthorityRequest untagCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, untagCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$untagCertificateAuthority$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$untagCertificateAuthority$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCertificateAuthorityResponse> updateCertificateAuthority(UpdateCertificateAuthorityRequest updateCertificateAuthorityRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCertificateAuthorityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultAcmPcaAsyncClient.resolveMetricPublishers(clientConfiguration, updateCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ACM PCA");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCertificateAuthorityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "MalformedCSRException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCSRException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCsrException::builder).build());
                    }
                    case "InvalidRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                    }
                    case "InvalidArgsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgsException::builder).build());
                    }
                    case "InvalidArnException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArnException::builder).build());
                    }
                    case "RequestInProgressException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestInProgressException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestInProgressException::builder).build());
                    }
                    case "LockoutPreventedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LockoutPreventedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LockoutPreventedException::builder).build());
                    }
                    case "InvalidStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidStateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidStateException::builder).build());
                    }
                    case "PermissionAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PermissionAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PermissionAlreadyExistsException::builder).build());
                    }
                    case "RequestAlreadyProcessedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestAlreadyProcessedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestAlreadyProcessedException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "InvalidTagException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagException::builder).build());
                    }
                    case "CertificateMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CertificateMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CertificateMismatchException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "InvalidPolicyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPolicyException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "MalformedCertificateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("MalformedCertificateException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MalformedCertificateException::builder).build());
                    }
                    case "RequestFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestFailedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestFailedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCertificateAuthority").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCertificateAuthorityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultAcmPcaAsyncClient.lambda$updateCertificateAuthority$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultAcmPcaAsyncClient.lambda$updateCertificateAuthority$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public AcmPcaAsyncWaiter waiter() {
        return AcmPcaAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final AcmPcaServiceClientConfiguration serviceClientConfiguration() {
        return new AcmPcaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "acm-pca";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AcmPcaException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AcmPcaServiceClientConfigurationBuilder serviceConfigBuilder = new AcmPcaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCertificateAuthority$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCertificateAuthority$90(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagCertificateAuthority$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagCertificateAuthority$86(List metricPublishers, MetricCollector apiCallMetricCollector, UntagCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagCertificateAuthority$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagCertificateAuthority$82(List metricPublishers, MetricCollector apiCallMetricCollector, TagCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeCertificate$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeCertificate$78(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreCertificateAuthority$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreCertificateAuthority$74(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putPolicy$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPolicy$70(List metricPublishers, MetricCollector apiCallMetricCollector, PutPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTags$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTags$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPermissions$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListPermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCertificateAuthorities$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCertificateAuthorities$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListCertificateAuthoritiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$issueCertificate$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$issueCertificate$54(List metricPublishers, MetricCollector apiCallMetricCollector, IssueCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importCertificateAuthorityCertificate$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importCertificateAuthorityCertificate$50(List metricPublishers, MetricCollector apiCallMetricCollector, ImportCertificateAuthorityCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPolicy$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPolicy$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCsr$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCsr$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificateAuthorityCsrResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCertificate$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificateAuthorityCertificate$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificateAuthorityCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificate$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificate$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCertificateAuthorityAuditReport$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthorityAuditReport$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCertificateAuthorityAuditReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCertificateAuthority$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCertificateAuthority$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePolicy$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePermission$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePermission$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCertificateAuthority$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificateAuthority$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPermission$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPermission$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCertificateAuthorityAuditReport$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthorityAuditReport$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCertificateAuthorityAuditReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCertificateAuthority$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificateAuthority$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCertificateAuthorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

