/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.aiops.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInvestigationGroupResponse extends AiOpsResponse implements
        ToCopyableBuilder<GetInvestigationGroupResponse.Builder, GetInvestigationGroupResponse> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetInvestigationGroupResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(GetInvestigationGroupResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedBy").getter(getter(GetInvestigationGroupResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedAt").getter(getter(GetInvestigationGroupResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetInvestigationGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetInvestigationGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetInvestigationGroupResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(GetInvestigationGroupResponse::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<Long> RETENTION_IN_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("retentionInDays").getter(getter(GetInvestigationGroupResponse::retentionInDays))
            .setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()).build();

    private static final SdkField<Map<String, List<String>>> CHATBOT_NOTIFICATION_CHANNEL_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("chatbotNotificationChannel")
            .getter(getter(GetInvestigationGroupResponse::chatbotNotificationChannel))
            .setter(setter(Builder::chatbotNotificationChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotNotificationChannel").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_KEY_BOUNDARIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("tagKeyBoundaries")
            .getter(getter(GetInvestigationGroupResponse::tagKeyBoundaries))
            .setter(setter(Builder::tagKeyBoundaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyBoundaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isCloudTrailEventHistoryEnabled")
            .getter(getter(GetInvestigationGroupResponse::isCloudTrailEventHistoryEnabled))
            .setter(setter(Builder::isCloudTrailEventHistoryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isCloudTrailEventHistoryEnabled")
                    .build()).build();

    private static final SdkField<List<CrossAccountConfiguration>> CROSS_ACCOUNT_CONFIGURATIONS_FIELD = SdkField
            .<List<CrossAccountConfiguration>> builder(MarshallingType.LIST)
            .memberName("crossAccountConfigurations")
            .getter(getter(GetInvestigationGroupResponse::crossAccountConfigurations))
            .setter(setter(Builder::crossAccountConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrossAccountConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrossAccountConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            CREATED_AT_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_AT_FIELD, NAME_FIELD, ARN_FIELD, ROLE_ARN_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, RETENTION_IN_DAYS_FIELD, CHATBOT_NOTIFICATION_CHANNEL_FIELD,
            TAG_KEY_BOUNDARIES_FIELD, IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD, CROSS_ACCOUNT_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String createdBy;

    private final Long createdAt;

    private final String lastModifiedBy;

    private final Long lastModifiedAt;

    private final String name;

    private final String arn;

    private final String roleArn;

    private final EncryptionConfiguration encryptionConfiguration;

    private final Long retentionInDays;

    private final Map<String, List<String>> chatbotNotificationChannel;

    private final List<String> tagKeyBoundaries;

    private final Boolean isCloudTrailEventHistoryEnabled;

    private final List<CrossAccountConfiguration> crossAccountConfigurations;

    private GetInvestigationGroupResponse(BuilderImpl builder) {
        super(builder);
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.name = builder.name;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.retentionInDays = builder.retentionInDays;
        this.chatbotNotificationChannel = builder.chatbotNotificationChannel;
        this.tagKeyBoundaries = builder.tagKeyBoundaries;
        this.isCloudTrailEventHistoryEnabled = builder.isCloudTrailEventHistoryEnabled;
        this.crossAccountConfigurations = builder.crossAccountConfigurations;
    }

    /**
     * <p>
     * The name of the user who created the investigation group.
     * </p>
     * 
     * @return The name of the user who created the investigation group.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the investigation group was created.
     * </p>
     * 
     * @return The date and time that the investigation group was created.
     */
    public final Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the user who created the investigation group.
     * </p>
     * 
     * @return The name of the user who created the investigation group.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The date and time that the investigation group was most recently modified.
     * </p>
     * 
     * @return The date and time that the investigation group was most recently modified.
     */
    public final Long lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The name of the investigation group.
     * </p>
     * 
     * @return The name of the investigation group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the investigation group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the investigation group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ARN of the IAM role that the investigation group uses for permissions to gather data.
     * </p>
     * 
     * @return The ARN of the IAM role that the investigation group uses for permissions to gather data.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specifies the customer managed KMS key that the investigation group uses to encrypt data, if there is one. If
     * not, the investigation group uses an Amazon Web Services key to encrypt the data.
     * </p>
     * 
     * @return Specifies the customer managed KMS key that the investigation group uses to encrypt data, if there is
     *         one. If not, the investigation group uses an Amazon Web Services key to encrypt the data.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Specifies how long that investigation data is kept.
     * </p>
     * 
     * @return Specifies how long that investigation data is kept.
     */
    public final Long retentionInDays() {
        return retentionInDays;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChatbotNotificationChannel property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChatbotNotificationChannel() {
        return chatbotNotificationChannel != null && !(chatbotNotificationChannel instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This structure is a string array. The first string is the ARN of a Amazon SNS topic. The array of strings display
     * the ARNs of chat applications configurations that are associated with that topic. For more information about
     * these configuration ARNs, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with Amazon Q
     * in chat applications</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
     * >Resource type defined by Amazon Web Services Chatbot</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChatbotNotificationChannel} method.
     * </p>
     * 
     * @return This structure is a string array. The first string is the ARN of a Amazon SNS topic. The array of strings
     *         display the ARNs of chat applications configurations that are associated with that topic. For more
     *         information about these configuration ARNs, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with
     *         Amazon Q in chat applications</a> and <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
     *         >Resource type defined by Amazon Web Services Chatbot</a>.
     */
    public final Map<String, List<String>> chatbotNotificationChannel() {
        return chatbotNotificationChannel;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeyBoundaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagKeyBoundaries() {
        return tagKeyBoundaries != null && !(tagKeyBoundaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Displays the custom tag keys for custom applications in your system that you have specified in the investigation
     * group. Resource tags help CloudWatch investigations narrow the search space when it is unable to discover
     * definite relationships between resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeyBoundaries} method.
     * </p>
     * 
     * @return Displays the custom tag keys for custom applications in your system that you have specified in the
     *         investigation group. Resource tags help CloudWatch investigations narrow the search space when it is
     *         unable to discover definite relationships between resources.
     */
    public final List<String> tagKeyBoundaries() {
        return tagKeyBoundaries;
    }

    /**
     * <p>
     * Specifies whether CloudWatch investigationshas access to change events that are recorded by CloudTrail.
     * </p>
     * 
     * @return Specifies whether CloudWatch investigationshas access to change events that are recorded by CloudTrail.
     */
    public final Boolean isCloudTrailEventHistoryEnabled() {
        return isCloudTrailEventHistoryEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossAccountConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCrossAccountConfigurations() {
        return crossAccountConfigurations != null && !(crossAccountConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the results of the
     * last scan performed on each account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossAccountConfigurations} method.
     * </p>
     * 
     * @return Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the results
     *         of the last scan performed on each account.
     */
    public final List<CrossAccountConfiguration> crossAccountConfigurations() {
        return crossAccountConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(hasChatbotNotificationChannel() ? chatbotNotificationChannel() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeyBoundaries() ? tagKeyBoundaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isCloudTrailEventHistoryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasCrossAccountConfigurations() ? crossAccountConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvestigationGroupResponse)) {
            return false;
        }
        GetInvestigationGroupResponse other = (GetInvestigationGroupResponse) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(retentionInDays(), other.retentionInDays())
                && hasChatbotNotificationChannel() == other.hasChatbotNotificationChannel()
                && Objects.equals(chatbotNotificationChannel(), other.chatbotNotificationChannel())
                && hasTagKeyBoundaries() == other.hasTagKeyBoundaries()
                && Objects.equals(tagKeyBoundaries(), other.tagKeyBoundaries())
                && Objects.equals(isCloudTrailEventHistoryEnabled(), other.isCloudTrailEventHistoryEnabled())
                && hasCrossAccountConfigurations() == other.hasCrossAccountConfigurations()
                && Objects.equals(crossAccountConfigurations(), other.crossAccountConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInvestigationGroupResponse").add("CreatedBy", createdBy()).add("CreatedAt", createdAt())
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedAt", lastModifiedAt()).add("Name", name())
                .add("Arn", arn()).add("RoleArn", roleArn()).add("EncryptionConfiguration", encryptionConfiguration())
                .add("RetentionInDays", retentionInDays())
                .add("ChatbotNotificationChannel", hasChatbotNotificationChannel() ? chatbotNotificationChannel() : null)
                .add("TagKeyBoundaries", hasTagKeyBoundaries() ? tagKeyBoundaries() : null)
                .add("IsCloudTrailEventHistoryEnabled", isCloudTrailEventHistoryEnabled())
                .add("CrossAccountConfigurations", hasCrossAccountConfigurations() ? crossAccountConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "retentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        case "chatbotNotificationChannel":
            return Optional.ofNullable(clazz.cast(chatbotNotificationChannel()));
        case "tagKeyBoundaries":
            return Optional.ofNullable(clazz.cast(tagKeyBoundaries()));
        case "isCloudTrailEventHistoryEnabled":
            return Optional.ofNullable(clazz.cast(isCloudTrailEventHistoryEnabled()));
        case "crossAccountConfigurations":
            return Optional.ofNullable(clazz.cast(crossAccountConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("chatbotNotificationChannel", CHATBOT_NOTIFICATION_CHANNEL_FIELD);
        map.put("tagKeyBoundaries", TAG_KEY_BOUNDARIES_FIELD);
        map.put("isCloudTrailEventHistoryEnabled", IS_CLOUD_TRAIL_EVENT_HISTORY_ENABLED_FIELD);
        map.put("crossAccountConfigurations", CROSS_ACCOUNT_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInvestigationGroupResponse, T> g) {
        return obj -> g.apply((GetInvestigationGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AiOpsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInvestigationGroupResponse> {
        /**
         * <p>
         * The name of the user who created the investigation group.
         * </p>
         * 
         * @param createdBy
         *        The name of the user who created the investigation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the investigation group was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the investigation group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * The name of the user who created the investigation group.
         * </p>
         * 
         * @param lastModifiedBy
         *        The name of the user who created the investigation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * The date and time that the investigation group was most recently modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time that the investigation group was most recently modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Long lastModifiedAt);

        /**
         * <p>
         * The name of the investigation group.
         * </p>
         * 
         * @param name
         *        The name of the investigation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the investigation group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the investigation group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ARN of the IAM role that the investigation group uses for permissions to gather data.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that the investigation group uses for permissions to gather data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specifies the customer managed KMS key that the investigation group uses to encrypt data, if there is one. If
         * not, the investigation group uses an Amazon Web Services key to encrypt the data.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Specifies the customer managed KMS key that the investigation group uses to encrypt data, if there is
         *        one. If not, the investigation group uses an Amazon Web Services key to encrypt the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Specifies the customer managed KMS key that the investigation group uses to encrypt data, if there is one. If
         * not, the investigation group uses an Amazon Web Services key to encrypt the data.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * Specifies how long that investigation data is kept.
         * </p>
         * 
         * @param retentionInDays
         *        Specifies how long that investigation data is kept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Long retentionInDays);

        /**
         * <p>
         * This structure is a string array. The first string is the ARN of a Amazon SNS topic. The array of strings
         * display the ARNs of chat applications configurations that are associated with that topic. For more
         * information about these configuration ARNs, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with Amazon
         * Q in chat applications</a> and <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
         * >Resource type defined by Amazon Web Services Chatbot</a>.
         * </p>
         * 
         * @param chatbotNotificationChannel
         *        This structure is a string array. The first string is the ARN of a Amazon SNS topic. The array of
         *        strings display the ARNs of chat applications configurations that are associated with that topic. For
         *        more information about these configuration ARNs, see <a
         *        href="https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html">Getting started with
         *        Amazon Q in chat applications</a> and <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies"
         *        >Resource type defined by Amazon Web Services Chatbot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel);

        /**
         * <p>
         * Displays the custom tag keys for custom applications in your system that you have specified in the
         * investigation group. Resource tags help CloudWatch investigations narrow the search space when it is unable
         * to discover definite relationships between resources.
         * </p>
         * 
         * @param tagKeyBoundaries
         *        Displays the custom tag keys for custom applications in your system that you have specified in the
         *        investigation group. Resource tags help CloudWatch investigations narrow the search space when it is
         *        unable to discover definite relationships between resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries);

        /**
         * <p>
         * Displays the custom tag keys for custom applications in your system that you have specified in the
         * investigation group. Resource tags help CloudWatch investigations narrow the search space when it is unable
         * to discover definite relationships between resources.
         * </p>
         * 
         * @param tagKeyBoundaries
         *        Displays the custom tag keys for custom applications in your system that you have specified in the
         *        investigation group. Resource tags help CloudWatch investigations narrow the search space when it is
         *        unable to discover definite relationships between resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeyBoundaries(String... tagKeyBoundaries);

        /**
         * <p>
         * Specifies whether CloudWatch investigationshas access to change events that are recorded by CloudTrail.
         * </p>
         * 
         * @param isCloudTrailEventHistoryEnabled
         *        Specifies whether CloudWatch investigationshas access to change events that are recorded by
         *        CloudTrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled);

        /**
         * <p>
         * Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the results of
         * the last scan performed on each account.
         * </p>
         * 
         * @param crossAccountConfigurations
         *        Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the
         *        results of the last scan performed on each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> crossAccountConfigurations);

        /**
         * <p>
         * Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the results of
         * the last scan performed on each account.
         * </p>
         * 
         * @param crossAccountConfigurations
         *        Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the
         *        results of the last scan performed on each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountConfigurations(CrossAccountConfiguration... crossAccountConfigurations);

        /**
         * <p>
         * Lists the <code>AWSAccountId</code> of the accounts configured for cross-account access and the results of
         * the last scan performed on each account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #crossAccountConfigurations(List<CrossAccountConfiguration>)}.
         * 
         * @param crossAccountConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.aiops.model.CrossAccountConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossAccountConfigurations(java.util.Collection<CrossAccountConfiguration>)
         */
        Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder>... crossAccountConfigurations);
    }

    static final class BuilderImpl extends AiOpsResponse.BuilderImpl implements Builder {
        private String createdBy;

        private Long createdAt;

        private String lastModifiedBy;

        private Long lastModifiedAt;

        private String name;

        private String arn;

        private String roleArn;

        private EncryptionConfiguration encryptionConfiguration;

        private Long retentionInDays;

        private Map<String, List<String>> chatbotNotificationChannel = DefaultSdkAutoConstructMap.getInstance();

        private List<String> tagKeyBoundaries = DefaultSdkAutoConstructList.getInstance();

        private Boolean isCloudTrailEventHistoryEnabled;

        private List<CrossAccountConfiguration> crossAccountConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvestigationGroupResponse model) {
            super(model);
            createdBy(model.createdBy);
            createdAt(model.createdAt);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedAt(model.lastModifiedAt);
            name(model.name);
            arn(model.arn);
            roleArn(model.roleArn);
            encryptionConfiguration(model.encryptionConfiguration);
            retentionInDays(model.retentionInDays);
            chatbotNotificationChannel(model.chatbotNotificationChannel);
            tagKeyBoundaries(model.tagKeyBoundaries);
            isCloudTrailEventHistoryEnabled(model.isCloudTrailEventHistoryEnabled);
            crossAccountConfigurations(model.crossAccountConfigurations);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Long getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Long lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Long lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final Long getRetentionInDays() {
            return retentionInDays;
        }

        public final void setRetentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Long retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getChatbotNotificationChannel() {
            if (chatbotNotificationChannel instanceof SdkAutoConstructMap) {
                return null;
            }
            return chatbotNotificationChannel;
        }

        public final void setChatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
        }

        @Override
        public final Builder chatbotNotificationChannel(Map<String, ? extends Collection<String>> chatbotNotificationChannel) {
            this.chatbotNotificationChannel = ChatbotNotificationChannelCopier.copy(chatbotNotificationChannel);
            return this;
        }

        public final Collection<String> getTagKeyBoundaries() {
            if (tagKeyBoundaries instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeyBoundaries;
        }

        public final void setTagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
        }

        @Override
        public final Builder tagKeyBoundaries(Collection<String> tagKeyBoundaries) {
            this.tagKeyBoundaries = TagKeyBoundariesCopier.copy(tagKeyBoundaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyBoundaries(String... tagKeyBoundaries) {
            tagKeyBoundaries(Arrays.asList(tagKeyBoundaries));
            return this;
        }

        public final Boolean getIsCloudTrailEventHistoryEnabled() {
            return isCloudTrailEventHistoryEnabled;
        }

        public final void setIsCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
        }

        @Override
        public final Builder isCloudTrailEventHistoryEnabled(Boolean isCloudTrailEventHistoryEnabled) {
            this.isCloudTrailEventHistoryEnabled = isCloudTrailEventHistoryEnabled;
            return this;
        }

        public final List<CrossAccountConfiguration.Builder> getCrossAccountConfigurations() {
            List<CrossAccountConfiguration.Builder> result = CrossAccountConfigurationsCopier
                    .copyToBuilder(this.crossAccountConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrossAccountConfigurations(
                Collection<CrossAccountConfiguration.BuilderImpl> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copyFromBuilder(crossAccountConfigurations);
        }

        @Override
        public final Builder crossAccountConfigurations(Collection<CrossAccountConfiguration> crossAccountConfigurations) {
            this.crossAccountConfigurations = CrossAccountConfigurationsCopier.copy(crossAccountConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(CrossAccountConfiguration... crossAccountConfigurations) {
            crossAccountConfigurations(Arrays.asList(crossAccountConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossAccountConfigurations(Consumer<CrossAccountConfiguration.Builder>... crossAccountConfigurations) {
            crossAccountConfigurations(Stream.of(crossAccountConfigurations)
                    .map(c -> CrossAccountConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetInvestigationGroupResponse build() {
            return new GetInvestigationGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
