/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AlreadyExistsException;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidUserStatusException;
import software.amazon.awssdk.services.alexaforbusiness.model.LimitExceededException;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NameInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.NotFoundException;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateDeviceWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateDeviceWithRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillGroupWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillGroupWithRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateProfileResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateSkillGroupResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateUserResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteProfileResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomSkillParameterResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillGroupResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteUserResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateDeviceFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateDeviceFromRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillGroupFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillGroupFromRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetProfileResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomSkillParameterResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetSkillGroupResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutRoomSkillParameterResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ResolveRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ResolveRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RevokeInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RevokeInvitationResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchDevicesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchDevicesResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchProfilesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchProfilesResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchRoomsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchRoomsResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchSkillGroupsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchSkillGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchUsersResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SendInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SendInvitationResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartDeviceSyncRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartDeviceSyncResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateProfileResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateRoomResponseUnmarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateSkillGroupResponseUnmarshaller;

/**
 * Internal implementation of {@link AlexaForBusinessClient}.
 *
 * @see AlexaForBusinessClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAlexaForBusinessClient implements AlexaForBusinessClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAlexaForBusinessClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a device to a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or a manual
     * sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDeviceWithRoomResponse associateDeviceWithRoom(AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<AssociateDeviceWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new AssociateDeviceWithRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(associateDeviceWithRoomRequest)
                .withMarshaller(new AssociateDeviceWithRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates a skill group to a given room. This enables all skills in the associated skill group on all devices in
     * the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<AssociateSkillGroupWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new AssociateSkillGroupWithRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(associateSkillGroupWithRoomRequest)
                        .withMarshaller(new AssociateSkillGroupWithRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws LimitExceededException,
            AlreadyExistsException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<CreateProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateProfileRequest, CreateProfileResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createProfileRequest).withMarshaller(new CreateProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<CreateRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateRoomRequest, CreateRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(createRoomRequest)
                .withMarshaller(new CreateRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSkillGroupResponse createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<CreateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateSkillGroupResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateSkillGroupRequest, CreateSkillGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createSkillGroupRequest).withMarshaller(new CreateSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use. HTTP Status Code: 400
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceInUseException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateUserResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(createUserRequest)
                .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<DeleteProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteProfileRequest, DeleteProfileResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteProfileRequest).withMarshaller(new DeleteProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<DeleteRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteRoomRequest, DeleteRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deleteRoomRequest)
                .withMarshaller(new DeleteRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<DeleteRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteRoomSkillParameterResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteRoomSkillParameterRequest)
                        .withMarshaller(new DeleteRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSkillGroupResponse deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<DeleteSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSkillGroupResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSkillGroupRequest, DeleteSkillGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteSkillGroupRequest).withMarshaller(new DeleteSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUserResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deleteUserRequest)
                .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<DisassociateDeviceFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DisassociateDeviceFromRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateDeviceFromRoomRequest)
                        .withMarshaller(new DisassociateDeviceFromRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<DisassociateSkillGroupFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DisassociateSkillGroupFromRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateSkillGroupFromRoomRequest)
                        .withMarshaller(new DisassociateSkillGroupFromRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDeviceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest)
                .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<GetProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetProfileRequest, GetProfileResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getProfileRequest)
                .withMarshaller(new GetProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<GetRoomResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRoomRequest, GetRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRoomRequest)
                .withMarshaller(new GetRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRoomSkillParameterResponse getRoomSkillParameter(GetRoomSkillParameterRequest getRoomSkillParameterRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<GetRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetRoomSkillParameterResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getRoomSkillParameterRequest)
                .withMarshaller(new GetRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSkillGroupResponse getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<GetSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSkillGroupResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSkillGroupRequest, GetSkillGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getSkillGroupRequest).withMarshaller(new GetSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSkillsResponse listSkills(ListSkillsRequest listSkillsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<ListSkillsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListSkillsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListSkillsRequest, ListSkillsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listSkillsRequest)
                .withMarshaller(new ListSkillsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client
     *             .listSkillsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSkillsIterable listSkillsPaginator(ListSkillsRequest listSkillsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListSkillsIterable(this, applyPaginatorUserAgent(listSkillsRequest));
    }

    /**
     * <p>
     * Lists all tags for a specific resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListTagsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest)
                .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all tags for a specific resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListTagsIterable(this, applyPaginatorUserAgent(listTagsRequest));
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRoomSkillParameterResponse putRoomSkillParameter(PutRoomSkillParameterRequest putRoomSkillParameterRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<PutRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutRoomSkillParameterResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putRoomSkillParameterRequest)
                .withMarshaller(new PutRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ResolveRoomResponse resolveRoom(ResolveRoomRequest resolveRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<ResolveRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ResolveRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ResolveRoomRequest, ResolveRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(resolveRoomRequest).withMarshaller(new ResolveRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RevokeInvitationResponse revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<RevokeInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RevokeInvitationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RevokeInvitationRequest, RevokeInvitationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(revokeInvitationRequest).withMarshaller(new RevokeInvitationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<SearchDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SearchDevicesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SearchDevicesRequest, SearchDevicesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(searchDevicesRequest).withMarshaller(new SearchDevicesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client
     *             .searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDevicesIterable searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchDevicesIterable(this, applyPaginatorUserAgent(searchDevicesRequest));
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<SearchProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SearchProfilesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SearchProfilesRequest, SearchProfilesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(searchProfilesRequest).withMarshaller(new SearchProfilesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client
     *             .searchProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProfilesIterable searchProfilesPaginator(SearchProfilesRequest searchProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchProfilesIterable(this, applyPaginatorUserAgent(searchProfilesRequest));
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchRoomsResponse searchRooms(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<SearchRoomsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SearchRoomsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SearchRoomsRequest, SearchRoomsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(searchRoomsRequest).withMarshaller(new SearchRoomsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client
     *             .searchRoomsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchRoomsIterable searchRoomsPaginator(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchRoomsIterable(this, applyPaginatorUserAgent(searchRoomsRequest));
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSkillGroupsResponse searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<SearchSkillGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SearchSkillGroupsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SearchSkillGroupsRequest, SearchSkillGroupsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(searchSkillGroupsRequest).withMarshaller(new SearchSkillGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client
     *             .searchSkillGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSkillGroupsIterable searchSkillGroupsPaginator(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchSkillGroupsIterable(this, applyPaginatorUserAgent(searchSkillGroupsRequest));
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {

        HttpResponseHandler<SearchUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SearchUsersResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SearchUsersRequest, SearchUsersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(searchUsersRequest).withMarshaller(new SearchUsersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client
     *             .searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchUsersIterable searchUsersPaginator(SearchUsersRequest searchUsersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchUsersIterable(this, applyPaginatorUserAgent(searchUsersRequest));
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 72 hours or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendInvitationResponse sendInvitation(SendInvitationRequest sendInvitationRequest) throws NotFoundException,
            InvalidUserStatusException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<SendInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SendInvitationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SendInvitationRequest, SendInvitationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(sendInvitationRequest).withMarshaller(new SendInvitationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings by clearing all information and settings set by
     * previous users.
     * </p>
     *
     * @param startDeviceSyncRequest
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDeviceSyncResponse startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<StartDeviceSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StartDeviceSyncResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StartDeviceSyncRequest, StartDeviceSyncResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(startDeviceSyncRequest).withMarshaller(new StartDeviceSyncRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new TagResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(tagResourceRequest).withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UntagResourceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(untagResourceRequest).withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<UpdateDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDeviceResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDeviceRequest, UpdateDeviceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDeviceRequest).withMarshaller(new UpdateDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws NotFoundException,
            NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<UpdateProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateProfileResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateProfileRequest, UpdateProfileResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateProfileRequest).withMarshaller(new UpdateProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws NotFoundException, NameInUseException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<UpdateRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateRoomResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateRoomRequest, UpdateRoomResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(updateRoomRequest)
                .withMarshaller(new UpdateRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found. HTTP Status Code: 400
     * @throws NameInUseException
     *         The name sent in the request is already in use. HTTP Status Code: 400
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSkillGroupResponse updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) throws NotFoundException,
            NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {

        HttpResponseHandler<UpdateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateSkillGroupResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateSkillGroupRequest, UpdateSkillGroupResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateSkillGroupRequest).withMarshaller(new UpdateSkillGroupRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(
                                software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException.class)
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                        ResourceInUseException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InvalidUserStatusException").withModeledClass(
                                        InvalidUserStatusException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NameInUseException").withModeledClass(
                                        NameInUseException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withModeledClass(
                                        AlreadyExistsException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends AlexaForBusinessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
