/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDeviceWithRoomRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<AssociateDeviceWithRoomRequest.Builder, AssociateDeviceWithRoomRequest> {
    private final String deviceArn;

    private final String roomArn;

    private AssociateDeviceWithRoomRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.roomArn = builder.roomArn;
    }

    /**
     * <p>
     * The ARN of the device to associate to a room. Required.
     * </p>
     * 
     * @return The ARN of the device to associate to a room. Required.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The ARN of the room with which to associate the device. Required.
     * </p>
     * 
     * @return The ARN of the room with which to associate the device. Required.
     */
    public String roomArn() {
        return roomArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDeviceWithRoomRequest)) {
            return false;
        }
        AssociateDeviceWithRoomRequest other = (AssociateDeviceWithRoomRequest) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(roomArn(), other.roomArn());
    }

    @Override
    public String toString() {
        return ToString.builder("AssociateDeviceWithRoomRequest").add("DeviceArn", deviceArn()).add("RoomArn", roomArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, CopyableBuilder<Builder, AssociateDeviceWithRoomRequest> {
        /**
         * <p>
         * The ARN of the device to associate to a room. Required.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to associate to a room. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The ARN of the room with which to associate the device. Required.
         * </p>
         * 
         * @param roomArn
         *        The ARN of the room with which to associate the device. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String deviceArn;

        private String roomArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDeviceWithRoomRequest model) {
            super(model);
            deviceArn(model.deviceArn);
            roomArn(model.roomArn);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDeviceWithRoomRequest build() {
            return new AssociateDeviceWithRoomRequest(this);
        }
    }
}
